-----------------------------------
-- Mining My Business (Lv5)
-----------------------------------
-- !setvar [CW]MINING_MY_BUSINESS 0
-- Iron Digger !pos 66.655 7.925 -149.454 172
-- !additem 5738
-- Reward: Pickaxe x12
-----------------------------------
-- !setvar [CW]MINING_MY_BUSINESS 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-mining_my_business")

local info =
{
    name   = "Mining My Business",
    author = "Loxley",
    var    = "[CW]MINING_MY_BUSINESS",
    reward =
    {
        item  = { { xi.item.PICKAXE, 36 } },
        after = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.fieldTunica(player)

            return true
        end,
    },
    required = 
    {
        item = 5738,
        name = "a chunk of sweet lizard",
    },
}

local GALKA      = "GALKA"
local IronDigger = "Iron Digger"

local entity =
{
    {
        id     = GALKA,
        name   = IronDigger,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B1,
            head = cexi.model.BRONZE_HARNESS,
            body = cexi.model.BRONZE_HARNESS,
            hand = cexi.model.STARTER_RSE,
            legs = cexi.model.KENPOGI,
            feet = cexi.model.STARTER_RSE,
        }),
        area   = "Zeruhn_Mines",
        pos    = { 66.655, 7.925, -149.454, 31 }, -- !pos 66.655 7.925 -149.454 172
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                "I don't have anything for you.",
            },
            START  =
            {
                { delay  = 500 },
                { entity = IronDigger, emote = xi.emote.EXCAVATION },
                "This is 'arder than it looks.",
                "Even 'arder when you're hungry as I am!",
                { delay  = 2000 },
                { entity = IronDigger, emote = xi.emote.LAUGH },
                "You want to try your hand? Hah!",
                { delay  = 2000},
                "Tell ya what, bring me a chunk of sweet lizard",
                " and I'll share some picks to 'ave a go yerself.",
            },
            REMINDER =
            {
                string.format("Bring me %s and you can 'ave those picks.", info.required.name),
            },
            ACCEPTED =
            {
                { delay = 500 },
                { entity = IronDigger, emote = xi.emote.CHEER },
                "That's the stuff!",
                { delay  = 2000 },
                "It's a deal. Here's yer pickaxes.",
                "Happy rock hittin' to the both o' us!",
            },
            DECLINED =
            {
                { entity = IronDigger, emote = xi.emote.NO },
                "I can't eat this... it's not even cooked!",
            },
            AFTER =
            {
                { entity = IronDigger, emote = xi.emote.CHEER },
                "Rock smashers forever!",
                { delay  = 1000 },
            },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true, level = 5 }),
        [GALKA]  = cq.talkStep("START", info.name),
    },
    {
        [GALKA] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item, info.reward, info.name, cexi.music.NONE),
        }
    },
    {
        [GALKA] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
