-----------------------------------
-- Crystal Prelude (Bastok) (Lv1)
-----------------------------------
-- !setvar [CW]INTRO 2
-- Iron Wolf     !pos -458.083 3.313 137.463 191
-- Mining Point  !pos -407.559 4.000 117.191
-- Iron Wolf     !pos -458.083 3.313 137.463 191
-----------------------------------
-- !setvar [CW]INTRO 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-crystal_prelude_bastok")

local info =
{
    name   = "A Crystal Prelude (Bastok)",
    author = "Loxley",
    var    = "[CW]INTRO",
    start  = { -452.215, 3.987, 133.918, 150, xi.zone.DANGRUF_WADI },
    reward =
    {
        item  = xi.item.ADVENTURER_COUPON,
        after = function(player)
            player:timer(3000, function(playerArg)
                local endPos = { -492.033, 30.919, -489.012, 240, xi.zone.SOUTH_GUSTABERG } -- !pos -492.033 30.919 -489.012 107

                playerArg:setHomePointAt(unpack(endPos))
                playerArg:setPos(unpack(endPos))
            end)

            return true
        end,
    },
}

local IRON     = "IRONWOLF"
local IronWolf = "Iron Wolf"
local ROCKS    = "ROCKS"
local BERNO    = "BERNO"

local entity =
{
    {
        id   = IRON,
        name = IronWolf,
        type = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A1,
            head = cexi.model.PLATE_ARMOR,
            body = cexi.model.PLATE_ARMOR,
            hand = cexi.model.PLATE_ARMOR,
            legs = cexi.model.PLATE_ARMOR,
            feet = cexi.model.PLATE_ARMOR,
        }),
        area = "Dangruf_Wadi",
        pos  = { -458.083, 3.313, 137.463, 25 }, -- !pos -458.083 3.313 137.463 191
        dialog =
        {
            NAME    = true,
            DEFAULT = { "Do I know you?" },
            CREATURE = { "All right, you're armed. Let's get to huntin'." },
            ESCAPE =
            {
                "*Munch*",
                "...",
                "*Burp*",
                "...",
                "Not bad...",
                " FINE. I'll show you out.",
                " Take this to Bastok. Don't say I ain't did nuthin' for ya.",
            },
            SPAWN = { "YES here it comes! Looks like crab is back on the menu!" },
        },
    },
    {
        id       = ROCKS,
        name     = "Mining Point",
        type     = xi.objType.NPC,
        look     = 2424,
        item     = { xi.item.CHUNK_OF_COPPER_ORE, "a chunk of copper ore" },
        area     = "Dangruf_Wadi",
        pos      = { -407.559, 4.000, 117.090, 0 }, --!pos -407.559 4.000 117.191
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE
        },
    },
    {
        id          = BERNO,
        name        = "Bubbly Berno",
        type        = xi.objType.MOB,
        look        = 357,
        groupId     = 18,
        groupZoneId = 191,
        area        = "Dangruf_Wadi",
        pos         = { -451.734, 4.256, 123.498, 0 }, -- !pos -451.734 4.256 123.498 191
        level       = 1,
        mods        =
        {
            [xi.mod.HPP] = -70,
        },
    },
}

local hint = cexi.crystal_warrior.intro.getHints({
    npc      = IronWolf,
    city     = "Bastok",
    tool     = "Pickaxe",
    gather   = "Mining",
    material = "a chunk of copper ore",
    point    = "Mining Point",
    ringNpc  = "Verona",
    ringZone = "Bastok Markets",
})

cexi.crystal_warrior.intro.setNextZone(m, "South_Gustaberg", hint, info.start)

local step =
{
    {
        -- Placeholder step for Provenance Intro
    },
    {
        -- Placeholder step for Provenance Intro
    },
    {
        checks = cq.checks({ cw = true }),
        [IRON] = cq.dialog({
            beginQuest = info.name,
            reward     = { { xi.item.PICKAXE, 12 } },
            name       = IronWolf,
            event      =
            {
                "Hey you! Got any food?",
                { emote = xi.emote.STAGGER },
                " I came here looking for something to eat but... Prancing Promathia! I am SO hungry.",
                { delay = 3000 },
                "BAH! You'll \"help\" ME? You don't even have a weapon!",
                { emote = xi.emote.FUME },
                { delay = 3000 },
                "Fine. Fetch some ore from that Mining Point over there and I'll... beat it into shape.",
                hint[1],
            },
        }),
    },
    {
        [IRON]  = cq.dialog({
            step  = false,
            name  = IronWolf,
            event = { "You have a pickaxe, now go check out those rocks over there!" },
        }),
        [ROCKS] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event = { "Mining is possible here if you have a pickaxe." },
            }),
            onTrade = cq.trade({
                required = xi.item.PICKAXE,
                reward   = xi.item.CHUNK_OF_COPPER_ORE,
                accepted =
                {
                    { entity = "player", emote = xi.emote.EXCAVATION },
                    hint[2],
                },
                declined = { "Mining is possible here if you have a pickaxe." },
            }),
        },
    },
    {
        [IRON] =
        {
            onTrigger = cq.dialog({
                step  = false,
                name  = IronWolf,
                event = { "You found a copper ore? Give it 'ere then." },
            }),
            onTrade   = cq.trade({
                name     = IronWolf,
                required = xi.item.CHUNK_OF_COPPER_ORE,
                declined = { "You found a copper ore? Give it 'ere then."    },
                accepted =
                {
                    "What's this? Not much to work with. Whatever.",
                    hint[3],
                },
            }),
        },
    },
    {
        [IRON] = cq.dialog({
            conditionalDialog = "job",
            conditionalReward = "job",

            name   = IronWolf,
            reward =
            {
                [xi.job.WAR] = { { xi.item.ONION_SWORD,  1 } },
                [xi.job.MNK] = { { xi.item.WHITE_BELT,   1 } },
                [xi.job.WHM] = { { xi.item.ONION_ROD,    1 }, { xi.item.SCROLL_OF_CURE,  1 } },
                [xi.job.BLM] = { { xi.item.ONION_STAFF,  1 }, { xi.item.SCROLL_OF_STONE, 1 } },
                [xi.job.RDM] = { { xi.item.ONION_DAGGER, 1 }, { xi.item.SCROLL_OF_DIA,   1 } },
                [xi.job.THF] = { { xi.item.ONION_KNIFE,  1 } },
            },
            event =
            {
                [xi.job.WAR] =
                {
                    "Here. Don't make me regret it.",
                    { emote = xi.emote.FUME },
                    hint[4],
                },

                [xi.job.MNK] =
                {
                    "This turned out pretty good...",
                    "...",
                    "I think I'll just keep this one.",
                    " What? Your ore?",
                    { emote = xi.emote.FUME },
                    "How abouts you take these scraps before I give you something REAL to complain about.",
                    hint[4],
                },

                [xi.job.WHM] =
                {
                    "I can't work in these conditions!",
                    " Just take this junk and find me FOOD.",
                    hint[4],
                },

                [xi.job.BLM] =
                {
                    "That'll do nicely for MY weapon.",
                    " You? HAH. I found a piece of drift wood lying over there...",
                    { emote = xi.emote.LAUGH },
                    "Here you go.",
                    hint[4],
                },

                [xi.job.RDM] =
                {
                    "Not enough raw material for a REAL weapon.",
                    " But I suppose this'll do for you.",
                    { emote = xi.emote.LAUGH },
                    "Now conjure me up something to EAT.",
                    hint[4],
                },

                [xi.job.THF] =
                {
                    "Not enough raw material for a REAL weapon.",
                    " But I suppose this'll do for you.",
                    { emote = xi.emote.THINK },
                    "Right. There must be something tasty hiding around here...",
                    hint[4],
                },
            },
        })
    },
    {
        [IRON]  = cq.menuSpawn(BERNO, { "CREATURE", "Are you ready?" }, { { "Not yet." }, { "I'm ready.", "SPAWN" }  }, 2, false ),
        [BERNO] = cq.killStep(),
    },
    {
        [IRON] = cq.giveStep("ESCAPE", info.reward, info.name, cexi.music.NONE),
    },
    {
        [IRON] = cq.dialog({
            step  = false,
            name  = IronWolf,
            event = { "Yeah, I'm back again. So what." },
        }),
    },
    {
        [IRON] = cq.dialog({
            step  = false,
            name  = IronWolf,
            event = { "Yeah, I'm back again. So what." },
        }),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
