-----------------------------------
-- Buzz Off   (Lv5)
-- Buzz Kill (Lv10)
-----------------------------------
-- !setvar [CW]BUZZ_OFF 0
-- Sinister Moon !pos 90.473 0.000 10.688 234
-- !additem 925 1
-- Reward: Augmented Leather Vest (VIT +1, INT +1)
-----------------------------------
-- !setvar [CW]BUZZ_OFF 2
-- Sinister Moon !pos 90.473 0.000 10.688 234
-- Sickly Sap    !pos 165.555 -40.218 -325.926 107
-- Sinister Moon !pos 90.473 0.000 10.688 234
-- Reward: Augment Brass Spear (AGI +2, MND +2)
-----------------------------------
-- !setvar [CW]BUZZ_OFF 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-buzz_off")

local info =
{
    name    = "Buzz Off",
    second  = "Buzz Kill",
    author  = "Loxley",
    var     = "[CW]BUZZ_OFF",
    reward  =
    {
        gil     = 200,
        item    = 12568,              -- Leather Vest
        augment = { 514, 0, 516, 0 }, -- VIT +1, INT +1
    },

    reward2 =
    {
        item    = 16834,              -- Brass Spear
        augment = { 515, 1, 517, 1 }, -- AGI +2, MND +2
    },

    required =
    {
        item = { { 925, 1 } },
        name = "one giant stinger",
    },
}

local SINISTER_MOON = "SINISTER_MOON"
local SICKLY_SAP    = "SICKLY SAP"
local HORRID_HORNET = "HORRID HORNET"

local entity =
{
    {
        id     = SINISTER_MOON,
        name   = "Sinister Moon",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A6,
            head = cexi.model.NOTHING,
            body = cexi.model.BLACK_CLOAK,
            hand = cexi.model.BLACK_MAGE_ARTIFACT,
            legs = cexi.model.ERRANT_HOUPPELANDE,
            feet = cexi.model.BLACK_MAGE_ARTIFACT,
        }),
        area      = "Bastok_Mines",                -- (K-6)
        pos       = { 90.473, 0.000, 10.688, 83 }, -- !pos 90.473 0.000 10.688 234
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "What am I doing here? None of ya business." },
            START    =
            {
                "If you find a giant stinger, bring it to me.",
                " Why do I want one? None of ya business...",
            },
            AFTER    = { "Let's see if this does it. Here's your reward.", },
            START2   =
            {
                "All right. Wasn't potent enough...",
                " Search for a horrid hornet up on Vomp Hill.",
                { emote = xi.emote.THINK },
                { delay = 500 },
                "Look for sickly sap and you should find it.",
                " Kill the nasty thing, then bring me the sting.",
            },
            AFTER2   =
            {
                { emote = xi.emote.LAUGH },
                "Excellent. Yes... this is exactly what I need.",
            },
        },
    },
    {
        id       = SICKLY_SAP,
        name     = "Sickly Sap",
        marker   = cq.SIDE_QUEST,
        area     = "South_Gustaberg",                  -- (I-8)
        pos      = { 165.555, -40.218, -325.926, 46 }, --!pos 165.555 -40.218 -325.926 107
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "collects the hornet sting." },
            },
        },
    },
    {
        id          = HORRID_HORNET,
        name        = "Horrid Hornet",
        type        = xi.objType.MOB,
        groupId     = 10,
        groupZoneId = 107,
        area        = "South_Gustaberg",
        pos         = { 165.555, -40.218, -325.926, 46 }, --!pos 165.555 -40.218 -325.926 107
        level       = 9,
    },
}

local step =
{
    {
        check           = cq.checks({ CW = true, level = 5 }),
        [SINISTER_MOON] = cq.talkStep("START", info.name),
    },
    {
        [SINISTER_MOON] =
        {
            onTrigger = cq.talkOnly("START"),
            onTrade   = cq.tradeStep("AFTER", "START", info.required.item, info.reward, info.name, cexi.music.BASTOK),
        },
    },
    {
        check           = cq.checks({ CW = true, level = 10 }),
        [SINISTER_MOON] = cq.talkStep("START2", info.second),
    },
    {
        [SINISTER_MOON] = cq.talkOnly("START2"),
        [SICKLY_SAP]    = cq.menuSpawn(HORRID_HORNET, "Inspect the sap?", { { "No." }, { "Yes." } }, 2, true, { levelCap = 10 }),
        [HORRID_HORNET] = cq.killStep(SICKLY_SAP),
    },
    {
        [SINISTER_MOON] = cq.talkOnly("START2"),
        [SICKLY_SAP]    = cq.menuStep("Collect the sting?", { { "No." }, { "Yes.", "COLLECT" } }, 2),
    },
    {
        [SICKLY_SAP]    = cq.talkOnly("AFTER"),
        [SINISTER_MOON] = cq.giveStep("AFTER2", info.reward2, info.second, cexi.music.BASTOK),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
