-----------------------------------
-- Bug Report (Lv1)
-----------------------------------
-- !setvar [CW]BUG_REPORT 0
-- !setvar [CW]INSECT_WINGS
-- Bardus !pos 95.225 0.000, 118.159 230
-- !additem 4358 12
-- Rewards: 400g
-----------------------------------
-- !setvar [CW]BUG_REPORT 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-bug_report")

local info =
{
    name    = "Bug Report",
    author  = "Loxley",
    var     = "[CW]BUG_REPORT",
    counter = "[CW]INSECT_WINGS",
    reward  =
    {
        gil = 400,
    },

    required =
    {
        item = { { 846, 12 } },
        name = "twelve insect wings",
    },
}

local BARD   = "BARD"
local Bardus = "Bardus"

local entity =
{
    {
        id     = BARD,
        name   = Bardus,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A7,
            head = cexi.model.NONE,
            body = cexi.model.DOUBLET,
            hand = cexi.model.ROBE,
            legs = cexi.model.ROBE,
            feet = cexi.model.ROBE,
        }),
        area   = "Port_Bastok",                 -- (K-6)
        pos    = { 104.494, 8.500, 6.774, 48 }, -- !pos 104.494 8.500 6.774 236
        dialog =
        {
            NAME    = true,
            DEFAULT =
            {
                { emote = xi.emote.SIGH },
                "These bugs are getting out of hand...",
            },

            START  =
            {
                { emote = xi.emote.NO },
                "Adventurer, these bugs are getting out of hand...",
                " We must get this situation under control immediately.",
                { delay = 1000 },
                { emote = xi.emote.FUME },
                "Go out there, squash as many bugs as you can find.",
                " Come back with twelve insect wings as proof.",
            },

            REMINDER =
            {
                { emote = xi.emote.FUME },
                "Go out there, squash as many bugs as you can find.",
                " Come back with twelve insect wings as proof.",
            },

            ACCEPTED =
            {
                { emote = xi.emote.CLAP },
                "Great work, adventurer. Keep it up.",
                " That makes a grand total of %u bugs eliminated.",
            },

            DECLINED =
            {
                "Adventurer, there is no time for these games.",
                "Please get back to work.",
            },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true }),
        [BARD] = cq.talkStep("START", info.name),
    },
    {
        [BARD] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 12, info.name, cexi.music.BASTOK),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
