-----------------------------------
-- Birdsearch (Lv5)
-----------------------------------
-- !setvar [CW]BIRDSEARCH 0
-- !setvar [CW]BIRD_FEATHERS
-- Neavias !pos -215.700 -6.000 -91.677 235
-- !additem 847 4
-- Rewards: 400g
-----------------------------------
-- !setvar [CW]BIRDSEARCH 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-birdsearch")

local info =
{
    name    = "Birdsearch",
    author  = "Loxley",
    var     = "[CW]BIRDSEARCH",
    counter = "[CW]BIRD_FEATHERS",
    reward  =
    {
        gil = 400,
    },

    required =
    {
        item = { { 847, 4 } },
        name = "four bird feathers",
    },
}

local NEAV    = "NEAV"
local Neavias = "Neavias"

local entity =
{
    {
        id     = NEAV,
        name   = Neavias,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A6,
            head = cexi.model.AUSTERE_ROBE,
            body = cexi.model.FISHING_TUNICA,
            hand = cexi.model.FISHING_TUNICA,
            legs = cexi.model.TUNIC,
            feet = cexi.model.FISHING_TUNICA,
        }),
        area   = "Bastok_Markets",                  -- (H-9)
        pos    = { -215.700, -6.000, -91.677, 40 }, -- !pos -215.700 -6.000 -91.677 235
        dialog =
        {
            NAME    = true,
            DEFAULT =
            {
                "Greetings. I'm bird collector of sorts...",
            },

            START  =
            {
                { emote = xi.emote.WAVE },
                "Greetings. I'm bird collector of sorts...",
                " I gather different feathers for my collection.",
                { delay = 1000 },
                "If you have any bird feathers to sell, I'll take them, four at a time",
            },

            REMINDER =
            {
                "If you have any bird feathers to sell, I'll take them, four at a time",
            },

            ACCEPTED =
            {
                { emote = xi.emote.THINK },
                "Hmmm... These are good samples. That makes %u feathers.",
                "Here's your reward.",
            },

            DECLINED =
            {
                "Remember, it's four bird feathers at a time.",
            },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 5 }),
        [NEAV] = cq.talkStep("START", info.name),
    },
    {
        [NEAV] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 4, info.name, cexi.music.BASTOK),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
