-----------------------------------
-- A Matter of Trust (Bastok)     (Lv15)
-- A Matter of Trust (Bastok) II  (Lv25)
-- A Matter of Trust (Bastok) III (Lv40)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]TRUST_BASTOK 0
-- Reisle          !pos -192.5 -4 80 235
-- Anomaly         !pos 559.35 40.21 431.00 108
-- Reisle          !pos -192.5 -4 80 235
-----------------------------------
-- Brass Mittens
-- Trust: Volker, Trust Limit 1
-----------------------------------
-- !setvar [CW]TRUST_BASTOK 4
-- Reisle          !pos -192.5 -4 80 235
-- Overturned Cart !pos 177.182 -59.724 -99.715 196
-- Reisle          !pos -192.5 -4 80 235
-----------------------------------
-- Greaves (HP +10, STR +1, INT +1)
-----------------------------------
-- !setvar [CW]TRUST_BASTOK 8
-- Reisle          !pos -192.5 -4 80 235
-- Guard House     !pos -238.332 -3.057 62.587 147
-- Reisle          !pos -192.5 -4 80 235
-----------------------------------
-- Earth Mantle (DEF +2, STR +2, INT +2)
-- Trust: Naji, Trust Limit 2
-----------------------------------
-- !setvar [CW]TRUST_BASTOK 13

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-a_matter_of_trust_bastok")

local info =
{
    name   = "A Matter of Trust (Bastok)",
    author = "Yve",
    var    = "[CW]TRUST_BASTOK",
    reward =
    {
        item    = 12705,    -- Brass Mittens (Lv11)
        augment = { 1, 9 }, -- HP +10
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.rewardTrust(player, 903, "Volker", 1)

            return true
        end,
    },

    reward2 =
    {
        item    = 12936,                    -- Greaves (Lv24)
        augment = { 1, 9, 512, 0, 516, 0 }, -- HP +10, STR +1, INT +1
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.sprinterShoes(player)

            return true
        end,
    },

    required3 = 
    {
        item = 553, -- Dangruf Stone
    },

    reward3 =
    {
        item    = 13623,                     -- Earth Mantle (Lv40)
        augment = { 33, 1, 512, 1, 516, 1 }, -- DEF +2, STR +2, INT +2
        keyitem =
        {
            xi.ki.BASTOK_TRUST_PERMIT,
            xi.ki.BLUE_INSTITUTE_CARD,
        },
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.rewardTrust(player, 897, "Naji", 2)

            player:completeQuest(xi.questLog.BASTOK, xi.quest.id.bastok.TRUST_BASTOK)

            return true
        end,
    },
}

local REISLE_1    = "REISLE_1"
local REISLE_2    = "REISLE_2"
local ANOMALY     = "ANOMALY"
local WEAPON      = "WEAPON"
local APPARITION  = "APPARITION"
local LOST_ITEM   = "LOST_ITEM"
local GUARD_HOUSE = "GUARD_HOUSE"

local Reisle      = "Reisle"
local Volker      = "Volker"
local Naji        = "Naji"

local reisleLook = cexi.util.look({
    race = xi.race.HUME_M,
    face = 5,
    head = 0,
    body = cexi.model.BRIGANDINE,
    hand = cexi.model.BRONZE_HARNESS,
    legs = cexi.model.TIGER_JERKIN,
    feet = cexi.model.BRONZE_HARNESS,
})

local entity =
{
    {
        id     = REISLE_1,
        name   = Reisle,
        type   = xi.objType.NPC,
        look   = reisleLook,
        area   = "Bastok_Markets",
        pos    = { -197.500, -4.000, 79.729, 128 }, -- !pos -192.5 -4 80 235
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                { emote = xi.emote.SHOCKED },
                "Whoa, don't sneak up on me like that!",
            },
            START    =
            {
                { emote = xi.emote.SHOCKED },
                "Whoa, don't sneak up on me like that! I thought you were Captain Volker.",
                " He's assigned me a recon mission... at Konschtat Highlands.",
                { delay = 1000 },
                "I'm not ready for that! I feel sick even thinking about it.",
                { delay = 1000 },
                " Y-You wouldn't...",
                { emote = xi.emote.STAGGER },
                { delay = 3000 },
                { entity = "player", emote = xi.emote.POKE },
                { delay = 3000 },
                "What just happened? Did you say you'd help?",
                " Great, I can maybe handle it with your help.",
            },
            REMINDER = { "Meet us at Konschtat Highlands." },
            FINISH   =
            {
                "Oh it's you. You wouldn't really take my place, would you?",
                { emote = xi.emote.BLUSH },
                { delay = 2000 },
                " Any way here's a gift for your bravery.",
            },
            AFTER    = { "I sense that our paths will cross again soon." },

            PART2_START =
            {
                { emote = xi.emote.BLUSH },
                "Uh, hello. You are looking a lot stronger since I saw you last.",
                "Um, wait, don't think about that, ok?",
                { delay = 1000 },
                { emote = xi.emote.THINK },
                "I've a small task that needs doing...",
                { delay = 2000 },
                "I left a few things in Gusgen Mines while on my assignment",
                " I'd be very grateful if you'd collect them for me.",
            },

            PART2_REMINDER = { "Please collect my things from Gusgen Mines." },

            PART2_FINISH   =
            {
                { emote = xi.emote.CHEER },
                "Oh thank you! I just can't stand those mines, they give me the creeps!",
                "Take this for your trouble.",
            },

            PART2_AFTER    = { "Thanks for helping me out." },

            PART3_START =
            {
                "I need a dangruf stone. My life kinda depends on it.",
                { emote = xi.emote.SIGH },
            },
            PART3_ACCEPTED =
            {
                "Great! Call me superstitious if you will, but this stone is said to make a warrior stronger.",
                { delay = 2000 },
                "Naji has been mentoring me, and wants to assess my skill in battle.",
                { emote = xi.emote.STAGGER },
                { delay = 2000 },
                " Would you stand with me in this fight?",
                "We're to take out the Quadavs at the guard house in Beadeaux",
            },
            PART3_REMINDER =
            {
                "We're to eliminate Quadavs at the guard house in Beadeaux",
            },
            PART3_FINISH =
            {
                "Naji said I have potential, so I'm going to keep trying.",
                "He felt like you deserve this more than I do though.",
                { emote = xi.emote.BLUSH },
            },
            PART3_AFTER  =
            {
                "One day I hope I'm as brave and strong as you.",
            },
        },
    },
    {
        id     = ANOMALY,
        name   = "Crystal Anomaly",
        marker = cq.MAIN_QUEST,
        area   = "Konschtat_Highlands",
        pos    = { 558.547, 40.210, 431.396, 0 }, --!pos 559.35 40.21 431.00 108
        dialog =
        {
            DEFAULT = cq.NOTHING,
            FINISH  =
            {
                { music  = cexi.music.METALWORKS },
                { despawn   = { "Crystal Anomaly" } },
                { spawn  = { Reisle } },
                { delay  = 2000 },
                { entity = Reisle, emote = xi.emote.PANIC },
                "Reisle : Did you just fight that!?",
                { delay  = 3000 },
                { entity = Reisle, face = "player" },
                { entity = Reisle, emote = xi.emote.AMAZED },
                "Reisle : Where was I? I... got here as fast as I could, honest.",
                { spawn = { Volker  } },
                { delay = 3000 },
                "Volker : At least you showed up. If a bit late.",
                { entity = Reisle, face = Volker },
                { delay  = 2000 },
                "Volker : Be better prepared or this adventurer will be taking your place in the musketeers.",
                { entity  = Reisle, emote = xi.emote.SULK },
                { delay   = 5000 },
                { despawn = { Reisle, Volker } },
                { spawn   = { "Crystal Anomaly" } },
                { music   = cexi.music.NONE },
            },
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id     = "REISLE_2",
        name   = Reisle,
        type   = xi.objType.NPC,
        hidden = true,
        look   = reisleLook,
        area   = "Konschtat_Highlands",
        pos    = { 561.143, 40.392, 427.449, 180 }, --!pos 561.143 40.392 427.449 108
    },
    {
        id     = "VOLKER",
        name   = Volker,
        type   = xi.objType.NPC,
        hidden = true,
        look   = 81,
        area   = "Konschtat_Highlands",
        pos    = { 557.568, 40.873, 422.505, 223 }, --!pos 557.568 40.873 422.505 108
    },
    {
        id          = WEAPON,
        name        = "Crystal Weapon",
        type        = xi.objType.MOB,
        look        = 451,
        groupId     = 7,
        groupZoneId = 126,
        level       = 13,
        area        = "Konschtat_Highlands",
        pos         = { 558.547, 40.210, 431.396, 0 }, --!pos 559.35 40.21 431.00 108
    },

    -- For Part 2
    {
        id          = LOST_ITEM,
        name        = "Overturned Cart",
        marker      = cq.MAIN_QUEST,
        area        = "Gusgen_Mines",
        pos         = { 177.182, -59.724, -99.715, 0 }, --!pos 177.182 -59.724 -99.715 196
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            FOUND   = { "You found Reisle's supplies!" },
            AFTER   = cq.NOTHING_ELSE,
        }
    },
    {
        id          = "APPARITION",
        name        = "Fear Apparition",
        type        = xi.objType.MOB,
        look        = 578,
        groupId     = 14,
        groupZoneId = 196,
        area        = "Gusgen_Mines",
        pos         = { 177.182, -59.724, -99.715, 128 }, --!pos 177.182 -59.724 -99.715 196
        level       = 22,
    },

    -- For Part 3
    {
        id     = "REISLE_3",
        name   = Reisle,
        type   = xi.objType.NPC,
        hidden = true,
        look   = reisleLook,
        area   = "Beadeaux",
        pos    = { -245.477, -3.229, 68.288, 10 }, --!pos -245.477 -3.229 68.288 147
    },
    {
        id     = "NAJI",
        name   = Naji,
        type   = xi.objType.NPC,
        hidden = true,
        look   = "0x0100050100101B2000300C401850006000700000",
        area   = "Beadeaux",
        pos    = { -239.537, -3.278, 75.492, 69 }, --!pos -239.537 -3.278 75.492 147
    },
    {
        id          = "SENTRY_1",
        name        = "Sentry Quadav",
        type        = xi.objType.MOB,
        look        = 652,
        groupId     = 4,
        groupZoneId = 147,
        area        = "Beadeaux",
        pos         = { -242.949, -3.093, 65.460, 252 }, --!pos -242.949 -3.093 65.460 147
        level       = 45,
    },
    {
        id          = "SENTRY_2",
        name        = "Watch Quadav",
        type        = xi.objType.MOB,
        look        = 652,
        groupId     = 4,
        groupZoneId = 147,
        area        = "Beadeaux",
        pos         = { -235.642, -3.222, 59.729, 180 }, --!pos -235.642 -3.222 59.729 147
        level       = 45,
    },
    {
        id          = GUARD_HOUSE,
        name        = "Guard House",
        marker      = cq.MAIN_QUEST,
        area        = "Beadeaux",
        pos         = { -238.332, -3.057, 62.587, 90 }, --!pos -238.332 -3.057 62.587 147
        dialog      =
        {
            DEFAULT  = cq.NOTHING,
            CUTSCENE =
            {
                { music = 154 },
                { spawn = { Reisle, Naji } },
                { delay = 5000 },
                "Naji : (Wow, he's even worse than I was).",
                { entity = Naji, face = Reisle },
                { emote = Reisle, emote = xi.emote.SHOCKED },
                "Reisle : Did I survive?",
                { delay  = 2000 },
                { entity = Reisle, emote = xi.emote.PANIC },
                "Reisle : Hey, I was participating!",
                { delay  = 2000 },
                "Naji : What, you want a trophy?",
                { entity = Naji, emote = xi.emote.HUH },
                { entity = Reisle, face = Naji },
                { delay  = 2000 },
                { entity = Reisle, emote = xi.emote.BLUSH },
                { delay  = 2000 },
                "Naji : Still, I see a bit of my younger self in you, though you could do with more ambition.",
                { entity = Naji, face = "player" },
                { delay  = 1000 },
                { entity = Naji, emote = xi.emote.POINT },
                "Naji : You could learn some things from your sidekick here.",
                { entity = Reisle, emote = xi.emote.STAGGER },
                { delay = 3000 },
                { despawn = { Reisle, Naji } },
                { music = 0 },
            },
            AFTER   = cq.NOTHING_ELSE,
        }
    },
}

local sentryMobs = { "SENTRY_1", "SENTRY_2" }

local step =
{
    -- 0
    {
        check      = cq.checks({ CW = true, level = 15 }),
        [REISLE_1] = cq.talkStep("START", info.name),
    },
    {
        [REISLE_1] = cq.talkOnly("REMINDER"),
        [ANOMALY]  = cq.menuSpawn(WEAPON, "Investigate the anomaly?", { { "Not yet." }, { "I'm ready" } }, 2, true, { levelCap = 15 }),
        [WEAPON]   = cq.killStep(ANOMALY),
    },
    {
        [ANOMALY]  = cq.talkStep("FINISH"),
    },
    {
        [ANOMALY]  = cq.talkOnly("AFTER"),
        [REISLE_1] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.BASTOK),
    },
    -- 4
    {
        check      = cq.checks({ CW = true, level = 25 }),
        [REISLE_1] = cq.talkStep("PART2_START", info.name .. " II"),
    },
    {
        [REISLE_1]   = cq.talkOnly("PART2_REMINDER"),
        [LOST_ITEM]  = cq.menuSpawn(APPARITION, "Look inside the cart?", { { "I'm scared." }, { "Let's do it." } }, 2),
        [APPARITION] = cq.killStep(LOST_ITEM),
    },
    {
        [LOST_ITEM] = cq.talkStep("FOUND"),
    },
    {
        [LOST_ITEM] = cq.talkOnly("AFTER"),
        [REISLE_1] = cq.giveStep("PART2_FINISH", info.reward2, info.name .. " II", cexi.music.BASTOK),
    },
    -- 8
    {
        check      = cq.checks({ CW = true, level = 40 }),
        [REISLE_1] = cq.talkStep("PART3_START", info.name .. " III"),
    },
    {
        [REISLE_1] =
        {
            onTrigger = cq.talkOnly("PART3_START"),
            onTrade   = cq.tradeStep("PART3_ACCEPTED", "PART3_START", info.required3.item),
        },
    },
    {
        [REISLE_1]    = cq.talkOnly("PART3_REMINDER"),
        [GUARD_HOUSE] = cq.menuSpawn(sentryMobs, "Knock on the door?", { { "Nobody home." }, { "Who's there?" } }, 2, true, { levelCap = 40 }),
        ["SENTRY_1"]  = cq.killStep(GUARD_HOUSE, sentryMobs, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_BASTOK_III" }),
        ["SENTRY_2"]  = cq.killStep(GUARD_HOUSE, sentryMobs, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_BASTOK_III" }),
    },
    {
        [GUARD_HOUSE] = cq.talkStep("CUTSCENE"),
    },
    {
        [GUARD_HOUSE] = cq.talkOnly("AFTER"),
        [REISLE_1]    = cq.giveStep("PART3_FINISH", info.reward3, info.name .. " III", cexi.music.BASTOK),
    },
    {
        [REISLE_1] = cq.talkOnly("PART3_AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
