-----------------------------------
-- Wanting Ore - Plate Belt
-- !setvar [CQ]WANTING_ORE 0
-- Ferredec  !pos -98.652 2.000 -29.980 237
-- Soft Spot !pos 222.936 25.302 145.811 109
-- Ferredec  !pos -98.652 2.000 -29.980 237
-- Reward: Plate Belt
-----------------------------------
-- !setvar [CQ]WANTING_ORE 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-wanting_ore")

local helpers =
{
    {
        name     = "12 bronze sheets",
        required = { { 660, 12 } },
        rewards  =
        {
            {
                name = "Aspis",
                item = 12299,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 1, 9,   512, 0 }, -- HP +10, STR +1
                },
            },
        },
    },
    {
        name     = "12 bronze scales",
        required = { { 672, 12 } },
        rewards  =
        {
            {
                name = "Scale Mail",
                item = 12560,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 9, 7,   512, 0 }, -- MP +8, STR +1
                },
            },
        },
    },
    {
        name     = "12 iron sheets",
        required = { { 662, 12 } },
        rewards  =
        {
            {
                name = "Dagger",
                item = 16450,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    { 518, { 0, 2 }, }, -- CHR +1-3
                    { 518, 2, 23, 1, }, -- CHR +3, Accuracy +2
                },
            },
        },
    },
    {
        name     = "12 iron chains",
        required = { { 680, 12 } },
        rewards  =
        {
            {
                name = "Chain Hose",
                item = 12808,
                augs =
                {
                    { 514, { 0, 3 }, }, -- VIT      +1-4
                    {  23, { 0, 2 }, }, -- Accuracy +1-3
                    { 512, 1,  23, 2 }, -- STR +2, Accuracy +3
                },
            },
        },
    },
    {
        name     = "12 steel sheets",
        required = { { 666, 12 } },
        rewards  =
        {
            {
                name = "Gust Sword",
                item = 18368,
                augs =
                {
                    { 25, { 2, 7 }, }, -- Attack   +3-8
                    { 23, { 2, 7 }, }, -- Accuracy +3-8
                    { 25, 7, 54, 3, }, -- Attack +8, Phys. dmg. taken -4%
                },
            },
        },
    },
    {
        name     = "12 darksteel sheets",
        required = { { 664, 12 } },
        rewards  =
        {
            {
                name = "Scutum",
                item = 12323,
                augs =
                {
                    { 514, { 1, 4 }, }, -- VIT      +2-5
                    {  23, { 2, 7 }, }, -- Accuracy +3-8
                    {   1, 24, 9, 24 }, -- HP +25, MP +25
                },
            },
        },
    },
    {
        name     = "12 darksteel chains",
        required = { { 682, 12 } },
        rewards  =
        {
            {
                name = "Darksteel Breeches",
                item = 12811,
                augs =
                {
                    {  25, { 2, 7 }, }, -- Attack   +3-8
                    {  23, { 2, 7 }, }, -- Accuracy +3-8
                    {  23, 7, 54, 1, }, -- Accuracy +8, Phys. dmg. taken -2%
                },
            },
        },
    },
    {
        name     = "12 adaman sheets",
        required = { { 665, 12 } },
        rewards  =
        {
            {
                name = "Ritter Shield",
                item = 12309,
                augs =
                {
                    {  25, { 2, 7 }, }, -- Attack           +3-8
                    {  23, { 2, 7 }, }, -- Accuracy         +3-8
                    {  23, 7, 55, 4, }, -- Accuracy +8, Magic dmg. taken -5%
                },
            },
        },
    },
}

local info =
{
    name   = "Wanting Ore",
    author = "Loxley",
    var    = "[CQ]WANTING_ORE",
    reward =
    {
        item    = 13227,                  -- Plate Belt (Lv12)
        augment = { 1, 9, 23, 1, 53, 7 }, -- HP +10, Accuracy +2, Spell interruption rate down 8%
    },
}

local FRED     = "FRED"
local Ferredec = "Ferredec"
local CRAB     = "CRAB"
local SPOT     = "SPOT"

local entity =
{
    {
        id     = FRED,
        name   = Ferredec,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A2,
            head = cexi.model.NOTHING,
            body = cexi.model.STEEL_SCALE_MAIL,
            hand = cexi.model.STEEL_SCALE_MAIL,
            legs = cexi.model.STEEL_SCALE_MAIL,
            feet = cexi.model.STEEL_SCALE_MAIL,
        }),
        area   = "Metalworks",
        pos    = { -98.652, 2.000, -29.980, 73 }, -- !pos -98.652 2.000 -29.980 237
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "So much to do..." },
            START    =
            {
                { emote = xi.emote.BLUSH },
                "I'm in need of a special material for a very important customer...",
                "Are you perhaps heading toward Pashhow Marshlands?",
            },
            ACCEPTED =
            {
                { emote = xi.emote.THINK },
                "I've heard that particular crabs in Pashhow may provide something...",
                "These crabs consume small rocks and metals that accumulate over time in the sediment.",
                { delay = 3000 },
                { emote = xi.emote.AMAZED },
                "I simply must see if what they collect is usable!",
                "If you search soft spots in the ground maybe you can find one hiding.",
            },
            REMINDER =
            {
                "Look for soft spots in Pashhow Marshlands and try to find one of those crabs.",
            },
            AFTER    =
            {
                { emote = xi.emote.SHOCKED },
                "Wow, incredible. This even looks sort of usable!",
                "Here's something for your time.",
            },

            -- Guild Helpers
            REQUEST  =
            {
                "I'm a bit short on supplies.",
                { emote = xi.emote.STAGGER },
                "If you could deliver %s that would really help me out!",
                "In exchange, I'll give you one of my latest creations.",
            },
            RESULT   = { "Right on time! I really appreciate that. Very well, I hope you like this." },
            DECLINED = { "Deliver %s and I'll give you one of my latest creations", },
        },
    },
    {
        id       = SPOT,
        name     = "Soft Spot",
        marker   = cq.SIDE_QUEST,
        area     = "Pashhow_Marshlands",
        pos      = { 222.936, 25.302, 145.811, 127 }, --!pos 222.936 25.302 145.811 109
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                "You collect the chunks of swamp ore.",
            },
        },
    },
    {
        id          = CRAB,
        name        = "Swamp Scylla",
        type        = xi.objType.MOB,
        look        = 2965,
        flags       = 135,
        groupId     = 5,
        groupZoneId = 109,
        area        = "Pashhow_Marshlands",
        pos         = { 222.936, 25.302, 145.811, 127 }, --!pos 222.936 25.302 145.811 109
        level       = 23,
    },
}

local step =
{
    {
        check  = cq.checks({ level = 20 }),
        [FRED] = cq.talkStep("START"),
    },
    {
        [FRED] = cq.menuStep("Going to Pashhow Marshlands?", { { "Let's get wet.", "ACCEPTED" }, { "Too much rain." } }, 1, info.name),
    },
    {
        [FRED] = cq.talkOnly("REMINDER"),
        [SPOT] = cq.menuSpawn(CRAB, "Give it a poke?", { { "No way!" }, { "What's the worst that could..." } }, 2 ),
        [CRAB] = cq.killStep(SPOT),
    },
    {
        [SPOT] = cq.talkStep("AFTER"),
    },
    {
        [FRED] = cq.giveStep("AFTER", info.reward, info.name, cexi.music.METALWORKS),
    },

    -- Guild Helpers
    {
        check   = cq.checks({ cooldown = "[CQ]HELPER_BS" }),
        [FRED] =
        {
            onTrigger = cq.talkWeekly(helpers, "REQUEST"),
            onTrade   = cq.tradeWeekly(helpers, "[CQ]HELPER_BS", "RESULT", "DECLINED"),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
