-----------------------------------
-- Chasing Tails (Lv1) Repeatable
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]CHASING_TALES 0
-- Shining Stone !pos 98.661 6.017 -17.552 234
-- !additem 926 12
-- Reward: 600 gil
-----------------------------------
-- !setvar [CW]CHASING_TALES 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-chasing_tails")

local info =
{
    name   = "Chasing Tales",
    author = "Loxley",
    var    = "[CW]CHASING_TALES",
    reward =
    {
        gil = 600,
    },

    required =
    {
        item = { { 926, 12 } },
        name = "a lizard tail",
    },
}

local STONE   = "STONE"
local Shining = "Shining Stone"

local entity =
{
    {
        id     = STONE,
        name   = Shining,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B8,
            head = 119, -- Magnifying Spectacles
            body = cexi.model.ROBE,
            hand = cexi.model.ROBE,
            legs = cexi.model.ROBE,
            feet = cexi.model.ROBE,
        }),
        area   = "Bastok_Mines",
        pos    = { 98.661, 6.017, -17.552, 224 }, -- !pos 98.661 6.017 -17.552 234
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            START    =
            {
                "What? Never seen a Galkachemist before?",
                { emote = xi.emote.LAUGH },
                { delay = 2000 },
                "The truth is, I'm new here... and I keep forgetting my ingredients!",
                " It would really help me out if you brought twelve lizard tails."
            },
            REMINDER =
            {
                "It would really help me out if you brought twelve lizard tails."
            },
            ACCEPTED =
            {
                "Thanks! Now I can get back to work.",
                { emote = xi.emote.CHEER },
                " So far, you've helped me brew %u potions.",
                "Bring more lizard tails and I'll gladly do business again!",
            },
        },
    },
}

local step =
{
    {
        [STONE] = cq.talkStep("START", info.name),
    },
    {
        [STONE] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "REMINDER", info.required.item, info.reward, "[CW]TAILS", 12, info.name, cexi.music.BASTOK),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
