-----------------------------------
-- The Purse Strings (PUP Lv10)
-----------------------------------
-- !setvar [CW]PURSE_STRINGS 0
-- Carlo       !pos 31.607 -6.000 94.455 50
-- Troll Cache !pos 346.807 -0.186 308.810 62
-- Carlo       !pos 31.607 -6.000 94.455 50
-----------------------------------
-- !setvar [CW]PURSE_STRINGS 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-the_purse_strings")

local info =
{
    name   = "The Purse Strings",
    author = "Loxley",
    var    = "[CW]PURSE_STRINGS",
    reward =
    {
        SHARPSHOT =
        {
              718, -- Rosewood Lumber
             2288, -- Karakul Cloth
              879, -- Karakul Leather
            17220, -- Heavy Crossbow
        },

        STORMWAKER =
        {
              823, -- Gold Thread
              828, -- Velvet Cloth
             2289, -- Wamoura Cloth
            13465, -- Brass Ring
        },

        VALOREDGE =
        {
              661, -- Brass Sheet
             2173, -- Wamoura Cocoon
             2290, -- Imperial Cermet
            16419, -- Patas
        },
    },
}

local CARLO       = "CARLO"
local TROLL_CACHE = "TROLL_CACHE"
local TREASURER   = "TREASURER"

local entity =
{
    {
        id     = CARLO,
        name   = "Carlo",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A5,
            head = 0,
            body = cexi.model.ROBE,
            hand = cexi.model.PUPPETMASTER_ARTIFACT,
            legs = cexi.model.PUPPETMASTER_ARTIFACT,
            feet = cexi.model.PUPPETMASTER_ARTIFACT,
        }),
        area   = "Aht_Urhgan_Whitegate",
        pos    = { 31.607, -6.000, 94.455, 127 }, -- !pos 31.607 -6.000 94.455 50
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I'm just a humble puppet maker." },
            START    =
            {
                { emote = xi.emote.THINK },
                "You need automaton materials, eh? Well, I may just have a deal for you..."
            },

            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "I heard there's a cave in Bhaflau Thickets that leads to Halvung.",
                " There's a special room by a Decorative Bronze Gate where the Trolls store gold.",
                { emote = xi.emote.AMAZED },
                { delay = 2000 },
                "Break in there, take as much gold as you can carry, and I'll give you what you need.",
            },

            REMINDER =
            {
                { emote = xi.emote.HUH },
                "Well? Did you find that gold?"
            },

            AFTER =
            {
                "This is the stuff!",
                { emote = xi.emote.CHEER },
                { delay = 1000 },
                "Woah, woah. Slow down buddy. You think I'm giving you all of these?",
                " Pick one set for now. If you want more, you'll just have to fetch more gold.",
            },

            GIVE  = { "Very well. Here are the goods." },
            FINAL = { "That's it, we're done. Finito. Pleasure doing business with you." },
        },
    },

    {
        id   = TROLL_CACHE,
        name = "Troll Cache",
        type = xi.objType.NPC,
        look = 969,
        area = "Halvung",
        pos  = { 346.807, -0.186, 308.810, 67 }, -- !pos 346.807 -0.186 308.810 62
        dialog =
        {
            NAME    = false,
            DEFAULT =
            {
                { noturn    = true },
                "It's locked."
            },
            COLLECT =
            {
                { noturn    = true },
                { entity    = "Troll Cache", packet = "open" },
                { animation = 48, target = "player", duration = 2000 }, -- Crouch down
                { emotion   = "collects armfuls of gold!" },
                { delay     = 3000 },
                { entity    = "Troll Cache", packet = "close" },
            },
            APPROACH =
            {
                "Something approaches...",
            },
        },
    },
    {
        id          = TREASURER,
        name        = "Troll Treasurer",
        type        = xi.objType.MOB,
        look        = 1708,
        groupId     = 27,
        groupZoneId = 52,
        area        = "Halvung",
        pos         = { 356.761, 0.040, 300.742, 130 }, -- !pos 356.761 0.040 300.742 62
        level       = 7,
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 10, job = xi.job.PUP }),
        [CARLO] = cq.talkStep("START"),
    },
    {
        [CARLO] = cq.menuStep("Listen to his offer?", { { "Turn your nose up." }, { "Follow your nose.", "ACCEPTED" } }, 2, info.name)
    },
    {
        [CARLO]       = cq.talkOnly("ACCEPTED"),
        [TROLL_CACHE] = cq.menuSpawn(TREASURER, "Are you ready?", { { "I'm scared."}, { "I'm a real boy!", "APPROACH" } }, 2, false, { levelCap = 10 }),
        [TREASURER]   = cq.killStep(),
    },
    {
        [CARLO]       = cq.talkOnly("REMINDER"),
        [TROLL_CACHE] = cq.talkStep("COLLECT"),
    },
    {
        [CARLO] = cq.talkStep("AFTER"),
    },
    {
        [CARLO] = cq.menuReward({
            progress = { "[CW]PURSE_STRINGS_REWARD", 2 },
            complete = { info.name, cexi.music.WHITEGATE },
            message  = { "Which materials are you after?", "GIVE"},
            options  =
            {
                { "Sharpshot Z-500",  info.reward.SHARPSHOT  },
                { "Stormwaker Y-700", info.reward.STORMWAKER },
                { "Valoredge X-900" , info.reward.VALOREDGE  },
            }
        }),
    },
    {
        [CARLO] = cq.talkStep("FINAL"),
    }
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
