-----------------------------------
-- Pecking Battles (Lv50)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]PECKING_BATTLES 0
-- !setvar [CW]BEAKS 0
-- Vermali !pos 369.949 -12.550 -52.531 52
-- !additem 2171 6
-- Rewards: Wivre Mask, 1800 gil
-----------------------------------
-- !setvar [CW]PECKING_BATTLES 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-pecking_battles")

local info =
{
    name   = "Pecking Battles",
    author = "Loxley",
    var    = "[CW]PECKING_BATTLES",
    reward =
    {
        gil = 1800,
    },

    reward2  =
    {
        item    = 16130,             -- Wivre Mask (Lv65)
        augment = { 513, 2, 23, 4 }, -- DEX +3, Accuracy +5
    },

    required =
    {
        item = { { 2171, 6 } },
        name = "a colibri beak",

        after = function(player)
            player:incrementCharVar("[CW]BEAKS", 6)
        end,
    },
}

local VERM    = "VERM"
local Vermali = "Vermali"

local entity =
{
    {
        id     = VERM,
        name   = Vermali,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A5,
            head = cexi.model.SIPAHI_JAWSHAN,
            body = cexi.model.JARIDAH_PETI,
            hand = cexi.model.AMIR_KORAZIN,
            legs = cexi.model.JARIDAH_PETI,
            feet = cexi.model.AMIR_KORAZIN,
        }),
        area   = "Bhaflau_Thickets",
        pos    = { 369.949, -12.550, -52.531, 225 }, -- !pos 369.949 -12.550 -52.531 52
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "What a racket!" },
            START    =
            {
                { emote = xi.emote.FUME },
                "Birds!! I 'ate these the stupid birds!",
                " Flap, flap, flap, screech, screech. I hate it!",
                { delay = 2000 },

                "Put down as many of these pests as you can.",
                { emote = xi.emote.LAUGH },
                " I'll pay for every six beaks!",
            },
            REMINDER =
            {
                { emote = xi.emote.PANIC },
                "Please get rid of these birds! Hand over six colibri beaks and I'll pay.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "This is a great start but our work has only just begun!",
                " You've handed in a total of %i beaks.",
                { emote = xi.emote.LAUGH },
                "Give me enough and you'll earn a special prize! Haha...",
            },
            ACCEPTED2 =
            {
                "That's the stuff. Get those birds!!",
                "You've handed over a total of %i beaks.",
                "Bring me more, soldier.",
                { emote = xi.emote.SALUTE },
            },
            REWARD =
            {
                "That breaks 100 beaks!",
                "I'd like to present you with something special!",
                { emote = xi.emote.CHEER },
            },
            DECLINED =
            {
                { emote = xi.emote.NO },
                "That isn't the proof I asked for.",
            },
        },
    },
}

local step =
{
    {
        [VERM] = cq.talkStep("START", info.name, cexi.music.WAJAOM),
    },
    {
        [VERM] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeCount({
                items     = info.required.item,
                require   = 100,
                var       = "[CW]BEAKS",
                before    = { "ACCEPTED", info.reward  },
                after     = { "REWARD",   info.reward2 },
                decline   = "DECLINED",
                questName = info.name,
                music     = cexi.music.WAJAOM,
            }),
        },
    },
    {
        [VERM] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED2", "DECLINED", info.required.item, info.reward, "[CW]BEAKS", 6, info.name, cexi.music.WAJAOM),
        }
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
