-----------------------------------
-- Insult to Gingery (Lv40)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]INSULT_GINGERY 0
-- Gordo-Bordo !pos 17.382 -6.000 -50.626 50
-- !additem 2645 4
-- Reward: Sipahi Turban, 600 gil
-----------------------------------
-- !setvar [CW]INSULT_GINGERY 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-insult_to_gingery")

local info =
{
    name   = "Insult to Gingery",
    author = "Loxley",
    var    = "[CW]INSULT_GINGERY",
    reward =
    {
        item    = 16061,              -- Sipahi Turban (Lv59)
        augment = { 513, 1, 516, 1 }, -- DEX +2, INT +2
    },

    reward2  =
    {
        gil = 600,
    },

    required =
    {
        item = { { 2645, 4 } },
        name = "an eastern ginger root",
    },
}

local GORDO      = "GORDO"
local GordoRordo = "Gordo-Bordo"

local entity =
{
    {
        id     = GORDO,
        name   = GordoRordo,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.A1,
            head = 124, -- Chef's Hat
            body = cexi.model.CULINARIANS_APRON,
            hand = cexi.model.WHITE_CLOAK,
            legs = cexi.model.WHITE_CLOAK,
            feet = cexi.model.WHITE_CLOAK,
        }),
        area   = "Aht_Urhgan_Whitegate",
        pos    = { 17.382, -6.000, -50.626, 96 }, -- !pos 17.382 -6.000 -50.626 50
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            START    =
            {
                { emote = xi.emote.THINK },
                "President Naja has me cooking up dinners but lately she's been unimpressed.",
                " My hurt pride is one thing... but that thing she swings around is scary...",
                {delay = 1000 },
                { emote = xi.emote.PANIC },
                "I don't think she'll tolerate another miss!",
                { delay = 1000 },
                "Say, could you fetch me some eastern ginger roots to help spice things up?",
                " Bring four at a time. That should do it!",
            },
            REMINDER =
            {
                { emote = xi.emote.PANIC },
                "Please bring four eastern ginger roots as soon as possible!",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "Thanks. This ought to really give my next dish some extra kick!",
                "So far, you've brought me %i ginger roots!",
                "Here's a little something for your time.",
            },
            DECLINED =
            {
                { emote = xi.emote.NO },
                "Remember, I need four eastern ginger roots.",
            },
            AFTER    =
            {
                "Phew! That dish was a real hit... I'm saved.",
                { emote = xi.emote.BOW },
                "Please bring any more eastern ginger roots that you find!",
            },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 40 }),
        [GORDO] = cq.talkStep("START", info.name),
    },
    {
        [GORDO] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tallyStep("ACCEPTED", "DECLINED", info.required.item, info.reward, "[CW]GINGER", 4, info.name, cexi.music.WHITEGATE),
        },
    },
    {
        [GORDO] =
        {
            onTrigger = cq.talkOnly("AFTER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward2, "[CW]GINGER", 4, info.name, cexi.music.WHITEGATE),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
