-----------------------------------
-- Clink to the Past (Lv60)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]CLINK_PAST 0
-- Dadaroon !pos 29.447 -6.000 10.691 53
-- !additem 2503 12
-- !additem 2187 5
-- Unlocks: TOAU Excavation
-----------------------------------
-- !setvar [CW]CLINK_PAST 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-clink_to_the_past")

local info =
{
    name   = "Clink to the Past",
    author = "Loxley",
    var    = "[CW]CLINK_PAST",
    reward =
    {
        item  = { { 605, 12 } },
        after = function(player)
            player:setCharVar("[CW]TOAU_EXCAVATION", 1)
            player:printToPlayer("You have unlocked the ability to perform Excavation in Aht Urhgan.", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
    required =
    {
        almond = { { 2503, 12 } },
        coin   = { { 2187, 5 } },
    },
}

local ROON     = "Dadaroon"
local Dadaroon = "Dadaroon"

local entity =
{
    {
        id     = ROON,
        name   = Dadaroon,
        type   = xi.objType.NPC,
        look   = 1736,
        area   = "Nashmau",
        pos    = { 29.447, -6.000, 10.691, 157 }, -- !pos 29.447 -6.000 10.691 53
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Do I knooow yooou?" },
            START    =
            {
                "Yooou see secret treasure Arrapago Reeef?",
                "Nooo? Dadaroon knoooow secret. Yeees, very, very secret!",
                { delay = 2000 },
                "Give clink clink, I shows yooou. But first...",
                "Dadaroon sooo hungry. Neeeeds 12 handful of almonds. Yooou give pleeease.",
            },
            REMINDER = { "Yooou give 12 handful of almonds pleeease." },
            ACCEPTED =
            {
                "Oooh oooh! Sooo hungry. Yuuum!",
                " . ",
                " .. ",
                " ... ",
                { delay = 3000 },
                "Now cooome clink clink! 5 Imperial gold pieces and meee tells aaall.",
            },

            REMINDER_2 = { "Now cooome clink clink! 5 Imperial gold pieces and meee tells aaall." },

            FINISHED =
            {
                "Clink clink!! Clink clink!",
                "Oook Oook! Dadaroon tells.",
                { delay = 3000 },
                "Deeep in Reeef Arrapago be excavation place. Youuu find much ooold shiny there!",
                "Buuut pickaxe must have! Clink~ clink~ clink~ clink.",
                { delay = 3000 },
                "Looook I shows. Now cooopy Dadaroon.",
                { entity = "player", emote = xi.emote.EXCAVATION },
                "Yeees! That it! That it!! Nooow you know!",
            },

            AFTER = { "Nooow yooou know secret!" },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ level = 60 }),
        [ROON] = cq.talkStep("START", info.name),
    },
    {
        [ROON] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "REMINDER", info.required.almond),
        },
    },
    {
        [ROON] =
        {
            onTrigger = cq.talkOnly("REMINDER_2"),
            onTrade   = cq.tradeStep("FINISHED", "REMINDER_2", info.required.coin, info.reward, info.name, cexi.music.NASHMAU),
        },
    },
    {
        [ROON] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
