-------------------------------------------------------
-- 'X' Marks the Spot I - Corsair Die Quest
-------------------------------------------------------
-- Steps
-------------------------------------------------------
-- !setvar [CQ]X_MARKS_THE_SPOT 0
-- Captain Farrell       !pos -22.017 0.000 23.766 53
-- Tattered Map          !pos -27.114 -6.999 292.239 54
-- Treasure Coffer       !pos 3.976 -1.795 -189.831 57
-- Ancient Artifact      !pos -1.568 -7.659 30.99 46
-- Kraken King           !pos 0.354 -7.163 7.49 46
-- Unlocks: Caster's die (Corsair die)
-- Unlocks: Bloter's die (Corsair die)
-------------------------------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cq_x_marks_the_spot")

local info =
{
    name    = "'X' Marks the Spot",
    name2   = "'X' Marks the Spot II",
    author  = "Carver",
    var     = "[CQ]X_MARKS_THE_SPOT",
    reward  =
    {
        item  = 5498, -- Caster's die (Lv75)
    },
    reward2 =
    {
        item  = 5497, -- Bolter's die (Lv75)
    },    
}

local CAPTAIN_FARRELL  = "CAPTAIN_FARRELL"
local TREASURE_COFFER  = "TREASURE_COFFER"
local TATTERED_MAP     = "TATTERED_MAP"
local LAMIA_NO_22      = "LAMIA_NO_22"
local ANCIENT_ARTIFACT = "ANCIENT_ARTIFACT"
local KRAKEN_KING      = "KRAKEN_KING"

local entity =
{
    {
        id     = CAPTAIN_FARRELL,
        name   = "Captain Farrell",
        type   = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.HUME_M,
            face = 0,
            head = 298,
            body = 298,
            hand = 298,
            legs = 298,
            feet = 298,
            main = 528,
        }),
        area      = "Nashmau",
        pos       = { -22.017, 0.000, 23.766, 226 }, -- !pos -22.017 0.000 23.766 53
        dialog    =
        {
            NAME      = true,
            DEFAULT   = { "Scram, ye scurvy dog!" },
            START     =
            {
                "Ahoy there, ye scurvy dog! I've got a proposition for ye. I be Captain Farrell, and I've heard tales of a secret map hidden deep",
                { delay = 1000 },
                " within the treacherous Arrapago Reef. Are ye brave enough to sail those perilous waters and recover me precious loot?",
                { delay = 2000 },
                { emote = xi.emote.PSYCH },
            },
            ACCEPTED  =
            {
                { music = cexi.music.REPRESSION },
                "Ye be a bold one, I'll give ye that. But mark me words, the Arrapago Reef ain't no place for landlubbers. The waters are infested",
                { delay = 1000 },
                " with dangerous sea creatures, treacherous currents, and hidden reefs that can tear a ship apart. Ye'll need a sturdy vessel",
                { delay = 1000 },
                " and a crew ye can trust.",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                " Legend has it that the treasure is guarded by the vengeful spirits of pirates who met their watery grave in the reef.",
                { delay = 1000 },
                " The key to finding it lies within an old map, but its remains were lost amongst the wreckage left by a treacherous storm.",
                { delay = 1000 },
                "   Ye'll need to gather the map to reveal the treasure's exact location.",
                { delay = 2000 },
                { music = cexi.music.NASHMAU },
            },
            STEP2 =
            {
                { music = cexi.music.REPRESSION },
                "Ah, ye've returned with the map! Ye've proven yerself a worthy corsair indeed. Hand 'em over, and let's see what secrets it holds.",
                { delay = 2000 },
                { name = 'Captain Farrell', emotion = "examines the map with keen interest." },
                { emote = xi.emote.THINK },
                { delay = 3000 },
                " Aye, this map reavels the way to the heart of Talacca Cove, where the treasure be hidden.",
                { delay = 1000 },
                " But mark my words, matey, the journey ahead won't be smooth sailin'",
                { emote = xi.emote.NO },
                { delay = 2000 },
                " The 'cove' is a treacherous place, teeming with dangers and curses. ",
                { emote = xi.emote.PANIC },
                { delay = 1000 },
                " Ye've come this far, and I've faith in ye. Venture forth, brave the currents, and follow the map's guidance.",
                { delay = 5000 },
                { music = cexi.music.NASHMAU },
            },
            STEP2_REMINDER = { "Follow the secret map to Talacca Cove and search for the treasure, ye scally wag!" },
            REMINDER       = { "Travel to Arrapago Reef and fetch me that secret map. Time to weigh anchor! " },
            FINISH         =
            {
                { music = cexi.music.A_NEW_MORNING },
                "Avast! Ye've returned, triumphant and bearing the treasure of Arrapago Reef!",
                { emote = xi.emote.CHEER },
                { delay = 3000 },
                " Ye've proven yerself to be a corsair of great skill and courage. Hand it over, and let's have a look at the spoils of yer adventure.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                { name = 'Captain Farrell', emotion = "eagerly examines the treasure with wide eyes." },
                { delay = 3000 },
                " By the beard of Davy Jones! This be the very treasure I've been seekin' for all these years. It holds not just gold and jewels,",
                { delay = 3000 },
                " but the power to bring peace to the restless souls that haunt these waters. Ye've done a great service, me hearty!",
                { delay = 3000 },
                "  Ye've earned the respect and gratitude of both myself and the crew of the Sea Serpent.",
                { delay = 3000 },
                " This day shall be etched into the annals of pirate legends. Drink, feast, and celebrate, for ye've brought honor to our name.",
                { delay = 2000 },
                { emote = xi.emote.CLAP },
                { delay = 2000 },
                " Sail on, ye valiant corsair, and may the winds guide ye to further glory!",
                { music = cexi.music.NASHMAU },
            },
            PART2_DEFAULT   = { "Scram, ye scurvy dog!" },
            PART2_START     =
            {
                "Arrr, me heartie! Ye be lookin' a bit sluggish there, like a barnacle-encrusted sea turtle!",
                { delay = 1000 },
                { emote = xi.emote.LAUGH },
                " Blackbeard be sendin' word that ye need to put some pep in yer step, for the next trial awaits ye at the very edge of the world",
                { delay = 1000 },
                " Well, what say ye?"
            },
            PART2_ACCEPTED  =
            {
                { music = cexi.music.REPRESSION },
                "Arr, listen well, ye scurvy dog! The legendary bolter's die lie awaitin' at the edge of the world guarded by a fearsome foe.",
                { delay = 1000 },
                " This trial be a test of yer mettle! Ye'll need to board the Ship Bound for Al Zahbi to hunt the Kraken King himself!",
                { delay = 1000 },
                " Mark me words! This Kraken be cunning and powerful, so ye best be ready for a fight like no other.",
                { emote = xi.emote.LAUGH },
                { delay = 3000 },
                " Gather yer crew, shapren yer cutlasses, and may the wind be ever at yer back!",
                { delay = 2000 },
                { music = cexi.music.NASHMAU },
            },
            PART2_REMINDER = { "Board the Ship Bound for Al Zahbi and confront the Kraken King!" },
            PART2_FINISH   =
            {
                { music = cexi.music.A_NEW_MORNING },
                "Well shoot me down! Ye made it back ye salty sea dog! Did ye stare into the maw of the Kraken King and live to tell the tale?",
                { delay = 1000 },
                { emote = xi.emote.CHEER },
                " Shiver me timbers! Ye've earned yerself a place in corsair legend, ye have. But tell me, what of the legendary bolter's die?",
                { delay = 3000 },
                " You found them? Indeed ye have! Smarly done, me heartie! Blackbeard will be pleased as a parrot in a sea of crackers!",
                { delay = 2000 },
                { emote = xi.emote.CLAP },
                { delay = 2000 },
                " Ye've earned the respect of the cure and a place by the fire in the heart of our pirate haven.",
                { music = cexi.music.NASHMAU },
            },
        },
    },
    {
        id     = TATTERED_MAP,
        name   = "Tattered Map",
        marker = cq.SIDE_QUEST,
        area   = "Arrapago_Reef",
        pos    = { -27.114, -6.999, 292.239 }, -- !pos -27.114 -6.999 292.239 54
        dialog =
        {
            DEFAULT = { "There is nothing out of the ordinary here." },
            FINISH  =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "successfully retrieves the remains of a secret map." },
            },
        },
    },
    {
        id          = LAMIA_NO_22,
        name        = "Lamia No.22",
        type        = xi.objType.MOB,
        look        = 1649,
        groupId     = 97,
        groupZoneId = 289,
        area        = "Talacca_Cove",
        pos         = { 29.637, -7.207, -184.272, 115 }, -- !pos 29.637 -7.207 -184.272 57
        widescan    = 1,
        level       = 75,
    },
    {
        id     = TREASURE_COFFER,
        name   = "Treasure Coffer",
        type   = xi.objType.NPC,
        look   = 969,
        area   = "Talacca_Cove",
        pos    = { 4.566, -1.852, -189.966, 1 }, -- !pos 3.976 -1.795 -189.831 57
        dialog =
        {
            DEFAULT = { "An unknown force has placed a curse upon this coffer." },
            SPAWN   = { "You hear a faint rumbling in the distance ..." },
            OPEN    =
            {
                { emotion = "retrieves a faintly inscribed die from the treasure coffer." },
                { entity = "Treasure Coffer", packet = "open" },
                { delay = 6000 },
                { entity = "Treasure Coffer", packet = "closed" },
            },
        },
    },
    {
        id          = KRAKEN_KING,
        name        = "Kraken King",
        type        = xi.objType.MOB,
        look        = 353,
        groupId     = 247,
        groupZoneId = 77,
        area        = "Open_sea_route_to_Al_Zahbi",
        pos         = { 0.354, -7.163, 7.496, 189 }, -- !pos 0.354 -7.163 7.49 46
        widescan    = 1,
        level       = 80,
    },
    {
        id     = ANCIENT_ARTIFACT,
        name   = "Ancient Artifact",
        marker = cq.SIDE_QUEST,
        area   = "Open_sea_route_to_Al_Zahbi",
        pos    = { -1.568, -7.659, 30.991 }, -- !pos -1.568 -7.659 30.99 46
        dialog =
        {
            DEFAULT  = { "There is nothing out of the ordinary." },
            SPAWN    =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "fails to retieve the ancient artifact." },
            },
            FINISH   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "successfully retrieves the ancient artifact." },
            },
        },
    },
}

local step =
{
    {
        check             = cq.checks({ level = 75, job = xi.job.COR }),
        [CAPTAIN_FARRELL] = cq.talkStep("START"),
    },
    {
        [CAPTAIN_FARRELL] = cq.menuStep("What do ye say?", { { "Yes", "ACCEPTED" }, { "No" } }, 1, info.name ),
    },
    {
        [TATTERED_MAP] = cq.menuStep("Retrieve the tattered map?", { { "Yes", "FINISH" }, { "No" } }, 1 ),
    },
    {
        [CAPTAIN_FARRELL] = cq.talkStep("STEP2"),
    },
    {
        [CAPTAIN_FARRELL] = cq.talkOnly("STEP2_REMINDER"),
        [TREASURE_COFFER] = cq.menuSpawn(LAMIA_NO_22, "Open the coffer?", { { "Run away!" }, { "Open it.", "SPAWN" }  }, 2, false),
        [LAMIA_NO_22]     = cq.killStep(TREASURE_COFFER),
    },
    {
        [TREASURE_COFFER] = cq.talkStep("OPEN"),
    },
    {
        [CAPTAIN_FARRELL] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.NASHMAU),
    },
    -- 7
    {
        check             = cq.checks({ level = 75, job = xi.job.COR, vareq = {'[CQ]X_MARKS_THE_SPOT', 7} }),
        [CAPTAIN_FARRELL] = cq.talkStep("PART2_START"),
    },
    {
        [CAPTAIN_FARRELL] = cq.menuStep("What do ye say?", { { "Yes", "PART2_ACCEPTED" }, { "No" } }, 1, info.name2 ),
    },
    {
        [CAPTAIN_FARRELL]  = cq.talkOnly("PART2_REMINDER"),
        [ANCIENT_ARTIFACT] = cq.menuSpawn(KRAKEN_KING, "Retrieve the ancient artifact?", { { "Run away!" }, { "Grab it.", "SPAWN" }  }, 2, false),
        [KRAKEN_KING]      = cq.killStep(ANCIENT_ARTIFACT),
    },
    {
        [ANCIENT_ARTIFACT] = cq.talkStep("FINISH"),
    },    
    {
        [CAPTAIN_FARRELL] = cq.giveStep("PART2_FINISH", info.reward2, info.name2, cexi.music.NASHMAU),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
