-----------------------------------
-- Outpost npc knockoff.
-----------------------------------
require("modules/module_utils")
require("scripts/zones/GM_Home/Zone")
-----------------------------------
local m = Module:new("outpost_emilia")

local outpostTable =
{
    -- [region ID]              = { gil, cp, lvl },
    [xi.region.RONFAURE]        = { 100, 10, 10 },
    [xi.region.ZULKHEIM]        = { 100, 30, 10 },
    [xi.region.NORVALLEN]       = { 150, 40, 15 },
    [xi.region.GUSTABERG]       = { 100, 10, 10 },
    [xi.region.DERFLAND]        = { 150, 40, 15 },

    [xi.region.SARUTABARUTA]    = { 100, 10, 10 },
    [xi.region.KOLSHUSHU]       = { 100, 40, 10 },
    [xi.region.ARAGONEU]        = { 150, 40, 15 },
    [xi.region.FAUREGANDI]      = { 350, 70, 35 },
    [xi.region.VALDEAUNIA]      = { 400, 50, 40 },

    [xi.region.QUFIMISLAND]     = { 150, 60, 15 },
    [xi.region.LITELOR]         = { 250, 40, 25 },
    [xi.region.KUZOTZ]          = { 300, 70, 30 },
    [xi.region.VOLLBOW]         = { 500, 70, 50 },
    [xi.region.ELSHIMOLOWLANDS] = { 250, 70, 25 },

    [xi.region.ELSHIMOUPLANDS]  = { 350, 70, 35 },
    [xi.region.TAVNAZIANARCH]   = { 300, 70, 30 },
}

m:addOverride("xi.zones.Lower_Jeuno.Zone.onInitialize", function(zone)
    -- Call the zone's original function for onInitialize
    super(zone)

    local function paymentWindow(player, npc, regionChosen)
        local gilCost = outpostTable[regionChosen][1]
        local cpCost  = outpostTable[regionChosen][2]
        local paymentWindow =
        {
            title = string.format("Gil: %i CP: %i", gilCost, cpCost),
    
            options =
            {
                {
                    "Spend Gil",
                    function(playerArg)
                        if player:getGil() >= gilCost then
                            player:delGil(gilCost)

                            if cexi.hasSetting(player, cexi.setting.EMILIA_SIGNET) then
                                local pNation  = player:getNation()
                                local pRank    = player:getRank(pNation)
                                local duration = (pRank + GetNationRank(pNation) + 3) * 3600

                                player:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)
                                player:addStatusEffect(xi.effect.SIGNET, 0, 0, duration)
                            end

                            player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

                            player:timer(1250, function(playerArg)
                                player:addStatusEffectEx(xi.effect.TELEPORT, 0, xi.teleport.id.OUTPOST, 0, 1, 0, regionChosen)
                            end)
                        else
                            player:printToPlayer("You do not have enough Gil.", 0, npc:getPacketName())
                        end
                    end,
                },
                {
                    "Spend CP",
                    function(playerArg)
                        if player:getCP() >= cpCost then
                            player:delCP(cpCost)

                            if cexi.hasSetting(player, cexi.setting.EMILIA_SIGNET) then
                                local pNation  = player:getNation()
                                local pRank    = player:getRank(pNation)
                                local duration = (pRank + GetNationRank(pNation) + 3) * 3600

                                player:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)
                                player:addStatusEffect(xi.effect.SIGNET, 0, 0, duration)
                            end

                            player:timer(1250, function(playerArg)
                                player:addStatusEffectEx(xi.effect.TELEPORT, 0, xi.teleport.id.OUTPOST, 0, 1, 0, regionChosen)
                            end)
                        else
                            player:printToPlayer("You do not have enough conquest points.", 0, npc:getPacketName())
                        end
                    end,
                },
                {
                    "I changed my mind.",
                    function(playerArg)
                        player:printToPlayer("Don't waste my time.", 0, npc:getPacketName())
                        return
                    end,
                },
            },
        }
    
        player:customMenu(paymentWindow)
    end
    
    local function processOptionChosen(player, npc, regionChosen)
        if player:hasTeleport(player:getNation(), regionChosen + 5) then
            if player:getMainLvl() >= outpostTable[regionChosen][3] then
                paymentWindow(player, npc, regionChosen)
            else
                player:printToPlayer("You do not meet the level requirement to use that outpost.", 0, npc:getPacketName())
            end
        else
            player:printToPlayer("You don't have permission to teleport to that outpost. Get lost.", 0, npc:getPacketName())
        end
    end

    -- Insert NPC into zone
    local emilia = zone:insertDynamicEntity({
        objtype  = xi.objType.NPC,
        name     = "Emilia",
        look     = 2101,
        x        = 8.584,
        y        = -1.2256,
        z        = -4.9152,
        rotation = 150,
        widescan = 1,

        onTrigger = function(player, npc)
            -- Forward declarations (required)
            local menu  = {}
            local page1 = {}
            local page2 = {}
            local page3 = {}
            local page4 = {}

            if
                (not player:isClassicMode() and
                not player:isCrystalWarrior()) or
                player:getCharVar("[CW]EMILIA") == 1
            then
                npc:lookAt(player:getPos())
                player:printToPlayer("Welcome to Emilia's Outpost Service!", xi.msg.channel.SYSTEM_3)

                local delaySendMenu = function(playerArg)
                    player:timer(100, function(playerArgMenu)
                        playerArgMenu:customMenu(menu)
                    end)
                end

                -- Menu definition.
                menu =
                {
                    title   = "Choose a destination:",
                    options = {},
                }

                -- Pages definition.
                page1 =
                {
                    {
                        "Ronfaure",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.RONFAURE)
                            end)
                        end,
                    },
                    {
                        "Zulkheim",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.ZULKHEIM)
                            end)
                        end,
                    },
                    {
                        "Norvallen",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.NORVALLEN)
                            end)
                        end,
                    },
                    {
                        "Gustaberg",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.GUSTABERG)
                            end)
                        end,
                    },
                    {
                        "Derfland",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.DERFLAND)
                            end)
                        end,
                    },
                    {
                        "Next Page",
                        function(playerArg)
                            menu.options = page2
                            delaySendMenu(playerArg)
                        end,
                    },
                }
                page2 =
                {
                    {
                        "Sarutabaruta",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.SARUTABARUTA)
                            end)
                        end,
                    },
                    {
                        "Kolshushu",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.KOLSHUSHU)
                            end)
                        end,
                    },
                    {
                        "Aragoneu",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.ARAGONEU)
                            end)
                        end,
                    },
                    {
                        "Fauregandi",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.FAUREGANDI)
                            end)
                        end,
                    },
                    {
                        "Valdeaunia",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.VALDEAUNIA)
                            end)
                        end,
                    },
                    {
                        "Next Page",
                        function(playerArg)
                            menu.options = page3
                            delaySendMenu(playerArg)
                        end,
                    },
                }
                page3 =
                {
                    {
                        "Qufim",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.QUFIMISLAND)
                            end)
                        end,
                    },
                    {
                        "Li'Telor",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.LITELOR)
                            end)
                        end,
                    },
                    {
                        "Kuzotz",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.KUZOTZ)
                            end)
                        end,
                    },
                    {
                        "Vollbow",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.VOLLBOW)
                            end)
                        end,
                    },
                    {
                        "Elshimo Lowlands",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.ELSHIMOLOWLANDS)
                            end)
                        end,
                    },
                    {
                        "Next Page",
                        function(playerArg)
                            menu.options = page4
                            delaySendMenu(playerArg)
                        end,
                    },
                }
                page4 =
                {
                    {
                        "Elshimo Uplands",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.ELSHIMOUPLANDS)
                            end)
                        end,
                    },
                    {
                        "Tavnazia",
                        function(playerArg)
                            playerArg:timer(50, function(playerArgMenu)
                                processOptionChosen(playerArgMenu, npc, xi.region.TAVNAZIANARCH)
                            end)
                        end,
                    },
                    {
                        "First Page",
                        function(playerArg)
                            menu.options = page1
                            delaySendMenu(playerArg)
                        end,
                    },
                }
                menu.options = page1
                delaySendMenu(player)
            else
                player:printToPlayer("You must complete the quest \'Up, Up and Away!\' to unlock access to Emilia", xi.msg.channel.SYSTEM_3)
                return
            end
        end,
    })

    utils.unused(outpostBitch)
end)

return m
