-----------------------------------
-- EXP Guide (S) - Travel to WotG areas
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------

local m = Module:new("exp_guide_past")

local areas =
{
    -- Page 1
    {
        { "East Ronfaure (8-23)",      {   66.3820, -57.6427,  219.8800,  76,  81 } }, -- East Ronfaure (S) Near City
        { "West Sarutabaruta (8-25)",  {  342.2117,  -5.0332,  -10.1334, 158,  95 } }, -- West Sarutabaruta (S) Near City
        { "North Gustaberg (22-28)",   {  624.7084,  -7.3071,  477.1905, 116,  88 } }, -- Ornery Sheep
        { "Batallia Downs (25-35)",    {   80.5867, -16.0000, -202.0646, 172,  84 } }, -- Hill with Lycopodium and Flies
    },

    -- Page 2
    {
        { "Vunkerl Inlet (31-38)",     { -346.2037, -31.4306,  280.2283, 150,  83 } }, -- Beetle Bird Bridge
        { "West Sarutabaruta (32-37)", {  240.7750, -20.4395,  508.9936, 184,  95 } }, -- Savanna Dhalmel
        { "North Gustaberg (32-38)",   { -325.2352,  40.5477,  -47.7761, 111,  88 } }, -- Huge Spider
    },

    -- Page 3
    {
        { "Jugner Forest (35-41)",     {  462.8053,  -0.9885, -147.0345, 161,  82 } }, -- Stag Beetle
        { "Fort K.N. (37-43)",         {  -59.9255, -32.3110,  521.6513, 249,  96 } }, -- War Lizard
        { "Sau. Champaign (41-47)",    { -238.8084,   8.0000,  117.0354,  83,  98 } }, -- Diving Beetle
    },

    -- Page 4
    {
        { "Batallia Downs (43-50)",    { -460.2269, -38.0000,  341.7351, 174,  84 } }, -- Tiger and Beetle
        { "Mer. Mountains (46-51)",    {  348.7932,  -7.9403,  486.3966, 134,  97 } }, -- Lynx
        { "Vunkerl Inlet (59-64)",     { -274.5567, -39.9639, -363.2717, 156,  83 } }, -- Pugs and Crabs
    },

    -- Page 5
    {
        { "Crawlers' Nest (66-71)",    { -164.7214,  -0.2213,  219.9864, 125, 171 } }, -- Processionaire
        { "Grauberg (70-75)",          { -198.7632, -32.0042,  323.9373, 225,  89 } }, -- Hippo/Pixie
        { "Beau. Glacier (74+)",       { -339.9303, -93.0500,  158.7435,  62, 136 } }, -- Cyhiraeth
    },
}

local secret =
{
    { "Xarcabard (S)", { 2.9036, -35.1137, 137.7475, 65, 137 }}, -- Caracal
}

local delaySendMenu = function(player, menu)
    player:timer(50, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function gotoLocation(player, location)
    player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

    player:timer(2000, function(playerArg)
        playerArg:setPos(unpack(location))
    end)
end

local function offerSigil(player, location)
    delaySendMenu(player, {
        title   = "Receive Sigil?",
        options =
        {
            {
                "No",
                function()
                    gotoLocation(player, location)
                end,
            },
            {
                "Yes",
                function()
                    player:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)
                    player:addStatusEffect(xi.effect.SIGIL, 0, 0, 15000)
                    gotoLocation(player, location)
                end,
            },
        }
    })
end

local function areaMenu(player, npc, page)
    local options = {}

    for _, area in pairs(areas[page]) do
        table.insert(options, {
            area[1],
            function()
                offerSigil(player, area[2])
            end,
        })
    end

    if page > 1 then
        table.insert(options, {
            "Previous",
            function()
                areaMenu(player, npc, page - 1)
            end,
        })
    end

    if page < #areas then
        table.insert(options, {
            "Next",
            function()
                areaMenu(player, npc, page + 1)
            end,
        })
    end

    delaySendMenu(player, {
        title   = "Choose your (S) destination",
        options = options,
    })
end

local function guideOnTrade(player, npc, trade)
    if not player:getCharVar("[CQ]BLAST_TO_THE_PAST") == 5 then
        player:printToPlayer("You must complete \"Blast to the Past\" to use the EXP Guide (S).", xi.msg.channel.SYSTEM_3)
        return
    end

    local hasWarpScroll = player:hasItem(4181)

    -- check to see if our player has a warp scroll, if not, give them one.
    if not hasWarpScroll then
        npcUtil.giveItem(player, xi.item.SCROLL_OF_INSTANT_WARP) -- scroll_of_instant_warp
    end

    local options = {}

    for _, area in pairs(secret) do
        table.insert(options, {
            area[1],
            function()
                offerSigil(player, area[2])
            end,
        })
    end

    table.insert(options, {
        "Exit",
        function()
        end,
    })

    delaySendMenu(player, {
        title   = "Secret Menu (Merit Camps)",
        options = options,
    })
end

local function guideOnTrigger(player, npc)
    -- Players must complete "Near death experience" to unlock
    if player:getCharVar("[CQ]BLAST_TO_THE_PAST") < 5 then
        player:printToPlayer("A faint glow eminates from the EXP Guide (S)...", xi.msg.channel.SYSTEM_3)

        player:timer(1000, function(playerArg)
            playerArg:printToPlayer(" Some book pages appear to be missing.", xi.msg.channel.NS_SAY)
        end)

        player:timer(2500, function(playerArg)
            playerArg:printToPlayer(" Rumor has it, page fragments were seen scattered throughout Batallia Downs (S).", xi.msg.channel.NS_SAY)
        end)

        return
    end

    local hasWarpScroll = player:hasItem(4181)

    -- check to see if our player has a warp scroll, if not, give them one.
    if not hasWarpScroll then
        npcUtil.giveItem(player, xi.item.SCROLL_OF_INSTANT_WARP) -- scroll_of_instant_warp
    end

    areaMenu(player, npc, 1)
end

cexi.util.liveReload(m, {
    ["RuLude_Gardens"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "EXP Guide (S)", --Place in WG near the AH at these coordinates
            look      = 2290,
            x         = 34.911,
            y         = 9.000,
            z         = -55.380,
            rotation  = 66,
            onTrade   = guideOnTrade,
            onTrigger = guideOnTrigger,
        },
    },
})

return m
