-----------------------------------
-- Helper Rewards (CW/WEW)
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("helper_rewards")

local settings =
{
    name = "Perrin",
    pos  = { 27.720, 0.000, -11.116, 192 }, -- !pos 27.720, 0.000, -11.116 246
    area = "Port_Jeuno",
    look = cexi.util.look({
        race = xi.race.HUME_M,
        face = cexi.face.A2,
        head = 36, -- Scarlet Ribbon
        body = cexi.model.RSE,
        hand = cexi.model.FIELD_TUNICA,
        legs = cexi.model.FISHING_TUNICA,
        feet = cexi.model.FISHING_TUNICA,
        main = 306, -- Monster Signa
    }),
    pointsVar    = "[HELPER]POINTS",
    milestoneVar = "[HELPER]MILESTONE",
    dialog       =
    {
        DEFAULT = { "Sorry, I can't do anything for you." },
        START   = { "I have special rewards for those who help out other adventurers!" },
        DECLINE = { "You don't have enough points for that one yet!" },
        MISSED  = { "Looks like you dropped these!" },
    },
}

local rewards =
{
    { "Cracker x99",        { { 4167, 99 } },  10 },
    { "Brilliant Snow x99", { { 4216, 99 } },  20 },
    { "Stuffed Chocobo",                 264,  30 },
    { "Charity Cap",                   11812,  40 },
    { "Shadow Lord Shirt",             26517,  50 },
    { "Poroggo Coat",                  26956,  80 },
    { "Harpsichord",                     320, 120 },
    { "Mizukage Naginata",             21862, 240 },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function getIndex(itemName)
    for itemIndex, item in pairs(rewards) do
        if item[1] == itemName then
            return itemIndex
        end
    end
end

local function selectReward(player, npc, item)
    delaySendMenu(player, {
        title   = string.format("Claim your %s?", item[1]),
        options =
        {
            {
                "Yes",
                function()
                    local helperPoints = player:getCharVar(settings.pointsVar)

                    if helperPoints < item[3] then
                        npc:facePlayer(player, true)
                        player:printToPlayer(settings.name .. " : " .. settings.dialog.DECLINE[1], xi.msg.channel.NS_SAY)
                        return
                    end

                    if npcUtil.giveItem(player, item[2]) then
                        local milestones = player:getCharVar(settings.milestoneVar)
                        local itemIndex  = getIndex(item[1])
                        local result     = utils.mask.setBit(milestones, itemIndex, true)

                        player:setCharVar(settings.milestoneVar, result)
                    end
                end,
            },
            {
                "Not yet",
                function()
                end,
            },
        },
    })
end

local function onTrigger(player, npc)
    local helperPoints = player:getCharVar(settings.pointsVar)
    local points       = string.format("Helper Points (%u):", helperPoints)

    npc:facePlayer(player, true)

    if not (player:isCrystalWarrior() or player:isClassicMode()) then
        player:printToPlayer(settings.name .. " : " .. settings.dialog.DEFAULT[1], xi.msg.channel.NS_SAY)
        return
    end

    local missed = player:getCharVar("[HELPER]EXP_SCROLLS")

    if missed > 0 then
        cexi.util.dialog(player, settings.dialog.MISSED, settings.name, { npc = npc })

        if npcUtil.giveItem(player, { { xi.item.DRAGON_CHRONICLES, missed } }) then
            player:setCharVar("[HELPER]EXP_SCROLLS", 0)
        end

        return
    end

    player:printToPlayer(settings.name .. " : " .. settings.dialog.START[1], xi.msg.channel.NS_SAY)
    cexi.util.simpleShop(player, npc, rewards, selectReward, points, 0, { milestone = settings.milestoneVar })
end

cexi.util.liveReload(m, {
    [settings.area] =
    {
        {
            name      = settings.name,
            objtype   = xi.objType.NPC,
            look      = settings.look,
            x         = settings.pos[1],
            y         = settings.pos[2],
            z         = settings.pos[3],
            rotation  = settings.pos[4],
            onTrigger = onTrigger,
        },
    },
})

return m
