-----------------------------------
-- CatsEye Recruiters
-----------------------------------
-- San d'Oria !pos 112.092 -0.200 110.775 230
-- Bastok     !pos -293.285 -12.020 -74.836 235
-- Windurst   !pos -13.121 2.750 -70.214 241
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')

local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("recruiters")

local settings =
{
    name   = "Recruiter",

    vars =
    {
        RE_MILESTONE = "[RE]MILESTONE",
        RE_CLAIMED   = "[RE]CLAIMED",
        RE_PAGE      = "[RE]PAGE",
    },

    reward =
    {
        cw =
        {
            TIER_1 = { { 4394, 99 } }, -- (Lv10) Ginger Cookie x99
            TIER_2 = { { 4381, 12 } }, -- (Lv20) Meat Mithkabob x12
            TIER_3 = 15754,            -- (Lv30) Sprinter's Shoes

            -- Friend to Lv10 = 1 point
            -- Friend to Lv20 = 3 points
            -- Friend to Lv30 = 5 points
            MILESTONES =
            {
                {    1, "Crystal Board",     {  3687, { 4394, 99 } } }, -- Crystal Board,  Ginger Cookie   x99 (  1 friend  to Lv10)
                {    5, "Fighter Board",     {  3690, { 4164, 12 } } }, -- Fighter Board,  Prism Powder    x12 (  1 friend  to Lv30)
                {   10, "Dancer Board",      {  3688, { 4165, 12 } } }, -- Dancer Board,   Silent Oil      x12 (  2 friends to Lv30)
                {   15, "Byakko Masque",     { 23737, 15793 }        }, -- Byakko Masque,  Anniversary Ring    (  3 friends to Lv30)
                {   25, "Iapetus",           { 21886, { 1126, 99 } } }, -- Iapetus,        Beastmen's Seal x99 (  5 friends to Lv30)
                {   50, "Tidal Talisman",    { 11290, { 1127, 99 } } }, -- Tidal Talisman, Kindred's Seal  x99 ( 10 friends to Lv30)
                {  100, "Iradiance Blade",   21693                   }, -- Iradiance Blade                     ( 20 friends to Lv30)
                {  250, "Aphelion Knuckles", 20514                   }, -- Aphelion Knuckles                   ( 50 friends to Lv30)
                {  500, "Fermion Sword",     20694                   }, -- Fermion Sword                       (100 friends to Lv30)
                { 1000, "Judgment Day",       3680                   }, -- Judgment Day                        (200 friends to Lv30)
            },
        },

        qol =
        {
            TIER_1 = 15754,             -- (Lv25) Sprinter's Shoes
            TIER_2 = { { 1126, 99  } }, -- (Lv50) Beastman's Seal x99
            TIER_3 = 15793,             -- (Lv75) Anniversary Ring

            -- Friend to Lv25 = 1 point
            -- Friend to Lv50 = 3 points
            ---Friend to Lv75 = 5 points
            MILESTONES =
            {
                {    1, "Crystal Board",     {  3687, { 4394, 99 } } }, -- Crystal Board,  Ginger Cookie   x99 (  1 friend  to Lv25)
                {    5, "Fighter Board",     {  3690, { 4164, 12 } } }, -- Fighter Board,  Prism Powder    x12 (  1 friend  to Lv75)
                {   10, "Dancer Board",      {  3688, { 4165, 12 } } }, -- Dancer Board,   Silent Oil      x12 (  2 friends to Lv75)
                {   15, "Byakko Masque",     { 23737, 15793 }        }, -- Byakko Masque,  Anniversary Ring    (  3 friends to Lv75)
                {   25, "Iapetus",           { 21886, { 1126, 99 } } }, -- Iapetus,        Beastmen's Seal x99 (  5 friends to Lv75)
                {   50, "Mandraguard",       { 10807, { 1127, 99 } } }, -- Mandraguard,    Kindred's Seal  x99 ( 10 friends to Lv75)
                {  100, "Twinned Blade",     21623                   }, -- Twinned Blade                       ( 20 friends to Lv75)
                {  250, "Twinned Shield",    26414                   }, -- Twinned Shield                      ( 50 friends to Lv75)
                {  500, "Decazoom Mk-XI",    21280                   }, -- Decazoom Mk-XI                      (100 friends to Lv75)
                { 1000, "Judgment Day",       3680                   }, -- Judgment Day                        (200 friends to Lv75)
            },
        },
    },
    dialog =
    {
        DEFAULT = { "I am unable to assist you." },
        NOTYET  = { "You are not yet eligible for a reward." },
        AFFORD  = { "Sorry adventurer, you don't have enough points to claim that yet." },
        GIVEN   = { "Here's your reward!" },

        TIER_1  =
        {
            { emote = xi.emote.CLAP },
            "You've progressed well since %s first recruited you.\n Keep up the great work, adventurer. Here's a reward for reaching level %u!",
        },

        TIER_2  =
        {
            { emote = xi.emote.CLAP },
            "You've grown a lot stronger! I'm glad %s brought you here to aid us.\n In recognition of reaching level %u, I'm awarding you this.",
        },

        TIER_3  =
        {
            { emote = xi.emote.CLAP },
            "Well, well, well. I bet %s is proud to see how far you've come!\n To congratulate you on level %u, I'd like to give you this.",
        },

        GREETING =
        {
            { emote = xi.emote.WELCOME },
            "Greetings %s, I'm a Referral Concierge.\n I'm here to help you bring your friends to CatsEye.",
        },

        INITIAL_CW =
        {
            "To invite a friend, please have them create an account with the following link:",
            " https://catseyexi.com/join/%s",
            { delay = 500 },
            "Once their character reaches level 10, 20, and 30, they will be eligible for rewards.",
            " For each of these milestones, you'll also receive some points toward your own rewards.",
            { delay = 1000 },
            { emote = xi.emote.BOW },
            "When you or your friend are ready to claim rewards, come back and see me.",
        },

        INITIAL_QOL =
        {
            "To invite a friend, please have them create an account with the following link:",
            " https://catseyexi.com/join/%s",
            { delay = 500 },
            "Once their character reaches level 25, 50, and 75, they will be eligible for rewards.",
            " For each of these milestones, you'll also receive some points toward your own rewards.",
            { delay = 1000 },
            { emote = xi.emote.BOW },
            "When you or your friends are ready to claim rewards, come back and see me.",
        },
    },
}

local npcs =
{
    {
        name = "Vennoire R.C.",
        look = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = B1,
            head = 459, -- Byakko Masque
            body = 309, -- Chocobo Shirt
            hand = cexi.model.SHINOBI,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
        }),
        zone = "Southern_San_dOria",             -- (L-6)
        pos  = { 114.565, -0.200, 106.923, 75 }, -- !pos 114.565 -0.200 106.923 230
    },
    {
        name = "Cara R.C.",
        look = cexi.util.look({
            race = xi.race.HUME_F,
            face = A1,
            head = 459, -- Byakko Masque
            body = 309, -- Chocobo Shirt
            hand = cexi.model.SHINOBI,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
        }),
        zone = "Bastok_Markets",                     -- (F-8)
        pos  = { -293.285,  -12.020, -74.836, 107 }, -- !pos -293.285 -12.020 -74.836 235
    },
    {
        name = "Una Mhiga R.C",
        look = cexi.util.look({
            race = xi.race.MITHRA,
            face = A1,
            head = 459, -- Byakko Masque
            body = 309, -- Chocobo Shirt
            hand = cexi.model.SHINOBI,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
        }),
        zone = "Windurst_Woods",                -- (H-11)
        pos  = { -13.121, 2.750, -70.214, 45 }, -- !pos -13.121 2.750 -70.214 241
    },
}

local function delayMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local referralTiers =
{
    {
        achievedBit = 0,
        claimedBit  = 1,
        messageText = settings.dialog.TIER_1,
        reward      =
        {
            settings.reward.cw.TIER_1,
            settings.reward.qol.TIER_1,
        },
        level       =
        {
            cw  = 10,
            qol = 25,
        },
    },
    {
        achievedBit = 2,
        claimedBit  = 3,
        messageText = settings.dialog.TIER_2,
        reward      =
        {
            settings.reward.cw.TIER_2,
            settings.reward.qol.TIER_2,
        },
        level       =
        {
            cw  = 20,
            qol = 50,
        },
    },
    {
        achievedBit = 4,
        claimedBit  = 5,
        messageText = settings.dialog.TIER_3,
        reward      =
        {
            settings.reward.cw.TIER_3,
            settings.reward.qol.TIER_3,
        },
        level       =
        {
            cw  = 30,
            qol = 75,
        },
    },
}

local function rewardMenu(player, npc)
    local page    = player:getLocalVar(settings.vars.RE_PAGE)
    local claimed = player:getCharVar(settings.vars.RE_CLAIMED)
    local points  = player:getReferralPoints()
    local options = {}

    if page > 0 then
        table.insert(options, {
            "(Prev)",
            function(playerArg)
                player:setLocalVar(settings.vars.RE_PAGE, page - 1)
                rewardMenu(player, npc)
            end,
        })
    end

    for i = 1, 4 do
        local row  = (page * 4) + i
        local item = settings.reward.qol.MILESTONES[row]

        if player:isCrystalWarrior() then
            item = settings.reward.cw.MILESTONES[row]
        end

        if item ~= nil then
            local claimString = string.format("(%u): %s", item[1], item[2])

            if utils.mask.getBit(claimed, row) then
                table.insert(options, {
                    string.format("(%u): Claimed", item[1]),
                    function()
                    end,
                })
            else
                table.insert(options, {
                    string.format("(%u): %s", item[1], item[2]),
                    function(playerArg)
                        if points < item[1] then
                            cexi.util.dialog(player, settings.dialog.AFFORD, npc:getPacketName(), { npc = npc })
                            return
                        end

                        if player:getFreeSlotsCount() < 2 then
                            player:fmt('{} : Please return after sorting your inventory.', npc:getPacketName())
                            return
                        end

                        npcUtil.giveItem(player, item[3])
                        local updatedValue = utils.mask.setBit(claimed, row, true)

                        player:setCharVar(settings.vars.RE_CLAIMED, updatedValue)
                        cexi.util.dialog(player, settings.dialog.GIVEN, npc:getPacketName(), { npc = npc })
                    end,
                })
            end
        end
    end

    if settings.reward.qol.MILESTONES[(page * 4) + 1] ~= nil then
        table.insert(options, {
            "(Next)",
            function(playerArg)
                player:setLocalVar(settings.vars.RE_PAGE, page + 1)
                rewardMenu(player, npc)
            end,
        })
    end

    delayMenu(player, {
        title   = string.format("Referral Points: %u", points),
        options = options,
    })
end

local function messageExplain(player, npc)
    if player:isCrystalWarrior() then
        cexi.util.dialog(player, settings.dialog.INITIAL_CW, npc:getPacketName(), { [1] = player:getName(), npc = npc })
    else
        cexi.util.dialog(player, settings.dialog.INITIAL_QOL, npc:getPacketName(), { [1] = player:getName(), npc = npc })
    end
end

local function onTriggerRecruiter(player, npc)
    local referral = cexi.util.capitalize(player:getReferral())

    -- If player is referred, check if they are eligible to received rewards
    if referral ~= nil and string.len(referral) > 0 then
        local result = player:getCharVar(settings.vars.RE_MILESTONE)

        for k, v in pairs(referralTiers) do
            if
                utils.mask.getBit(result, v.achievedBit) and
                not utils.mask.getBit(result, v.claimedBit)
            then
                local level = v.level.qol

                if player:isCrystalWarrior() then
                    level = v.level.cw
                end

                cexi.util.dialog(player, v.messageText, npc:getPacketName(), { [1] = referral, [2] = level, npc = npc })

                player:timer(2000, function()
                    local rewardItem = v.reward[2]

                    if player:isCrystalWarrior() then
                        rewardItem = v.reward[1]
                    end

                    if npcUtil.giveItem(player, rewardItem) then
                        player:setCharVar(settings.vars.RE_MILESTONE, utils.mask.setBit(result, v.claimedBit, true))
                        return
                    end
                end)
            end
        end
    end

    cexi.util.dialog(player, settings.dialog.GREETING, npc:getPacketName(), { [1] = player:getName(), npc = npc })

    local mainOptions =
    {
        {
            "Nothing",
            function()
            end,
        },
        {
            "Please explain",
            function(playerArg)
                messageExplain(playerArg, npc)
            end,
        },
        {
            "Claim rewards",
            function(playerArg)
                rewardMenu(playerArg, npc)
            end,
        },
    }

    local delay = cexi.util.dialogDelay(settings.dialog.GREETING)

    npc:timer(delay, function()
        delayMenu(player, {
            title   = "How may I assist you?",
            options = mainOptions,
        })
    end)
end

for _, recruiter in pairs(npcs) do
    cexi.util.liveReload(m, {
        [recruiter.zone] =
        {
            {
               name       = recruiter.name,
               packetName = string.char(0xAA) .. recruiter.name,
               objtype    = xi.objType.NPC,
               look       = recruiter.look,
               x          = recruiter.pos[1],
               y          = recruiter.pos[2],
               z          = recruiter.pos[3],
               rotation   = recruiter.pos[4],
               onTrigger  = onTriggerRecruiter,
           },
        },
    })
end

return m
