-----------------------------------
-- Lv75/Rank 10 Reward NPC
-- !pos -97 -18 135 135
-----------------------------------
-- Awards Stage 3 Relic Weapons
-----------------------------------
require('modules/module_utils')
require('scripts/globals/utils')
require('scripts/globals/npc_util')
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------------
local m = Module:new('new_player_rewards')

local relicVar = 'New_Player_Reward'

local rewards =
{
    { 'Caestus',          18263 },
    { 'Batardeau',        18269 },
    { 'Caliburn',         18275 },
    { 'Valhalla',         18281 },
    { 'Ogre Killer',      18287 },
    { 'Abaddon Killer',   18293 },
    { 'Bec de Faucon',    18305 },
    { 'Gae Assail',       18299 },
    { 'Yoshimitsu',       18311 },
    { 'Totsukanotsurugi', 18317 },
    { 'Gullintani',       18323 },
    { 'Thyrus',           18329 },
    { 'Futatokoroto',     18347 },
    { 'Ferdinand',        18335 },
    { 'Millenium Horn',   18341 },
    { 'Ancile',           15069 },
    { 'Mythos Token',     28918 },
    { 'Octave Club',      18852 },
    { 'Defending Ring',   13566 },
}

local exemptVars =
{
    'FIC_December',
    'FIC_May',
    'FIC_July',
    'FIC_December_Kirin',
    'FIC_May_Existing',
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local dialog =
{
    { despawn = { 'Spatial Anomaly' } },
    { spawn   = { 'Franz' } },
    { delay   = 2000 },
    { entity = 'Franz', face = 'player' },
    'Franz : Adventurer, you\'ve proven yourself worth your mettle.',
    ' Take this as a token of my recognition of your valiant efforts.',
    { entity = 'Franz', emote = xi.emote.TOSS },
    { delay   = 3000 },
    { despawn = { 'Franz' } },
    { spawn   = { 'Spatial Anomaly' } },
}

local function confirmTrade(player, npc, item)
    local confirmMenu =
    {
        title   = string.format('Redeem Reward: %s?', item[1]),
        options =
        {
            {
                'No',
                function(playerArg)
                end,
            },
            {
                'Yes',
                function(playerArg)
                    if player:getFreeSlotsCount() == 0 then
                        player:fmt('Spatial Anomaly : Please return after sorting your inventory.')
                    else
                        playerArg:setCharVar(relicVar, item[2])
                        player:addItem(item[2])
                        cexi.util.dialog(player, dialog)

                        local delay = cexi.util.dialogDelay(dialog)

                        player:timer(delay, function()
                            player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, item[2])
                        end)
                    end
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

local function onTriggerShop(player, npc)
    -- FIC not available to
    local exempt = player:isCrystalWarrior() or -- CW chars
    player:getID() < 2500 -- or old characters that participated in discord FIC

    for _, ficVar in pairs(exemptVars) do
        if player:getCharVar(ficVar) > 0 then
            exempt = true
        end
    end

    if
        not exempt and
        player:getCharVar(relicVar) == 0
    then
        local hasRank10 = player:getRank(xi.nation.SANDORIA) >= 10 or
                          player:getRank(xi.nation.BASTOK)   >= 10 or
                          player:getRank(xi.nation.WINDURST) >= 10

        -- WEW require a 110 craft along with other requirements
        local has110Craft = false

        if player:isClassicMode() then
            for i = xi.skill.WOODWORKING, xi.skill.COOKING do
                if player:getCharSkillLevel(i) >= 1100 then
                    has110Craft = true
                end
            end
        end

        if
            hasRank10 and
            player:getMainLvl() == 75 and
            (has110Craft or
            not player:isClassicMode())
        then
            local title = 'Choose your milestone reward:'

            npc:facePlayer(player, true)
            cexi.util.simpleMenu(player, npc, rewards, confirmTrade, title)
        else
            player:fmt('Return when you have grown stronger.')
        end
    else
        player:fmt('There is nothing out of the ordinary.')
    end
end

cexi.util.liveReload(m, {
    ['Castle_Zvahl_Baileys'] =
    {
        {
            name      = 'Spatial Anomaly',
            objtype   = xi.objType.NPC,
            hideName  = true,
            look      = 2326,
            x         = 386.572,
            y         = -12,
            z         = -23.286,
            widescan  = 1,
            onTrigger = onTriggerShop,
        },
        {
            name      = 'Franz',
            objtype   = xi.objType.NPC,
            look      = cexi.util.look({
                race  = xi.race.HUME_M,
                face  = cexi.face.B3,
                head  = 111,
                body  = 302,
                hand  = 120,
                legs  = 208,
                feet  = 208,
                main  = 424,
            }),
            x         = 388.616,
            y         = -12,
            z         = -23.388,
            rotation  = 187,
            hidden    = true,
            widescan  = 1,
        },
    },
})

return m
