-----------------------------------
-- Limitrix
-----------------------------------
-- !pos -174.862 -5.000 4.402 246
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require('scripts/globals/utils')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_limitrix")

local settings =
{
    name            = "Limitrix",
    look            = 1355,
    area            = "Lower_Jeuno",
    pos             = { -42.56, 5.9, -117.84, 181 }, -- !pos -42.56 5.9 -117.84 245
    varJob          = "[Limitrix]LIMITRIX_JOBS",
    storedMeritsVar = "[Limitrix]StoredMerits",
    dialog =
    {
        DEFAULT =
        {
            "Got nuthin' to say to you."
        },
        EXPLAIN =
        {
            "I used to be puny like the other goblins around here, but I have this one weird trick that I'll let you in on.",
            "I'm offering a one time deal to special adventurers just like yourself.",
            "I'll refund all of the Merit Points spent for your current job.",
            "However, this is a once in a lifetime opportunity, don't get used to it!",
            "Speak to me again when you're ready to try it.",
        },
        LVL75 =
        {
            "Come back when yer 75!",
        },
        NOMERITS =
        {
            "You don't have any Merit Points spent on this job.",
        },
        DONE    =
        {
            "Looks like you've already reset this job! That's all I can do for ya.",
        },
    },
}

settings.dialog.PROCESS =
{
    "All right, here goes!",
    { entity = settings.name, packet = "cabk" },
    { delay = 3000 },
    { entity = settings.name, animate = 892, target= "player" },
    { entity = settings.name, packet = "shbk" },
}

local allocateRefundedMerits = function(player, meritPoints)
    local maxPoints   = 50 + player:getMerit(xi.merit.MAX_HP + 0x04)
    local remainingPoints = player:getCharVar(settings.storedMeritsVar)

    if meritPoints + player:getMeritCount() > maxPoints then
        remainingPoints = remainingPoints + meritPoints - (maxPoints - player:getMeritCount())
        player:setCharVar(settings.storedMeritsVar, remainingPoints)
    end

    player:setMerits(player:getMeritCount() + meritPoints)

    return meritPoints, remainingPoints
end

local getJobMeritsSpent = function(player, refund)
    -- direct copy from enum/merit.lua
    local meritCategory =
    {
        HP_MP      = 0x0040,
        ATTRIBUTES = 0x0080,
        COMBAT     = 0x00C0,
        MAGIC      = 0x0100,
        OTHERS     = 0x0140,

        WAR_1 = 0x0180,
        MNK_1 = 0x01C0,
        WHM_1 = 0x0200,
        BLM_1 = 0x0240,
        RDM_1 = 0x0280,
        THF_1 = 0x02C0,
        PLD_1 = 0x0300,
        DRK_1 = 0x0340,
        BST_1 = 0x0380,
        BRD_1 = 0x03C0,
        RNG_1 = 0x0400,
        SAM_1 = 0x0440,
        NIN_1 = 0x0480,
        DRG_1 = 0x04C0,
        SMN_1 = 0x0500,
        BLU_1 = 0x0540,
        COR_1 = 0x0580,
        PUP_1 = 0x05C0,
        DNC_1 = 0x0600,
        SCH_1 = 0x0640,

        WS = 0x0680,

        GEO_1 = 0x06C0,
        RUN_1 = 0x0700,

        -- UNK_1 = 0x0740,
        -- UNK_2 = 0x0780,
        -- UNK_3 = 0x07C0,

        WAR_2 = 0x0800,
        MNK_2 = 0x0840,
        WHM_2 = 0x0880,
        BLM_2 = 0x08C0,
        RDM_2 = 0x0900,
        THF_2 = 0x0940,
        PLD_2 = 0x0980,
        DRK_2 = 0x09C0,
        BST_2 = 0x0A00,
        BRD_2 = 0x0A40,
        RNG_2 = 0x0A80,
        SAM_2 = 0x0AC0,
        NIN_2 = 0x0B00,
        DRG_2 = 0x0B40,
        SMN_2 = 0x0B80,
        BLU_2 = 0x0BC0,
        COR_2 = 0x0C00,
        PUP_2 = 0x0C40,
        DNC_2 = 0x0C80,
        SCH_2 = 0x0CC0,
        -- UNK_4 = 0x0D00,
        GEO_2 = 0x0D40,
        RUN_2 = 0x0D80,

        -- START = 0x0040,
        -- COUNT = 0x0D80,
    }

    local total = 0
    for merit, meritID in pairs(xi.merit) do
        if
            (meritID >= meritCategory['WAR_1'] and meritID <= meritCategory['SCH_1'] + 0x06) or
            (meritID >= meritCategory['GEO_1'] and meritID <= meritCategory['RUN_1'] + 0x08) or
            (meritID >= meritCategory['WAR_2'] and meritID <= meritCategory['SCH_2'] + 0x0A) or
            (meritID >= meritCategory['GEO_2'] and meritID <= meritCategory['RUN_2'] + 0x06)
        then
            -- we're in a job group. The below will only return nonzero if we're on the right job and lvl 75
            local tempValue = player:getMerit(meritID)
            if tempValue > 0 then
                if refund then
                    -- reset all Merit Points for this job and store total merits to refund
                    total = total + player:lowerMeritToZero(meritID)
                else
                    total = total + tempValue
                end
            end
        end
    end

    return total
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function resetJob(player, npc)
    local mainJob     = player:getMainJob()
    local varStatus   = player:getCharVar(settings.varJob)

    delaySendMenu(player, {
        title   = "Are you absolutely sure?",
        options =
        {
            {
                "Not yet",
                function()
                end,
            },
            {
                string.format("Refund %s-specific Merit Points", xi.jobNames[mainJob][1]),
                function()
                    cexi.util.dialog(player, settings.dialog.PROCESS, settings.name, { npc = npc })

                    player:setCharVar(settings.varJob, utils.mask.setBit(varStatus, mainJob, true))
                    -- same function as above, but this time it actually resets the job's merits spent
                    local refundedMerits = getJobMeritsSpent(player, true)
                    local storedMerits = 0
                    refundedMerits, storedMerits = allocateRefundedMerits(player, refundedMerits)

                    player:timer(cexi.util.dialogDelay(settings.dialog.PROCESS) + 1000, function(playerArg)
                        playerArg:printToPlayer(string.format("%s gains %u merit points.", player:getName(), refundedMerits), xi.msg.channel.SYSTEM_3)
                        playerArg:printToPlayer(string.format("%s : Your %s is all reset and ready to go!", settings.name, xi.jobNames[mainJob][2]), xi.msg.channel.NS_SAY)
                        if storedMerits > 0 then
                            playerArg:printToPlayer(string.format("%s : You didn't have enough space to store all the merits, you now have %u banked!", settings.name, storedMerits), xi.msg.channel.NS_SAY)
                        end
                    end)
                end,
            },
        },
    })
end

local function onTrigger(player, npc)
    if not player:isClassicMode() then
        cexi.util.dialog(player, settings.dialog.DEFAULT, settings.name, { npc = npc })
        return
    end

    local options =
    {
        {
            "Nothing",
            function()
            end,
        },
        {
            "What's this all about?",
            function()
                cexi.util.dialog(player, settings.dialog.EXPLAIN, settings.name, { npc = npc })
            end,
        },
    }

    local mainJob            = player:getMainJob()
    local varStatus          = player:getCharVar(settings.varJob)
    local remainingPoints    = player:getCharVar(settings.storedMeritsVar)
    local totalJobMeritValue = getJobMeritsSpent(player)

    if remainingPoints > 0 then
        table.insert(options, {
            string.format("Redeem %u leftover Merit Points", remainingPoints),
            function()
                local remainingPoints = player:getCharVar(settings.storedMeritsVar)
                player:setCharVar(settings.storedMeritsVar, 0)
                local refundedMerits = 0
                local storedMerits = 0
                refundedMerits, storedMerits = allocateRefundedMerits(player, remainingPoints)
                player:printToPlayer(string.format("%s gains %u merit points.", player:getName(), refundedMerits), xi.msg.channel.SYSTEM_3)
                if storedMerits > 0 then
                    player:printToPlayer(string.format("%s : You didn't have enough space to store all the merits, you now have %u banked!", settings.name, storedMerits), xi.msg.channel.NS_SAY)
                end
            end,
        })
    else
        if utils.mask.getBit(varStatus, mainJob) then
            table.insert(options, {
                "Huh!?",
                function()
                    cexi.util.dialog(player, settings.dialog.DONE, settings.name, { npc = npc })
                end,
            })
        elseif player:getMainLvl() < 75 then
            table.insert(options, {
                "Huh!?",
                function()
                    cexi.util.dialog(player, settings.dialog.LVL75, settings.name, { npc = npc })
                end,
            })
        elseif totalJobMeritValue == 0 then
            table.insert(options, {
                "Huh!?",
                function()
                    cexi.util.dialog(player, settings.dialog.NOMERITS, settings.name, { npc = npc })
                end,
            })
        else
            table.insert(options, {
                string.format("Reset %s Merit Points", xi.jobNames[player:getMainJob()][2]),
                resetJob,
            })
        end
    end

    npc:facePlayer(player, true)
    delaySendMenu(player, {
        title   = "Wha'dya want?",
        options = options,
    })
end

cexi.util.liveReload(m, {
    ["Lower_Jeuno"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = settings.name,
            look      = settings.look,
            x         = settings.pos[1],
            y         = settings.pos[2],
            z         = settings.pos[3],
            rotation  = settings.pos[4],
            widescan  = 1,
            onTrigger = onTrigger,
        }
    }
})

return m
