-----------------------------------
-- Hunter - Weekly NM Title Quest
-----------------------------------
-- Hunter !pos 8.000 0.000 15.427 245
-----------------------------------
require('modules/module_utils')
require('scripts/globals/npc_util')
require('scripts/globals/utils')
-----------------------------------
local m = Module:new('weekly_hunt')

local targets =
{
    { xi.title.BEHEMOTH_DETHRONER,    'King Behemoth'    },
    { xi.title.PENTACIDE_PERPETRATOR, 'Divine Might'     },
    { xi.title.ASPIDOCHELONE_SINKER,  'Aspidochelone'    },
    { xi.title.NIDHOGG_SLAYER,        'Nidhogg'          },
    { xi.title.KIRIN_CAPTIVATOR,      'Kirin'            },
    { xi.title.LIFTER_OF_SHADOWS,     'Dynamis Lord'     },
    { xi.title.TIAMAT_TROUNCER,       'Tiamat'           },
    { xi.title.VRTRA_VANQUISHER,      'Vrtra'            },
    { xi.title.WORLD_SERPENT_SLAYER,  'Jorumungand'      },
    { xi.title.VINEGAR_EVAPORATOR,    'King Vinegarroon' },
    { xi.title.TEMENOS_LIBERATOR,     'Proto-Ultima'     },
    { xi.title.APOLLYON_RAVAGER,      'Proto-Omega'      },
    { xi.title.CERBERUS_MUZZLER,      'Cerberus'         },
    { xi.title.HYDRA_HEADHUNTER,      'Hydra'            },
    { xi.title.KHIMAIRA_CARVER,       'Khimaira'         },
    { xi.title.OUPIRE_IMPALER,        'Oupire'           },
    { xi.title.BYAKKO_TAMER,          'Escha-Byakko'     },
    { xi.title.GENBU_CRACKER,         'Escaha-Genbu'     },
    { xi.title.SEIRYU_CLIPPER,        'Escha-Seiryu'     },
    { xi.title.SUZAKU_PLUCKER,        'Escha-Suzaku'     },
    { xi.title.KIRIN_DISMANTLER,      'Escha-Kirin'      },
    { xi.title.IXION_HORNBREAKER,     'Dark Ixion'       },
    { 1115,                           'Ruinous Randy'    },
}

local rewards =
{
    { 1456,  2 },  -- One Hundred Byne Bill
    { 1712,  2 },  -- Cashmere Thread
    { 1713,  2 },  -- Cashmere Wool
    {  658,  2 },  -- Damascus Ingot
    { 2470,  1 },  -- Nethereye Chain
    { 2471,  1 },  -- Netherfield Chain
    { 2472,  1 },  -- Netherspirit Chain
    { 2473,  1 },  -- Nethercant Chain
    { 2474,  1 },  -- Netherpact Chain
    {  901,  2 },  -- Venomous Claw
    { 2465,  1 },  -- Rubber Cap
    { 2466,  1 },  -- Rubber Harness
    { 2467,  1 },  -- Rubber Gloves
    { 2468,  1 },  -- Rubber Chausses
    { 2469,  1 },  -- Rubber Soles
    { 1875, 40 },  -- Ancient Beastcoin
    { 3283, 10 },  -- Aquarian Tatter
    { 3282, 10 },  -- Dryadic Tatter
    { 3281, 10 },  -- Earthen Tatter
    { 3280, 10 },  -- Martial Tatter
    { 3279, 10 },  -- Neptunal Tatter
    { 3284, 10 },  -- Wyrmal Tatter
    { 3286, 10 },  -- Hadean Tatter
    { 3285, 10 },  -- Phantasmal Tatter
    { 3278, 10 },  -- Byakko Scrap
    { 3275, 10 },  -- Genbu Scrap
    { 3277, 10 },  -- Seiryu Scrap
    { 3276, 10 },  -- Suzaku Scrap
    { 1450,  2 },  -- Lungo-Nango Jadeshell
    { 1453,  2 },  -- Montiont Silverpiece
    {  747,  2 },  -- Orichalcum Ingot
    {  686,  2 },  -- Imperial Wootz Ingot
    { 1714,  2 },  -- Cashmere Cloth
    { 1313,  2 },  -- Siren's Hair
    { 1409,  2 },  -- Siren's Macrame
    {  831,  2 },  -- Shining Cloth
    {  862,  2 },  -- Behemoth Leather
    { 2170,  2 },  -- Cerberus Leather
    { 1312,  2 },  -- Angel Skin
    {  723,  2 },  -- Divine Lumber
    {  720,  2 },  -- Ancient Lumber
    { 2535,  2 },  -- Jacaranda Lumber
    { 1446,  2 },  -- Lacquer Tree Log
    { 1133,  2 },  -- Dragon Blood
    { 4272,  2 },  -- Dragon Meat
    {  703,  2 },  -- Petrified Log
    { 2156, 10 },  -- Imperial Tea Leaves
    { 2532,  5 },  -- Teak Log
    {  732,  5 },  -- Kapor Log
    { 5736,  4 },  -- Linen Coin Purse
    { 1703,  3 },  -- Chunk of Kunwu Ore
    { 1769,  1 },  -- Square Of Galateia
    { 1764,  1 },  -- Square of Kejusu Satin
    { 1763,  1 },  -- Pot of Viridian Urushi
    { 1767,  1 },  -- Square of Eltoro Leather
    { 1841,  1 },  -- Unicorn Horn
    { 1771,  1 },  -- Dragon Bone
    { 1718,  1 },  -- Megalobugard Tusk
    { 1719,  1 },  -- Harajnite Shell
}

m:addOverride('xi.zones.Lower_Jeuno.Zone.onGameHour', function(zone)
    super(zone)

    local nextReset = GetServerVariable('[HUNTER]NextReset')

    if
        nextReset == 0 or -- If var doesn't exist yet
        os.time() > nextReset
    then
        local targetID = math.random(1, #targets)

        SetServerVariable('[HUNTER]WeeklyNM', targetID)
        SetServerVariable('[HUNTER]NextReset', NextConquestTally())

        print(string.format('[WEEKLY HUNTS]: A new hunt has been selected, %s (%i)', targets[targetID][2], targetID))
    end
end)

m:addOverride("xi.titleChanger.onEventFinish", function(player, csid, option, eventId, titleInfo)
    if csid ~= eventId then
        super(player, csid, option, eventId, titleInfo)
        return
    end

    local group = titleInfo[bit.rshift(option, 8) + 1]
    local title = group.title[option % 256]
    local weeklyTarget = GetServerVariable('[HUNTER]WeeklyNM')

    if title and title == targets[weeklyTarget][1] then
        -- block changing to current hunt's title
        player:printToPlayer(fmt("Hunter (from the distance) : You can't cheat the system bypassing the kill!"), xi.msg.channel.NS_SAY)
    else
        super(player, csid, option, eventId, titleInfo)
    end
end)

local function onTrigger(player, npc)
    local huntCounter = player:getCharVar('[HUNTER]SuccessfulHunts')
    local huntNext    = player:getCharVar('[HUNTER]HuntNext')
    local weeklyHunt  = GetServerVariable('[HUNTER]WeeklyNM') -- This tracks the Title ID required!

    -- Weekly hunt already completed
    if os.time() < huntNext then
        npc:facePlayer(player)
        player:printToPlayer(string.format('Hunter : You\'ve already completed this week\'s hunt! Come back later!'), xi.msg.channel.NS_SAY)

    -- Player collects a reward for completing the weekly objective
    elseif player:getTitle() == targets[weeklyHunt][1] then
        local reward = rewards[math.random(1, #rewards)]

        npc:facePlayer(player)
        player:printToPlayer(string.format('Hunter : Congratulations %s! You\'ve completed this week\'s hunt. Here\'s your reward!', player:getName()), xi.msg.channel.NS_SAY)

        if npcUtil.giveItem(player, { reward }) then
            player:setCharVar('[HUNTER]HuntNext', NextConquestTally())
            player:setCharVar('[HUNTER]SuccessfulHunts', huntCounter + 1)
        end

    -- Player hasnt completed hunt
    else
        npc:facePlayer(player)
        player:printToPlayer(string.format('Hunter : This week\'s hunt is: %s!', targets[weeklyHunt][2]), xi.msg.channel.NS_SAY)
    end
end

cexi.util.liveReload(m, {
    ['Lower_Jeuno'] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = 'Hunter',
            look      = '0x0000CA0800000000000000000000000000000000',
            x         = 8.000,
            y         = 0.000,
            z         = 15.427,
            rotation  = 130,
            widescan  = 1,
            onTrigger = onTrigger,
        },
    },
})

return m
