require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/quests")
require("modules/module_utils")
-----------------------------------

local m = Module:new("catseyexi_sch_af3_quest")

local statusVar = "[SCH]afstatus"

-----------------------------------
-- Area: Pashhow Marshlands [S]
-----------------------------------
m:addOverride("xi.zones.Pashhow_Marshlands_[S].Zone.onInitialize", function(zone)
    super(zone)

    local ID = require("scripts/zones/Pashhow_Marshlands_[S]/IDs")

    local sch_afhat = zone:insertDynamicEntity({ 
        objtype  = xi.objType.NPC,
        name     = "SCH AF hat",
        look     = 2331,
        x        = -454.225,
        y        = 25.000,
        z        = -362.404,
        rotation = 0,
        widescan = 1, 

    onTrade = function(player, npc, trade)
    end,

    onTrigger = function(player, npc)
        -- Step #2
        if
            player:getCharVar(statusVar) == 1
        then
            player:setCharVar(statusVar, 2)
            npcUtil.giveKeyItem(player, xi.ki.UNADDRESSED_SEALED_LETTER)
        else
            player:fmt("Nothing to see here.")
        end
    end,})
    
    utils.unused(sch_afhat)
end)

---------------------------------------------
--         THE ELDIEME NECROPOLIS S        --
---------------------------------------------
m:addOverride("xi.zones.The_Eldieme_Necropolis_[S].Zone.onInitialize", function(zone)
     --Call the zone's original function for onInitialize
    super(zone)

    local ID = require("scripts/zones/The_Eldieme_Necropolis_[S]/IDs")

    local sch_af3 = zone:insertDynamicEntity({ -- Sch af3 fix
        objtype  = xi.objType.NPC,
        name     = "SCH AF3",
        look     = 2331,
        x        = 377.124,
        y        = -40.000,
        z        = 19.466,
        rotation = 0,
        widescan = 1, 

        onTrade = function(player, npc, trade)
        end,

        onTrigger = function(player, npc)
            local schafquest = player:getCharVar(statusVar)

            -- Step #1
            if
                player:hasCompletedQuest(xi.questLog.CRYSTAL_WAR, xi.quest.id.crystalWar.DOWNWARD_HELIX) and
                (schafquest < 1 or schafquest == 3)
            then
                player:addQuest(xi.questLog.CRYSTAL_WAR, xi.quest.id.crystalWar.SEEING_BLOOD_RED)
                player:fmt("Bring me the key item Unaddressed Sealed Letter to receive the item you seek.")
                player:setCharVar(statusVar, 1)

            -- Step #2
            elseif
                schafquest == 1
            then
                player:fmt("Bring me an Unaddressed Sealed Letter.")

            -- Step #3
            elseif
                schafquest == 2 and
                npcUtil.giveItem(player, xi.item.SCHOLARS_MORTARBOARD)
            then
                player:delKeyItem(xi.ki.UNADDRESSED_SEALED_LETTER)
                player:setCharVar(statusVar, 3)
                player:completeQuest(xi.questLog.CRYSTAL_WAR, xi.quest.id.crystalWar.SEEING_BLOOD_RED)
            end
        end,
    })

    utils.unused(sch_af3)
end)

return m
