-----------------------------------
-- Livia - Stores the rings for Chains of Promathia missions.
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_cop_rings")

local ringItems =
{
    { id = xi.item.RAJAS_RING, name = "Rajas Ring", var = '[RINGS]storedRajas' },
    { id = xi.item.SAATVA_RING, name = "Sattva Ring", var = '[RINGS]storedSattva' },
    { id = xi.item.TAMAS_RING, name = "Tamas Ring", var = '[RINGS]storedTamas' },
}

local function checkRings(player)
    local ringsPossessed = {}
    local hasAllRings = true

    for _, ring in ipairs(ringItems) do
        if player:hasItem(ring.id) then
            table.insert(ringsPossessed, ring.name)
        else
            hasAllRings = false
        end
    end

    return ringsPossessed, hasAllRings
end

local function resetCanTrade(player)
    local storedRajas = player:getCharVar('[RINGS]storedRajas')
    local storedSattva = player:getCharVar('[RINGS]storedSattva')
    local storedTamas = player:getCharVar('[RINGS]storedTamas')

    if storedRajas == 0 and storedSattva == 0 and storedTamas == 0 then
        player:setCharVar('[RINGS]canTrade', 0)
        player:setCharVar('pendingReplacement', 0)  -- fallback tracking var
    end
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            objtype = xi.objType.NPC,
            name = "Livia",
            look = cexi.util.look({
                race = xi.race.HUME_F,
                face = cexi.face.A1,
                head = 0,
                body = cexi.model.IRON_MUSKETEERS,
                hand = cexi.model.IRON_MUSKETEERS,
                legs = cexi.model.IRON_MUSKETEERS,
                feet = cexi.model.IRON_MUSKETEERS,
            }),
            x        = -96.722,
            y        = -0.199,
            z        = 93.439,
            rotation = 225,
            widescan = 1,

            onTrigger = function(player, npc)
                npc:facePlayer(player, true)
                local firstRing = player:getCharVar('Mission[6][840]firstRing')
                local canTradeOne = player:getCharVar('[RINGS]canTrade')
                local ringsPossessed, hasAllRings = checkRings(player)
                local ringNames = table.concat(ringsPossessed, ", ")
                local storedRajas = player:getCharVar('[RINGS]storedRajas')
                local storedSattva = player:getCharVar('[RINGS]storedSattva')
                local storedTamas = player:getCharVar('[RINGS]storedTamas')

                if storedRajas == 1 or storedSattva == 1 or storedTamas == 1 then
                    local menu  = {}
                    local page1 = {}

                    local delaySendMenu = function(player)
                        player:timer(100, function(playerArg)
                            playerArg:customMenu(menu)
                        end)
                    end
                    menu =
                    {
                        title = "Choose a ring to be returned.",
                        options = {},
                    }
                    if storedRajas == 1 then
                        table.insert(menu.options, {
                            "Rajas Ring",
                            function(playerArg)
                                if not player:hasItem(xi.item.RAJAS_RING) then
                                    playerArg:timer(50, function(playerArg)
                                        playerArg:printToPlayer("Returning Rajas Ring...", 0, npc:getPacketName())
                                        npcUtil.giveItem(playerArg, xi.item.RAJAS_RING)
                                        playerArg:setCharVar('[RINGS]storedRajas', 0)
                                        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)
                                        resetCanTrade(playerArg)
                                    end)
                                else
                                    playerArg:printToPlayer("You already possess a Rajas Ring.", 0, npc:getPacketName())
                                end
                            end,
                        })
                    end
                    if storedSattva == 1 then
                        table.insert(menu.options, {
                            "Sattva Ring",
                            function(playerArg)
                                if not player:hasItem(xi.item.SAATVA_RING) then
                                    playerArg:timer(50, function(playerArg)
                                        playerArg:printToPlayer("Returning Sattva Ring...", 0, npc:getPacketName())
                                        npcUtil.giveItem(playerArg, xi.item.SAATVA_RING)
                                        playerArg:setCharVar('[RINGS]storedSattva', 0)
                                        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)
                                        resetCanTrade(playerArg)
                                    end)
                                else
                                    playerArg:printToPlayer("You already possess a Sattva Ring.", 0, npc:getPacketName())
                                end
                            end,
                        })
                    end
                    if storedTamas == 1 then
                        table.insert(menu.options, {
                            "Tamas Ring",
                            function(playerArg)
                                if not player:hasItem(xi.item.TAMAS_RING) then
                                    playerArg:timer(50, function(playerArg)
                                        playerArg:printToPlayer("Returning Tamas Ring...", 0, npc:getPacketName())
                                        npcUtil.giveItem(playerArg, xi.item.TAMAS_RING)
                                        playerArg:setCharVar('[RINGS]storedTamas', 0)
                                        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)
                                        resetCanTrade(playerArg)
                                    end)
                                else
                                    playerArg:printToPlayer("You already possess a Tamas Ring.", 0, npc:getPacketName())
                                end
                            end,
                        })
                    end
                    table.insert(menu.options, {
                        "Exit",
                        function(playerArg)
                            return
                        end,
                    })

                    delaySendMenu(player)
                    return
                end

                if canTradeOne == 1 then
                    player:printToPlayer(string.format("Livia : Remember what I asked of you? Trade me your ring(s): %s for safekeeping.", ringNames), xi.msg.channel.NS_SAY)
                    return
                end

                if firstRing == 1 then
                    if hasAllRings then
                        player:printToPlayer(string.format("Livia : You possess all the reward rings: %s. You don't need my services.", ringNames), xi.msg.channel.NS_SAY)
                    elseif #ringsPossessed > 0 then
                        player:printToPlayer(string.format("Livia : You already possess the following reward ring(s): %s. Please trade them to me for safekeeping.", ringNames), xi.msg.channel.NS_SAY)
                        player:printToPlayer("Livia : Then, check the Marble Bridge door. After completing that, return to me to retrieve your rings.", xi.msg.channel.NS_SAY)
                        player:setCharVar('[RINGS]canTrade', 1)
                    else
                        player:printToPlayer("Livia : Welcome, adventurer! What brings you to the Ducal Guard?", xi.msg.channel.NS_SAY)
                    end
                else
                    player:printToPlayer("Livia : Welcome, adventurer! What brings you to the Ducal Guard?", xi.msg.channel.NS_SAY)
                end
            end,
            onTrade = function(player, npc, trade)
                local canTradeOne = player:getCharVar('[RINGS]canTrade')
                if canTradeOne == 1 then
                    local tradedRing = nil
                    for _, ring in ipairs(ringItems) do
                        if trade:hasItemQty(ring.id, 1) then
                            if tradedRing then
                                player:printToPlayer("Livia : Please trade only one ring at a time.", xi.msg.channel.NS_SAY)
                                return
                            else
                                tradedRing = ring
                            end
                        end
                    end
                    if tradedRing and trade:getItemCount() == 1 then
                        player:tradeComplete()
                        player:setCharVar(tradedRing.var, 1)
                        -- remove the timer var, we are holding the item. timer var for replacement is not valid
                        player:setCharVar('Mission[6][840]Timer', 0)
                        -- update the dropped var to 0 - don't track traded rings
                        if tradedRing.id == xi.item.RAJAS_RING then
                            player:setCharVar('[RINGS]droppedRajas', 0)
                        elseif tradedRing.id == xi.item.SAATVA_RING then
                            player:setCharVar('[RINGS]droppedSattva', 0)
                        elseif tradedRing.id == xi.item.TAMAS_RING then
                            player:setCharVar('[RINGS]droppedTamas', 0)
                        end
                        player:printToPlayer(string.format("Livia : Thank you for entrusting me with your %s. I will keep it safe until you return.", tradedRing.name), xi.msg.channel.NS_SAY)
                        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)
                    else
                        player:printToPlayer("Livia : This is not correct. Remember what I asked of you.", xi.msg.channel.NS_SAY)
                    end
                else
                    player:printToPlayer("Livia : I don't have any record of you, adventurer.", xi.msg.channel.NS_SAY)
                end
            end,
        }
    }
})

return m
