-----------------------------------
-- Geppetto - Converts broken automaton attachments
-----------------------------------
-- !pos 28.693 -6.000 98.037 50
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------

local m = Module:new("npc_geppetto")

local attachments =
{
    [8452] = 2241, -- tension_spring_ii
    [8454] = 2347, -- reactive_shield
    [8644] = 2265, -- auto-repair_kit_ii
    [8457] = 9032, -- strobe_ii
    [8458] = 9033, -- tension_spring_iii
    [8459] = 9065, -- inhibitor_ii
    [8463] = 9230, -- speedloader_ii
    [8465] = 9885, -- magniplug
    [8486] = 2348, -- tranquilizer
    [8489] = 9034, -- loudspeaker_iii
    [8490] = 9035, -- tranquilizer_ii
    [8491] = 9066, -- amplifier
    [8518] = 2349, -- turbo_charger
    [8522] = 9037, -- accelerator_iii
    [8523] = 9036, -- scope_ii
    [8524] = 9067, -- repeater
    [8545] = 2250, -- shock_absorber
    [8552] = 3310, -- barrier_module_ii
    [8553] = 9038, -- shock_absorber_ii
    [8554] = 9039, -- armor_plate_iii
    [8555] = 9068, -- barrier_module
    [8585] = 9040, -- stabilizer_iii
    [8586] = 9041, -- coiler_ii
    [8587] = 9069, -- dynamo_ii
    [8614] = 2352, -- condenser
    [8617] = 9042, -- mana_jammer_iii
    [8618] = 9043, -- stealth_screen_ii
    [8619] = 9070, -- resister
    [8620] = 9071, -- resister_ii
    [8648] = 3313, -- vivi-valve
    [8650] = 9044, -- auto-repair_kit_iii
    [8651] = 9072, -- arcanic_cell
    [8652] = 9073, -- arcanic_cell_ii
    [8676] = 2269, -- mana_tank_ii
    [8678] = 2354, -- economizer
    [8681] = 9045, -- mana_tank_iii
    [8682] = 9074, -- regulator
    [8646] = 2353, -- optic_fiber
}

cexi.util.liveReload(m, {
    ["Aht_Urhgan_Whitegate"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = "Geppetto",
            look   = cexi.util.look({
                race = xi.race.ELVAAN_M,
                face = cexi.face.A8,
                head = 0,
                body = cexi.model.TRADERS_SAIO_BLACK,
                hand = cexi.model.PUPPETMASTER_ARTIFACT,
                legs = cexi.model.PUPPETMASTER_ARTIFACT,
                feet = cexi.model.PUPPETMASTER_ARTIFACT,
            }),
            x        = 31.983,
            y        = -6.000,
            z        = 98.037,
            rotation = 107,
            widescan = 1,

            onTrigger = function(player, npc)
                npc:facePlayer(player, true)
                player:printToPlayer("Have any automaton attachments that don't fit your model? Exchange them here.", xi.msg.channel.NS_SAY)
            end,

            onTrade = function(player, npc, trade)
                for badAttachment, goodAttachment in pairs(attachments) do
                    if npcUtil.tradeHasExactly(trade, badAttachment) then
                        player:printToPlayer("Geppetto : Here you are. Hopefully this one is a better fit!", xi.msg.channel.NS_SAY)
                        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)

                        if npcUtil.giveItem(player, goodAttachment) then
                            player:tradeComplete()
                        end

                        return
                    end
                end
            end,
        }
    }
})

return m
