-----------------------------------
-- Uleguerand Range Frozen Pillar
-- !pos 1.580 -176.884 66.547 5
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("npc-frozen-pillar")

local function onTrigger(player, npc)
    local ID     = zones[xi.zone.ULEGUERAND_RANGE]
    local pillar = GetNPCByID(ID.npc.WATERFALL)

    if pillar:getAnimation() == xi.anim.CLOSE_DOOR then
        player:printToPlayer("You may be able to melt the ice with a fire cluster.", xi.msg.channel.NS_SAY)
    end
end

local function onTrade(player, npc, trade)
    if npcUtil.tradeHasExactly(trade, xi.item.FIRE_CLUSTER) then
        local ID     = zones[xi.zone.ULEGUERAND_RANGE]
        local pillar = GetNPCByID(ID.npc.WATERFALL)

        if pillar:getAnimation() == xi.anim.OPEN_DOOR then
            return
        end

        pillar:setAnimation(xi.anim.OPEN_DOOR)
        player:tradeComplete()

        npc:timer(60000, function(npcArg)
            local zone    = npcArg:getZone()
            local weather = zone:getWeather()

             if weather == xi.weather.SNOW or weather == xi.weather.BLIZZARDS then
                if pillar:getAnimation() ~= xi.anim.CLOSE_DOOR then
                    pillar:setAnimation(xi.anim.CLOSE_DOOR)
                end
            end
        end)
    end
end

cexi.util.liveReload(m, {
    ["Uleguerand_Range"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Frozen Pillar",
            x         = 4.742,
            y         = -180.108,
            z         = 68.510,
            rotation  = 47,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
})

return m
