-----------------------------------
-- Assault Promotion
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------

local m = Module:new("assault_promotion")

local itemName =
{
    [xi.item.IMPERIAL_BRONZE_PIECE]  = "Imp. Brz. Piece",
    [xi.item.IMPERIAL_SILVER_PIECE]  = "Imp. Slv. Piece",
    [xi.item.IMPERIAL_MYTHRIL_PIECE] = "Imp. Mtl. Piece",
    [xi.item.IMPERIAL_GOLD_PIECE]    = "Imp. Gold Piece",
}

local badgeName =
{
    [xi.ki.PSC_WILDCAT_BADGE]     = "Private Second Class",
    [xi.ki.PFC_WILDCAT_BADGE]     = "Private First Class",
    [xi.ki.SP_WILDCAT_BADGE]      = "Superior Private",
    [xi.ki.LC_WILDCAT_BADGE]      = "Lance Corporal",
    [xi.ki.C_WILDCAT_BADGE]       = "Corporal",
    [xi.ki.S_WILDCAT_BADGE]       = "Sergeant",
    [xi.ki.SM_WILDCAT_BADGE]      = "Sergeant Major",
    [xi.ki.CS_WILDCAT_BADGE]      = "Chief Sergeant",
    [xi.ki.SL_WILDCAT_BADGE]      = "Second Lieutenant",
    [xi.ki.FL_WILDCAT_BADGE]      = "First Lieutenant",
    [xi.ki.CAPTAIN_WILDCAT_BADGE] = "Captain",
}

local badgeTable =
{
    { xi.ki.PFC_WILDCAT_BADGE,     xi.mission.id.toau.ASTRAL_WAVES,         { { xi.item.IMPERIAL_BRONZE_PIECE,  10 } } },
    { xi.ki.SP_WILDCAT_BADGE,      xi.mission.id.toau.THE_BLACK_COFFIN,     { { xi.item.IMPERIAL_BRONZE_PIECE,  20 } } },
    { xi.ki.LC_WILDCAT_BADGE,      xi.mission.id.toau.TEAHOUSE_TUMULT,      { { xi.item.IMPERIAL_BRONZE_PIECE,  30 } } },
    { xi.ki.C_WILDCAT_BADGE,       xi.mission.id.toau.FOILED_AMBITION,      { { xi.item.IMPERIAL_SILVER_PIECE,  10 } } },
    { xi.ki.S_WILDCAT_BADGE,       xi.mission.id.toau.BASTION_OF_KNOWLEDGE, { { xi.item.IMPERIAL_SILVER_PIECE,  20 } } },
    { xi.ki.SM_WILDCAT_BADGE,      xi.mission.id.toau.IN_THE_BLOOD,         { { xi.item.IMPERIAL_SILVER_PIECE,  30 } } },
    { xi.ki.CS_WILDCAT_BADGE,      xi.mission.id.toau.GAZE_OF_THE_SABOTEUR, { { xi.item.IMPERIAL_MYTHRIL_PIECE, 10 } } },
    { xi.ki.SL_WILDCAT_BADGE,      xi.mission.id.toau.UNRAVELING_REASON,    { { xi.item.IMPERIAL_MYTHRIL_PIECE, 20 } } },
    { xi.ki.FL_WILDCAT_BADGE,      xi.mission.id.toau.NASHMEIRAS_PLEA,      { { xi.item.IMPERIAL_MYTHRIL_PIECE, 30 } } },
    { xi.ki.CAPTAIN_WILDCAT_BADGE, xi.mission.id.toau.THE_EMPRESS_CROWNED,  { { xi.item.IMPERIAL_GOLD_PIECE,    30 } } },
}

local function onTrigger(player, npc)
    local highestRank = xi.ki.PSC_WILDCAT_BADGE

    for _, badgeInfo in pairs(badgeTable) do
        local badgeID   = badgeInfo[1]
        local missionID = badgeInfo[2]
        local tradeInfo = badgeInfo[3]

        if player:hasKeyItem(badgeInfo[1]) then
            highestRank = badgeInfo[1]
        elseif
            player:hasCompletedMission(xi.mission.log_id.TOAU, missionID)
        then
            npc:facePlayer(player, true)
            player:printToPlayer(string.format("%s : You've done well, %s. In recognition of your progress, the empire is offering you a promotion.", npc:getPacketName(), player:getName()), xi.msg.channel.NS_SAY)
            player:printToPlayer(string.format(" When you're ready, trade me %s x%u and I will bestow upon you the title of %s.", itemName[tradeInfo[1][1]], tradeInfo[1][2], badgeName[badgeID]), xi.msg.channel.NS_SAY, npc:getPacketName())
            npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)

            return
        end
    end

    if player:hasKeyItem(xi.ki.PSC_WILDCAT_BADGE) then
        npc:ceEmote(player, xi.emote.NO, xi.emoteMode.MOTION)
        player:printToPlayer(string.format("%s : Attention, %s %s.", npc:getPacketName(), badgeName[highestRank], player:getName()), xi.msg.channel.NS_SAY)
        player:printToPlayer(" While the empire appreciates your efforts, you are not yet ready for a promotion.", xi.msg.channel.NS_SAY)
    else
        npc:facePlayer(player, true)
        player:printToPlayer(string.format("%s : I don't have any record of you, adventurer.", npc:getPacketName()), xi.msg.channel.NS_SAY)
    end
end

local function onTrade(player, npc, trade)
    for _, badgeInfo in pairs(badgeTable) do
        local badgeID   = badgeInfo[1]
        local missionID = badgeInfo[2]

        if
            player:hasCompletedMission(xi.mission.log_id.TOAU, missionID) and
            not player:hasKeyItem(badgeInfo[1])
        then
            if npcUtil.tradeHasExactly(trade, badgeInfo[3]) then
                player:tradeComplete()
                npc:facePlayer(player, true)
                player:printToPlayer(string.format("%s : Congratulations! You have advanced to the rank of %s!", npc:getPacketName(), badgeName[badgeID]), xi.msg.channel.NS_SAY, npc:getPacketName())
                npc:ceEmote(player, xi.emote.CLAP, xi.emoteMode.MOTION)
                npcUtil.giveKeyItem(player, badgeID)
            end

            return
        end
    end
end

cexi.util.liveReload(m, {
    ["Aht_Urhgan_Whitegate"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Wildcat Captain",
            look = cexi.util.look({
                race = xi.race.HUME_M,
                face = cexi.face.A2,
                head = cexi.model.ASKAR_KORAZIN,
                body = cexi.model.HOMAM_CORAZZA,
                hand = cexi.model.AMIR_KORAZIN,
                legs = cexi.model.ASKAR_KORAZIN,
                feet = cexi.model.AMIR_KORAZIN,
                main = 73,
            }),
            x         = 107.877,
            y         = -0.315,
            z         = -26.923,
            rotation  = 28,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        }
    }
})

return m
