-----------------------------------
-- Lost Trail
-- Used to produce Ergon Weapons (Idris/Epeolatry)
-- !pos -125.925 -24.000 679.995 25
-----------------------------------
require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("ergon_weapons")

local settings =
{
    buildIdris     = "[ERGON]IDRIS",
    buildEpeolatry = "[ERGON]EPEOLATRY",
    buildWait      = "[ERGON]DELAY",
}

local function wildernixDialog(tbl)
    return cq.npcSpawner(tbl, "Wildernix", "Lost Trail")
end

local idrisDialog =
{
    { despawn = { "Lost Trail" } },
    "Wildernix doesn't appear to be around but you see your completed Idris on the ground with note",
    "\"Gone fishin\"",
    { delay = 1000 },
    " But wait... what's this? Idris has come to life!...",
    { spawn = { "Elena" } },
    { delay = 2000 },
    "??? : Congratulations adventurer, you have overcome many challenges and insurmountable odds.",
    { entity = "Elena", emote = xi.emote.YES },
    { delay = 2000 },
    " Now that Idris has returned to a worthy owner, I may finally rest in peace.",
    { delay  = 1000 },
    { entity = "Elena", packet = "ls11" },
    "Elena : The cycle of elements continues unbound... form to formless, nature begins anew.",
    { delay   = 3000 },
    { despawn = { "Elena" } },
    { spawn   = { "Lost Trail" } },
}

local epeolatryDialog =
{
    { despawn = { "Lost Trail" } },
    "Wildernix doesn't appear to be around but you see your completed Epeolatry on the ground with note.",
    "\"Gone huntin\"",
    { delay = 1000 },
    " But wait... what's this? Epeolatry has come to life!...",
    { spawn = { "Lionel" } },
    { delay = 2000 },
    "??? : I applaud you, adventurer. Through your strength and determination you have accomplished the incredible.",
    { entity = "Lionel", emote = xi.emote.YES },
    { delay = 2000 },
    " Now that Epeolatry has returned to a worthy owner, I may finally rest in peace.",
    { delay  = 1000 },
    { entity = "Lionel", emote = xi.emote.BOW },
    "Lionel : Runes beget mysteries of ancient tongues... through the living, ancestors are reborn.",
    { delay   = 3000 },
    { despawn = { "Lionel" } },
    { spawn   = { "Lost Trail" } },
}

local function onTrigger(player, npc)
    if player:getCharVar(settings.buildWait) > 0 then
        cexi.util.dialog(player, wildernixDialog({
            "Wildernix : This is going to take a bit, so come back tomorrow will ya?",
        }))

        return
    end

    if player:getCharVar(settings.buildIdris) > 0 then
        local delay = cexi.util.dialogDelay(idrisDialog)
        cexi.util.dialog(player, idrisDialog)

        player:timer(delay, function()
            if npcUtil.giveItem(player, xi.item.IDRIS_75) then
                player:setCharVar(settings.buildIdris, 0)
                cexi.wf(target, "[ERGON]IDRIS", fmt("{} is the first player to obtain Idris!", player:getName()))

                if player:isCrystalWarrior() then
                    cexi.wf(target, "[CW]IDRIS", fmt("{} is the first Crystal Warrior to obtain Idris!", player:getName()))
                end
            end
        end)

        return
    end

    if player:getCharVar(settings.buildEpeolatry) > 0 then
        local delay = cexi.util.dialogDelay(epeolatryDialog)
        cexi.util.dialog(player, epeolatryDialog)

        player:timer(delay, function()
            if npcUtil.giveItem(player, xi.item.EPEOLATRY_75) then
                player:setCharVar(settings.buildEpeolatry, 0)
                cexi.wf(target, "[ERGON]EPEOLATRY", fmt("{} is the first player to obtain Epeolatry!", player:getName()))

                if player:isCrystalWarrior() then
                    cexi.wf(target, "[CW]EPEOLATRY", fmt("{} is the first Crystal Warrior to obtain Epeolatry!", player:getName()))
                end
            end
        end)

        return
    end

    if
        player:hasItem(xi.item.BROKEN_WAND) or
        player:hasItem(xi.item.BROKEN_SWORD)
    then
        player:fmt("You sense a nearby presence.")
    else
        player:fmt("You see nothing out of the ordinary.")
    end
end

local function introDialog(itemName)
    return wildernixDialog({
        "Wildernix : Huh... that's... Well you've come to the right place buddy!",
        " I possess a very rare talent for repairing these sort of things.",
        { delay = 1000 },
        "Wildernix : Naturally, it's going to come at a pretty hefty price, given this is such specialist work.",
        { delay = 1000 },
        " Let's see here... Ahem.",
        "Wildernix : One Pristine Yggrete Crystal, an Amphisbaena Hide, a Battosai Fang and a Tortuga Shell.",
        fmt(" Don't forget to bring back the {} and my payment of one Bayld Crystal.", itemName),
        { delay = 1000 },
        "Wildernix : Supplies for this kind of repair don't come cheap ya know... I have to import it right from Adoulin!",
        " Bring back everything I asked for and I'll get to work.",
    })
end

local buildDialog = wildernixDialog({
    "Wildernix : Woah! You actually came through with it. You've brought everything I need.",
    " This is going to take a bit, so come back tomorrow will ya?",
})

local function onTrade(player, npc, trade)
    if cexi.util.tradeHasExactly(trade, xi.item.BROKEN_WAND) then
        cexi.util.dialog(player, introDialog("Broken Wand"), "Wildernix")
        return
    end

    if cexi.util.tradeHasExactly(trade, xi.item.BROKEN_SWORD) then
        cexi.util.dialog(player, introDialog("Broken Sword"), "Wildernix")
        return
    end

    if cexi.util.tradeHasExactly(trade, {
        xi.item.BROKEN_WAND,
        xi.item.P_YGGRETE_CRYSTAL,
        xi.item.BAYLD_CRYSTAL,
        xi.item.AMPHISBAENA_HIDE,
        xi.item.BATTOSAI_FANG,
        xi.item.TORTUGA_SHELL,
    }) then
        player:tradeComplete()
        player:setCharVar(settings.buildIdris, 1)
        player:setCharVar(settings.buildWait, 1, JstMidnight())

        cexi.util.dialog(player, buildDialog)

        return
    end

    if cexi.util.tradeHasExactly(trade, {
        xi.item.BROKEN_SWORD,
        xi.item.P_YGGRETE_CRYSTAL,
        xi.item.BAYLD_CRYSTAL,
        xi.item.AMPHISBAENA_HIDE,
        xi.item.BATTOSAI_FANG,
        xi.item.TORTUGA_SHELL,
    }) then
        player:tradeComplete()
        player:setCharVar(settings.buildEpeolatry, 1)
        player:setCharVar(settings.buildWait, 1, JstMidnight())

        cexi.util.dialog(player, buildDialog)

        return
    end
end

cexi.util.liveReload(m, {
    ["Misareaux_Coast"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Lost Trail",
            x         = -129.397,
            y         = -23.834,
            z         = 678.458,
            rotation  = 114,
            widescan  = 1,
            look      = 52, -- Blank
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
        {
            name      = "Wildernix",
            x         = -129.397,
            y         = -23.834,
            z         = 678.458,
            rotation  = 0,
            look      = 85,
            hidden    = true,
        },
        {
            name      = "Elena",
            x         = -133.898,
            y         = -23.466,
            z         = 673.570,
            rotation  = 224,
            look      = "0x0100010236113621BA30BA40BA5042636E700080",
            namevis   = 0x80,  -- Ghost
            hidden    = true,
        },
        {
            name      = "Lionel",
            x         = -135.873,
            y         = -23.704,
            z         = 676.916,
            rotation  = 246,
            look      = "0x0100010373115221733173417351416300700080",
            namevis   = 0x80,  -- Ghost
            hidden    = true,
        },
    },
})

return m
