-----------------------------------
-- Crystal Warrior Nyzul Tokens NPC
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_cw_tokens")

local settings =
{
    name = "Wildcat Armorer",
}

local items =
{
    {
        "Leujaoam Sanctum",
        {
            { "Stoic Earring",   xi.item.STOIC_EARRING,                   3000 },
            { "Unfettered Ring", xi.item.UNFETTERED_RING,                 5000 },
            { "Tempered Chain",  xi.item.TEMPERED_CHAIN,                  8000 },
            { "Potent Belt",     xi.item.POTENT_BELT,                    10000 },
            { "Miraculous Cape", xi.item.MIRACULOUS_CAPE,                10000 },
            { "Yigit Bulawa",    xi.item.YIGIT_BULAWA,                   10000 },
            { "Imperial Bhuj",   xi.item.IMPERIAL_BHUJ,                  15000 },
            { "Pahluwan Patas",  xi.item.PAHLUWAN_PATAS,                 15000 },
            { "Amir Kolluks",    xi.item.AMIR_KOLLUKS,                   15000 },
            { "Pln. Qalansuwa",  xi.item.PAHLUWAN_QALANSUWA,             20000 },
            { "Yigit Seraweels", xi.item.YIGIT_SERAWEELS,                20000 },
        },
    },
    {
        "Mamool Ja Grounds",
        {
            { "Antivenom Earring", xi.item.ANTIVENOM_EARRING,             3000 },
            { "Ebullient Ring",    xi.item.EBULLIENT_RING,                5000 },
            { "Enlightened Chain", xi.item.ENLIGHTENED_CHAIN,             8000 },
            { "Spectral Belt",     xi.item.SPECTRAL_BELT,                10000 },
            { "Bullseye Cape",     xi.item.BULLSEYE_CAPE,                10000 },
            { "Storm Tulwar",      xi.item.STORM_TULWAR,                 15000 },
            { "Imperial Neza",     xi.item.IMPERIAL_NEZA,                15000 },
            { "Storm Tabar",       xi.item.STORM_TABAR,                  15000 },
            { "Yigit Gages",       xi.item.YIGIT_GAGES,                  20000 },
            { "Amir Boots",        xi.item.AMIR_BOOTS,                   20000 },
            { "Pln. Seraweels",    xi.item.PAHLUWAN_SERAWEELS,           20000 },
        },
    },
    {
        "Lebros Cavern",
        {
            { "Insomnia Earring",  xi.item.INSOMNIA_EARRING,              3000 },
            { "Hale Earring",      xi.item.HALE_RING,                     5000 },
            { "Chiv. Chain",       xi.item.CHIVALROUS_CHAIN,              8000 },
            { "Precise Cape",      xi.item.PRECISE_BELT,                 10000 },
            { "Intensifying Cape", xi.item.INTENSIFYING_CAPE,            10000 },
            { "Imperial Pole",     xi.item.IMPERIAL_POLE,                15000 },
            { "Doombringer",       xi.item.DOOMBRINGER,                  15000 },
            { "Sayosamonji",       xi.item.SAYOSAMONJI,                  15000 },
            { "Pln. Dastanas",     xi.item.PAHLUWAN_DASTANAS,            20000 },
            { "Yigit Crackows",    xi.item.YIGIT_CRACKOWS,               20000 },
            { "Amir Korazin",      xi.item.AMIR_KORAZIN,                 20000 },
        },
    },
    {
        "Periqia",
        {
            { "Vision Earring",   xi.item.VISION_EARRING,                 3000 },
            { "Unyielding Chain", xi.item.UNYIELDING_RING,                5000 },
            { "Fortified Chain",  xi.item.FORTIFIED_CHAIN,                8000 },
            { "Resolute Belt",    xi.item.RESOLUTE_BELT,                 10000 },
            { "Bushido Cape",     xi.item.BUSHIDO_CAPE,                  10000 },
            { "Khanjar",          xi.item.KHANJAR,                       15000 },
            { "Hotarumaru",       xi.item.HOTARUMARU,                    15000 },
            { "Imperial Gun",     xi.item.IMPERIAL_GUN,                  15000 },
            { "Amir Puggaree",    xi.item.AMIR_PUGGAREE,                 20000 },
            { "Pln. Crackows",    xi.item.PAHLUWAN_CRACKOWS,             20000 },
            { "Yigit Gomlek",     xi.item.YIGIT_GOMLEK,                  20000 },
        },
    },
    {
        "Ilrusi Atoll",
        {
            { "Velocity Earring",  xi.item.VELOCITY_EARRING,              3000 },
            { "Garrulous Ring",    xi.item.GARRULOUS_RING,                5000 },
            { "Grandiose Chain",   xi.item.GRANDIOSE_CHAIN,               8000 },
            { "Hurling Belt",      xi.item.HURLING_BELT,                 10000 },
            { "Invigorating Cape", xi.item.INVIGORATING_CAPE,            10000 },
            { "Imperial Kaman",    xi.item.IMPERIAL_KAMAN,               15000 },
            { "Storm Zaghnal",     xi.item.STORM_ZAGHNAL,                15000 },
            { "Storm Fife",        xi.item.STORM_FIFE,                   15000 },
            { "Yigit Turban",      xi.item.YIGIT_TURBAN,                 20000 },
            { "Amir Dirs",         xi.item.AMIR_DIRS,                    20000 },
            { "Pln. Khazagand",    xi.item.PAHLUWAN_KHAZAGAND,           20000 },
        },
    },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function purchaseItem(player, npc, item)
    npc:facePlayer(player, true)

    delaySendMenu(player, {
        title   = string.format("Buy %s for %u Tokens?", item[1], item[3] ),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    local balance = player:getCurrency("nyzul_isle_assault_point")
                    npc:facePlayer(player, true)

                    if item[3] > balance then
                        player:fmt("{} : You don't have enough Nyzul Tokens to purchase that.", settings.name)

                        player:timer(500, function()
                            npc:ceEmote(player, xi.emote.NO, xi.emoteMode.MOTION)
                        end)

                        return
                    end

                    if npcUtil.giveItem(player, item[2]) then
                        player:fmt("{} : I've deducted {} Nyzul Tokens from your records. May this {} serve thee well.", settings.name, item[3], item[1])
                        player:delCurrency("nyzul_isle_assault_point", item[3])

                        player:timer(500, function()
                            npc:ceEmote(player, xi.emote.YES, xi.emoteMode.MOTION)
                        end)
                    else
                        player:timer(500, function()
                            npc:ceEmote(player, xi.emote.NO, xi.emoteMode.MOTION)
                        end)
                    end
                end,
            },
        },
    })
end

local function onTrigger(player, npc)
    npc:facePlayer(player, true)

    if not player:isCrystalWarrior() then
        npc:ceEmote(player, xi.emote.NO, xi.emoteMode.MOTION)
        player:fmt("{} : I can't help you, adventurer.", settings.name)

        return
    end

    local balance = player:getCurrency("nyzul_isle_assault_point")

    player:timer(1000, function()
        npc:ceEmote(player, xi.emote.SALUTE, xi.emoteMode.MOTION)
    end)

    cexi.util.categoryMenu(player, npc, items, purchaseItem, string.format("Spend Nyzul Tokens (%u):", balance))
end

cexi.util.liveReload(m, {
    ["Aht_Urhgan_Whitegate"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = settings.name,
            look = cexi.util.look({
                race = xi.race.HUME_F,
                face = cexi.face.B3,
                head = 0,
                body = cexi.model.AMIR_KORAZIN,
                hand = cexi.model.AMIR_KORAZIN,
                legs = cexi.model.AMIR_KORAZIN,
                feet = cexi.model.AMIR_KORAZIN,
                main = 73,
            }),
            x         = 115.530,
            y         = -0.315,
            z         = -27.166,
            rotation  = 96,
            onTrigger = onTrigger,
        }
    }
})

return m
