-----------------------------------
-- Crystal Warrior Smithnix
-- Involved in forging CW Ultimate Weapons
-----------------------------------
-- !pos -34.582 12.000 111.987 11
-----------------------------------
require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("npc_cw_smithnix")
local info =
{
    progVar  = "[CW]SMITHNIX",
    pendVar  = "[CW]SMITHNIX_PENDING",
    lockVar  = "[CW]SMITHNIX_ORDER",
    delayVar = "[CW]SMITHNIX_WAIT",
    required = { { 4539, 5 } },
    quantity = 300,
}

local coins =
{
    [xi.item.ORCISH_STEEL]  = "orcish steel",
    [xi.item.QUADAV_BRASS]  = "quadav brass",
    [xi.item.YAGUDO_SILVER] = "yagudo silver",
}

local chains =

{
    [xi.item.ORCISH_STEEL]  = { desc = "orcish chains", item = xi.item.ORCISH_CHAIN  },
    [xi.item.QUADAV_BRASS]  = { desc = "quadav chains", item = xi.item.QUADAV_CHAIN  },
    [xi.item.YAGUDO_SILVER] = { desc = "yagudo chains", item = xi.item.YAGUDO_SILVER },
}

local cost =
{
    300,
    500,
}

local costTrade = {}

for itemID, _ in pairs(coins) do
    costTrade[itemID] =
    {
        [300] =
        {
            { itemID, 99 },
            { itemID, 99 },
            { itemID, 99 },
            { itemID,  3 },
        },
        [500] =
        {
            { itemID, 99 },
            { itemID, 99 },
            { itemID, 99 },
            { itemID, 99 },
            { itemID, 99 },
            { itemID,  5 },
        },
    }
end

local items =
{
    -----------------------------------
    -- Orcish
    -----------------------------------
    -- Hand-to-Hand
    {
        jobs = "MNK/PUP",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Persuasion",
                item = xi.item.PERSUASION,
                mats = { { 16437, 1 }, { 16446, 1 }, { 17519, 1 }, { xi.item.WORN_KNUCKLES, 1 } },
                desc = "a pair of metal knuckles +1, mythril knuckles +1, platoon cesti and a pair of worn knuckles",
            },
            {
                name = "Persuasion +1",
                item = xi.item.PERSUASION_P1,
                mats = { { 17472, 1 }, { 17503, 1 }, { 18350, 1 }, { xi.item.PERSUASION, 1 } },
                desc = "a pair of cross-counters, exocets, tourney patas and persuasion",
            },
        },
    },

    -- Sword
    {
        jobs = "PLD/BLU",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Fealty",
                item = xi.item.FEALTY,
                mats = { { 16628, 1 }, { 16634, 1 }, { 17692, 1 }, { xi.item.WORN_SWORD, 1 } },
                desc = "a longsword +1, broadsword +1, platoon spatha and a worn sword",
            },
            {
                name = "Fealty +1",
                item = xi.item.FEALTY_P1,
                mats = { { 16580, 1 }, { 16533, 1 }, { 17693, 1 }, { xi.item.FEALTY, 1 } },
                desc = "a bloodsword, ancient sword, grudge sword and fealty",
            },
        },
    },

    -- Axe
    {
        jobs = "WAR/BST",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Woodlander",
                item = xi.item.WOODLANDER,
                mats = { { 16663, 1 }, { 16664, 1 }, { 16687, 1 }, { xi.item.WORN_AXE, 1 } },
                desc = "a battleaxe +1, war pick +1, platoon axe and a worn axe",
            },
            {
                name = "Woodlander +1",
                item = xi.item.WOODLANDER_P1,
                mats = { { 17927, 1 }, { 16676, 1 }, { 17936, 1 }, { xi.item.WOODLANDER, 1 } },
                desc = "a lohar, viking axe, de saintre's axe and woodlander",
            },
        },
    },

    -- Great Axe
    {
        jobs = "WAR",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Savagery",
                item = xi.item.SAVAGERY,
                mats = { { 16717, 1 }, { 18215, 1 }, { 18209, 1 }, { xi.item.WORN_CHOPPER, 1 } },
                desc = "a greataxe +1, voulge +1, platoon cutter and a worn chopper",
            },
            {
                name = "Savagery +1",
                item = xi.item.SAVAGERY_P1,
                mats = { { 18507, 1 }, { 16727, 1 }, { 18210, 1 }, { xi.item.SAVAGERY, 1 } },
                desc = "a kinship axe, eisentaenzer, raifu and savagery",
            },
        },
    },

    -- Polearm
    {
        jobs = "DRG",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Heartpiercer",
                item = xi.item.HEARTPIERCER,
                mats = { { 16864, 1 }, { 16876, 1 }, { 18085, 1 }, { xi.item.WORN_LANCE, 1 } },
                desc = "a brass spear +1, lance +1, platoon lance and a worn lance",
            },
            {
                name = "Heartpiercer +1",
                item = xi.item.HEARTPIERCER_P1,
                mats = { { 16885, 1 }, { 16882, 1 }, { 18086, 1 }, { xi.item.HEARTPIERCER, 1 } },
                desc = "a gae bolg, calamar, behourd lance and heartpiercer",
            },
        },
    },
    {
        jobs = "WAR",
        coin = xi.item.ORCISH_STEEL,
        tier =
        {
            {
                name = "Solus",
                item = xi.item.SOLUS,
                mats = { { 12334, 1 }, { 12326, 1 }, { 18171, 1 }, { xi.item.WORN_SHIELD, 1 } },
                desc = "a strong shield, kite shield +1, platoon disc and a worn shield",
            },
            {
                name = "Solus +1",
                item = xi.item.SOLUS_P1,
                mats = { { 12348, 1 }, { 16187, 1 }, { 12405, 1 }, { xi.item.WORN_SHIELD, 1 } },
                desc = "a serket shield, adoubeur's pavise, jennet shield and solus",
            },
        },
    },

    -----------------------------------
    -- Quadav
    -----------------------------------
    {
        jobs = "RDM",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Spellsword",
                item = xi.item.SPELLSWORD,
                mats = { { 16633, 1 }, { 16803, 1 }, { 17692, 1 }, { xi.item.WORN_RAPIER, 1 } },
                desc = "a degen +1, fleuret +1, platoon spatha and a worn rapier",
            },
            {
                name = "Spellsword +1",
                item = xi.item.SPELLSWORD_P1,
                mats = { { 16822, 1 }, { 16821, 1 }, { 17696, 1 }, { xi.item.SPELLSWORD, 1 } },
                desc = "a crimson blade, duel rapier, buzzard tuck and spellsword",
            },
        },
    },
    {
        jobs = "DRK/RUN",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Bitterness",
                item = xi.item.BITTERNESS,
                mats = { { 16931, 1 }, { 16932, 1 }, { 16959, 1 }, { xi.item.WORN_BLADE, 1 } },
                desc = "a two-handed sword +1, greatsword +1, platoon sword and a worn blade",
            },
            {
                name = "Bitterness +1",
                item = xi.item.BITTERNESS_P1,
                mats = { { 16942, 1 }, { 16945, 1 }, { 16937, 1 }, { xi.item.BITTERNESS, 1 } },
                desc = "a balmung, arondight, icicle sword and bitterness",
            },
        },
    },
    {
        jobs = "BLM/DRK",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Foreshadow",
                item = xi.item.FORESHADOW,
                mats = { { 16779, 1 }, { 16782, 1 }, { 18045, 1 }, { xi.item.WORN_SCYTHE, 1 } },
                desc = "a zaghnal +1, mythril scythe +1, platoon zaghnal and a worn scythe",
            },
            {
                name = "Foreshadow +1",
                item = xi.item.FORESHADOW_P1,
                mats = { { 16787, 1 }, { 18041, 1 }, { 18046, 1 }, { xi.item.FORESHADOW, 1 } },
                desc = "a demonslicer, a l'outrance, mutilator and foreshadow",
            },
        },
    },
    {
        jobs = "WHM/GEO",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Stoutheart",
                item = xi.item.STOUTHEART,
                mats = { { 17115, 1 }, { 17121, 1 }, { 17462, 1 }, { xi.item.WORN_HAMMER, 1 } },
                desc = "a warhammer +1, maul +1, platoon mace and a worn hammer",
            },
            {
                name = "Stoutheart +1",
                item = xi.item.STOUTHEART_P1,
                mats = { { 17416, 1 }, { 17454, 1 }, { 17463, 1 }, { xi.item.STOUTHEART, 1 } },
                desc = "an arcana breaker, asklepios, sealed mace and stoutheart",
            },
        },
    },
    {
        jobs = "SMN",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Radiance",
                item = xi.item.RADIANCE,
                mats = { { 17126, 1 }, { 17127, 1 }, { 17571, 1 }, { xi.item.WORN_STAFF, 1 } },
                desc = "an elm staff +1, oak staff +1, platoon pole and a worn staff",
            },
            {
                name = "Radiance +1",
                item = xi.item.RADIANCE_P1,
                mats = { { 17108, 1 }, { 17563, 1 }, { 17573, 1 }, { xi.item.RADIANCE, 1 } },
                desc = "a healing staff, power staff, himmel stock and radiance",
            },
        },
    },
    {
        jobs = "RNG/COR",
        coin = xi.item.QUADAV_BRASS,
        tier =
        {
            {
                name = "Insurance",
                item = xi.item.INSURANCE,
                mats = { { 17254, 1 }, { 17260, 1 }, { 17271, 1 }, { xi.item.WORN_MUSKET, 1 } },
                desc = "an arquebus +1, pirate's gun +1, platoon gun and a worn musket",
            },
            {
                name = "Insurance +1",
                item = xi.item.INSURANCE_P1,
                mats = { { 17232, 1 }, { 17244, 1 }, { 17215, 1 }, { xi.item.INSURANCE, 1 } },
                desc = "a lion crossbow, othinus' bow, thug's zamburak and insurance",
            },
        },
    },

    -----------------------------------
    -- Yagudo
    -----------------------------------
    {
        jobs = "THF/DNC",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Bushwhacker",
                item = xi.item.BUSHWHACKER,
                mats = { { 16742, 1 }, { 16739, 1 }, { 17993, 1 }, { xi.item.WORN_KNIFE, 1 } },
                desc = "a poison knife +1, mythril knife +1, platoon dagger and a worn knife",
            },
            {
                name = "Bushwhacker +1",
                item = xi.item.BUSHWHACKER_P1,
                mats = { { 16767, 1 }, { 19120, 1 }, { 17994, 1 }, { xi.item.BUSHWHACKER, 1 } },
                desc = "a triple dagger, avis, calveley's dagger and bushwhacker",
            },
        },
    },
    {
        jobs = "NIN",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Hikage",
                item = xi.item.HIKAGE,
                mats = { { 16925, 1 }, { 16921, 1 }, { 17786, 1 }, { xi.item.WORN_KATANA, 1 } },
                desc = "a mokuto +1, kodachi +1, ganko and a worn katana",
            },
            {
                name = "Hikage +1",
                item = xi.item.HIKAGE_P1,
                mats = { { 19280, 1 }, { 16911, 1 }, { 17787, 1 }, { xi.item.HIKAGE, 1 } },
                desc = "a narigitsune, amanojaku, ohaguro and hikage",
            },
        },
    },
    {
        jobs = "SAM",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Giritachi",
                item = xi.item.GIRITACHI,
                mats = { { 16983, 1 }, { 16986, 1 }, { 17820, 1 }, { xi.item.WORN_TACHI, 1 } },
                desc = "a nodachi +1, homura +1, gunromaru and a worn tachi",
            },
            {
                name = "Giritachi +1",
                item = xi.item.GIRITACHI_P1,
                mats = { { 17813, 1 }, { 16980, 1 }, { 17821, 1 }, { xi.item.GIRITACHI, 1 } },
                desc = "a soboro sukehiro, sukesada, kagehide and giritachi",
            },
        },
    },
    {
        jobs = "BLM/SCH",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Arcanium",
                item = xi.item.ARCANIUM,
                mats = { { 17124, 1 }, { 17119, 1 }, { 17571, 1 }, { xi.item.WORN_POLE, 1 } },
                desc = "a holly pole +1, elm pole +1, platoon pole and a worn pole",
            },
            {
                name = "Arcanium +1",
                item = xi.item.ARCANIUM_P1,
                mats = { { 17586, 1 }, { 17564, 1 }, { 17572, 1 }, { xi.item.ARCANIUM, 1 } },
                desc = "a mercurial pole, cocytus pole, dusky staff and arcanium",
            },
        },
    },
    {
        jobs = "RNG",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Elvenlore",
                item = xi.item.ELVENLORE,
                mats = { { 17178, 1 }, { 17180, 1 }, { 17202, 1 }, { xi.item.WORN_LONGBOW, 1 } },
                desc = "a power bow +1, great bow +1, platoon bow and a worn longbow",
            },
            {
                name = "Elvenlore +1",
                item = xi.item.ELVENLORE_P1,
                mats = { { 17187, 1 }, { 17212, 1 }, { 17203, 1 }, { xi.item.ELVENLORE, 1 } },
                desc = "a eurytos' bow, selene's bow, shikar bow and elvanlore",
            },
        },
    },
    {
        jobs = "BRD",
        coin = xi.item.YAGUDO_SILVER,
        tier =
        {
            {
                name = "Rouser",
                item = xi.item.ROUSER,
                mats = { { 17370, 1 }, { 17375, 1 }, { 18170, 1 }, { xi.item.WORN_FIFE, 1 } },
                desc = "a gemshorn +1, traversiere +1, platoon edge and a worn fife",
            },
            {
                name = "Rouser +1",
                item = xi.item.ROUSER_P1,
                mats = { { 17346, 1 }, { 17982, 1 }, { 17995, 1 }, { xi.item.ROUSER, 1 } },
                desc = "a siren flute, kard, jongleur's dagger and rouser",
            },
        },
    },
}

local lookup     = {}
local lookupCost = {}
local learnList =
{
    {}, -- Tier I
    {}, -- Tier II
}

-- Add currency required
for index, weaponInfo in pairs(items) do
    for tier, itemInfo in pairs(weaponInfo.tier) do
        lookup[itemInfo.item]     = itemInfo.name
        lookupCost[itemInfo.item] = { qty = cost[tier], item = weaponInfo.coin }

        local desc = itemInfo.desc

        if tier == 2 then
            desc = fmt("10 {}, {}", chains[weaponInfo.coin].desc, desc)
            table.insert(items[index].tier[tier].mats, { chains[weaponInfo.coin].item, 10 })
        end

        table.insert(learnList[tier], { itemInfo.name, weaponInfo.jobs, desc, cost[tier], weaponInfo.coin })
    end
end

local function delaySendMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function learnMore(player, npc, itemInfo)
    cexi.util.dialog(player, {
        fmt("Huh, you wanna make the legendary {} ({})? Well if you really want that one, it's gonna cost ya...", itemInfo[1], itemInfo[2]),
        fmt(" Let's see, I'll need... {}.", itemInfo[3]),
        "Bring all that together and I'l see what I can do.",
        fmt(" Once that's settled, don't forget to bring {} {}! I ain't workin' for free ya know!", itemInfo[4], coins[itemInfo[5]]),
    }, npc:getPacketName(), { npc = npc })
end

local function onTrade(player, npc, trade)
    if not player:isCrystalWarrior() then
        return
    end

    local npcName = npc:getPacketName()
    local prog    = player:getCharVar(info.progVar)

    if prog == 0 then
        if npcUtil.tradeHasExactly(trade, info.required) then
            cexi.util.dialog(player, {
                "Oh, oh! Well then. I think I can probably show ya a thing or two.",
                { message = "You have unlocked Smithnix the Blacksmith!" },
            }, npcName, { npc = npc })

            player:setCharVar(info.progVar, 1)
            player:tradeComplete()
        end

        return
    end

    local pending = player:getCharVar(info.pendVar)

    if pending ~= 0 then
        local itemCosts = lookupCost[pending]

        if npcUtil.tradeHasExactly(trade, costTrade[itemCosts.item][itemCosts.qty]) then
            cexi.util.dialog(player, {
                "There it is... Now I can get to work.",
                " I'm gonna need some time here, pal. So, come back tomorrow would ya?",
            }, npcName, { npc = npc })

            player:setCharVar(info.pendVar, 0)
            player:setCharVar(info.lockVar, pending)
            player:setCharVar(info.delayVar, 1, JstMidnight())
            player:tradeComplete()

            return
        end
    end

    if player:getCharVar(info.delayVar) ~= 0 then
        local itemID = player:getCharVar(info.lockVar)

        cexi.util.dialog(player, {
            fmt("Woah, hold up buddy! I still need more time to finish your {}!", lookup[itemID]),
        }, npcName, { npc = npc })

        return
    end

    for _, weaponInfo in pairs(items) do
        for tier, itemInfo in pairs(weaponInfo.tier) do
            if npcUtil.tradeHasExactly(trade, itemInfo.mats) then
                cexi.util.dialog(player, {
                    "Very nice. Looks like everything is here.",
                    fmt(" Now about the payment. It's {} {}. And I'm not lifting one gobbie finger until I get it!", cost[tier], coins[weaponInfo.coin]),
                }, npc:getPacketName(), { npc = npc })

                player:setCharVar(info.pendVar, itemInfo.item)
                player:tradeComplete()

                return
            end
        end
    end
end

local function onTrigger(player, npc)
    local npcName = npc:getPacketName()

    if not player:isCrystalWarrior() then
        cexi.util.dialog(player, {
            "Hey, do I know you? No? Then get moving...",
        }, npcName, { npc = npc })

        return
    end

    local prog = player:getCharVar(info.progVar)

    if prog == 0 then
        cexi.util.dialog(player, {
            "Hey outsider, you wanna see what a real gobbie blacksmith is capable of?",
            " Bring me something to eat and I'll think about it! Let's see... about 5 goblin pies oughta do it!",
        }, npcName, { npc = npc })
        return
    end

    local pending = player:getCharVar(info.pendVar)

    if pending ~= 0 then
        local itemCosts = lookupCost[pending]

        cexi.util.dialog(player, {
            fmt("Huh, you here about that {}? I haven't been paid yet!", lookup[pending]),
            fmt(" That'll be... {} {}. And I'm not lifting one gobbie finger until I get it!", itemCosts.qty, coins[itemCosts.item]),
        }, npc:getPacketName(), { npc = npc })

        return
    end

    local itemID = player:getCharVar(info.lockVar)

    if itemID ~= 0 then
        if player:getCharVar(info.delayVar) == 0 then
            local tbl =
            {
                fmt("Hey, I finished your order for the {}, What d'ya think?", lookup[itemID]),
            }

            local delay = cexi.util.dialogDelay(tbl)
            cexi.util.dialog(player, tbl, npcName, { npc = npc })

            player:timer(delay, function()
                if npcUtil.giveItem(player, itemID) then
                    player:setCharVar(info.lockVar, 0)

                    cexi.crystal_warrior.announcement.worldFirst(
                        player, fmt("[CW]{}", string.upper(lookup[itemID])),
                        fmt("{} is the first player to obtain {}!", player:getName(), lookup[itemID])
                    )
                end
            end)
        else
            cexi.util.dialog(player, {
                fmt("Woah, hold up buddy! I still need more time to finish your {}!", lookup[itemID]),
            }, npcName, { npc = npc })
        end

        return
    end

    delaySendMenu(player, {
        title   = "Select an item:",
        options =
        {
            {
                "Tier I Weapons",
                function()
                    cexi.util.simpleMenu(player, npc, learnList[1], learnMore, "Select an item:")
                end,
            },
            {
                "Tier II Weapons",
                function()
                    cexi.util.simpleMenu(player, npc, learnList[2], learnMore, "Select an item:")
                end,
            },
        },
    })
end

cexi.util.liveReload(m, {
    ["Oldton_Movalpolos"] =
    {
        {
            name      = "Smithnix",
            objtype   = xi.objType.NPC,
            x         = -34.582,
            y         = 12.000,
            z         = 111.987,
            rotation  = 0,
            look      = 509,
            onTrade   = onTrade,
            onTrigger = onTrigger,
        }
    }
})

return m
