-----------------------------------
-- Gramateus - CW Scrolls NPC
-----------------------------------
-- !pos -89.432 0.799 84.765 244
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc_cw_scrolls")

-- Load scroll list into Ephemeral Box
-- (This can be done any time after base ephemeral_box is loaded)
for jobName, itemPage in pairs(cexi.crystal_warrior.scrolls) do
    for pageNum, pageInfo in pairs(itemPage) do
        for _, itemInfo in pairs(pageInfo) do
            cexi.crystal_warrior.ephemeral_box.tradeable[itemInfo[2]] = { itemInfo[1], jobName, "Page " .. pageNum }
        end
    end
end

local mainOrder =
{
    "White Magic",
    "Black Magic",
    "Summoning",
    "Ninjutsu",
    "Songs",
    "Dice",
    "Geomancy",
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function scrollMenu(player, npc, info, varName)
    local options = {}
    local value   = player:getCharVar(varName)

    for index = 0, 32 do
        if
            utils.mask.getBit(value, index) and
            info[index + 1] ~= nil
        then
            local item = info[index + 1]
            table.insert(options, { item[1], item[2], index })
        end
    end

    cexi.util.simpleMenu(player, npc, options, function(playerArg, npcArg, item)
        cexi.util.dialog(player, { "As promised, here's your returned scroll." }, npc:getPacketName(), { npc = npc })

        if npcUtil.giveItem(player, item[2]) then
            local value  = player:getCharVar(varName)
            local result = utils.mask.setBit(value, item[3], false)
            player:setCharVar(varName, result)

            scrollMenu(player, npc, info, varName)
        end
    end, "Select a scroll:")
end

local function tierMenu(player, npc, tier, category)
    local options = {}

    for tierIndex, tierInfo in pairs(tier) do
        local varName = fmt("[CW]SCROLL_{}_{}", cexi.crystal_warrior.scrolls_short[category], cexi.numeral[tierIndex])

        if player:getCharVar(varName) ~= 0 then
            table.insert(options, {
                fmt("Page {}", cexi.numeral[tierIndex]),
                function()
                    scrollMenu(player, npc, tierInfo, varName)
                end,
            })
        end
    end

    delaySendMenu(player, {
        title   = "Select a page:",
        options = options,
    })
end

local function mainMenu(player, npc)
    local options = {}

    for _, item in pairs(mainOrder) do
        table.insert(options, {
            item,
            function()
                tierMenu(player, npc, cexi.crystal_warrior.scrolls[item], item)
            end,
        })
    end

    delaySendMenu(player, {
        title   = "Select scroll type:",
        options = options,
    })
end


local function onTrigger(player, npc)
    if player:getCharVar("[CW]DECRYPTING_ANTIQUITY") < 5 then
        cexi.util.dialog(player, { "Hmm... You should speak to Lectilas if you want to make yourself useful." }, npc:getPacketName(), { npc = npc })
    else
        cexi.util.dialog(player, { "Here to retrieve your scrolls, or perhaps lend one more to our collection?" }, npc:getPacketName(), { npc = npc })
        mainMenu(player, npc)
    end
end

local function onTrade(player, npc, trade)
    local lastSlot = trade:getSlotCount() - 1
    local storing  =
    {
        fmt("{} : This will be invaluable for our research.", npc:getPacketName()),
        " Rest assured, I will take the utmost care of your scrolls until you return.",
    }

    -- Check if tradeable
    for i = 0, lastSlot do
        local itemID = trade:getItemId(i)

        if cexi.crystal_warrior.scrolls_tradeable[itemID] == nil then
            player:fmt("You cannot store this item.")
            return
        end
    end

    -- Check if already stored
    for i = 0, lastSlot do
        local itemID    = trade:getItemId(i)
        local itemQty   = trade:getSlotQty(i)

        local index    = cexi.crystal_warrior.scrolls_tradeable[itemID][1]
        local itemName = cexi.crystal_warrior.scrolls_tradeable[itemID][2]
        local category = cexi.crystal_warrior.scrolls_tradeable[itemID][3]
        local tier     = cexi.crystal_warrior.scrolls_tradeable[itemID][4]
        local varName  = fmt("[CW]SCROLL_{}_{}", cexi.crystal_warrior.scrolls_short[category], cexi.numeral[tier])
        local value    = player:getCharVar(varName)

        if utils.mask.getBit(value, index) then
            cexi.util.dialog(player, { fmt("Hey, I'm already holding a scroll of {} for you!", itemName) }, npc:getPacketName(), { npc = npc })
            return
        end
    end

    -- Store all items
    for i = 0, lastSlot do
        local itemID    = trade:getItemId(i)
        local itemQty   = trade:getSlotQty(i)

        local index    = cexi.crystal_warrior.scrolls_tradeable[itemID][1]
        local itemName = cexi.crystal_warrior.scrolls_tradeable[itemID][2]
        local category = cexi.crystal_warrior.scrolls_tradeable[itemID][3]
        local tier     = cexi.crystal_warrior.scrolls_tradeable[itemID][4]
        local varName  = fmt("[CW]SCROLL_{}_{}", cexi.crystal_warrior.scrolls_short[category], cexi.numeral[tier])
        local value    = player:getCharVar(varName)

        player:setCharVar(varName, utils.mask.setBit(value, index, true))
        table.insert(storing, fmt("You store a scroll of {} ({} \129\168 {})", itemName, category, cexi.numeral[tier]))
    end

    -- Complete trade and show dialog
    player:tradeComplete()
    cexi.util.dialog(player, storing, "", { npc = npc })
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            name     = "Gramateus",
            objtype  = xi.objType.NPC,
            look   = cexi.util.look({
                race = xi.race.ELVAAN_M,
                face = cexi.face.A8,
                body = cexi.model.ERRANT_HOUPPELANDE,
                hand = cexi.model.WHITE_CLOAK,
                legs = cexi.model.NASHIRA_MANTEEL,
                feet = cexi.model.WHITE_CLOAK,
            }),
            x         = -89.432,
            y         = 0.799,
            z         = 84.765,
            rotation  = 210,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        }
    }
})

return m
