-----------------------------------
-- Crystal Warrior Chocobo
-- Override chocobo whistle with mount models
-----------------------------------
-- !pos -60.896 8.000 84.468
-----------------------------------
require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("npc_cw_riding_thunder")

local vars =
{
    MOUNT_ID   = "[CW]MOUNT_ID",
    MOUNT_LIST = "[CW]MOUNT_LIST",
}

local dialog =
{
    NON_CW =
    {
        { emote = xi.emote.NO },
        "Sorry, I can't help you.",
        { delay = 3000 },
    },

    NONE   =
    {
        { emote = xi.emote.THINK },
        "Sorry, I can't help you yet.",
        { delay = 3000 },
    },

    LIST   =
    {
        { emote = xi.emote.WELCOME },
        "Yes, how may I help you?",
        { delay = 3000 },
    },
}

local mount =
{
    -- Number corresponds to bits in [CW]MOUNT_LIST
    -- String is the name used on Riding Thunder's menu
    [0]  = { "Raptor",      xi.mount.RAPTOR      },
    [1]  = { "Tiger",       xi.mount.TIGER       },
    [2]  = { "Crab",        xi.mount.CRAB        },
    [3]  = { "Red Crab",    xi.mount.RED_CRAB    },
    [4]  = { "Bomb",        xi.mount.BOMB        },
    [5]  = { "Ram",         xi.mount.RAM         },
    [6]  = { "Morbol",      xi.mount.MORBOL      },
    [7]  = { "Crawler",     xi.mount.CRAWLER     },
    [8]  = { "Fenrir",      xi.mount.FENRIR      },
    [9]  = { "Beetle",      xi.mount.BEETLE      },
    [10] = { "Magic Pot",   xi.mount.MAGIC_POT   },
    [11] = { "Tulfaire",    xi.mount.TULFAIRE    },
    [12] = { "Warmachine",  xi.mount.WARMACHINE  },
    [13] = { "Xzomit",      xi.mount.XZOMIT      },
    [14] = { "Hippogryph",  xi.mount.HIPPOGRYPH  },
    [15] = { "Spheroid",    xi.mount.SPHEROID    },
    [16] = { "Omega",       xi.mount.OMEGA       },
    [17] = { "Coeurl",      xi.mount.COEURL      },
    [18] = { "Goobbue",     xi.mount.GOOBBUE     },
    [19] = { "Raaz",        xi.mount.RAAZ        },
    [20] = { "Levitus",     xi.mount.LEVITUS     },
    [21] = { "Adamantoise", xi.mount.ADAMANTOISE },
    [22] = { "Dhalmel",     xi.mount.DHALMEL     },
    [23] = { "Doll",        xi.mount.DOLL        },
    [24] = { "Golden Bomb", xi.mount.GOLDEN_BOMB },
    [25] = { "Buffalo",     xi.mount.BUFFALO     },
    [26] = { "Wivre",       xi.mount.WIVRE       },
    [27] = { "Red Raptor",  xi.mount.RED_RAPTOR  },
    [28] = { "Iron Giant",  xi.mount.IRON_GIANT  },
    [39] = { "Byakko",      xi.mount.BYAKKO      },
    [30] = { "Ixion",       xi.mount.IXION       },
    [31] = { "Phuabo",      xi.mount.PHUABO      },
}

local function delaySendMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

m:addOverride("xi.items.chocobo_whistle.onItemUse", function(target)
    if not target:isCrystalWarrior() then
        super(target)
    else
        -- Base duration 30 min, in seconds.
        local duration = 1800 + (target:getMod(xi.mod.CHOCOBO_RIDING_TIME) * 60)
        local mount    = target:getCharVar("[CW]MOUNT_ID")
        target:addStatusEffectEx(xi.effect.MOUNTED, xi.effect.MOUNTED, mount, 0, duration, 0, 64, true)
    end
end)

local function confirmMount(player, npc, item)
    player:setCharVar(vars.MOUNT_ID, item[2])
    npc:independentAnimation(player, 147, 2)

    cexi.util.dialog(player, {
        { message = fmt("Your chocobo whistle is now set to {}!", item[1]) },
        fmt("All right, from now on, when you use a chocobo whistle, you'll call out your {}!", item[1])
    }, npc:getPacketName(), { npc = npc })
end

local function onTrigger(player, npc)
    local npcName = npc:getPacketName()

    if not player:isCrystalWarrior() then
        cexi.util.dialog(player, dialog.NON_CW, npcName, { npc = npc })
        return
    end

    local mountList = player:getCharVar(vars.MOUNT_LIST)

    if mountList == 0 then
        cexi.util.dialog(player, dialog.NONE, npcName, { npc = npc })
    else
        cexi.util.dialog(player, dialog.LIST, npcName, { npc = npc })

        local shownList =
        {
            { "Chocobo", xi.mount.CHOCOBO },
        }

        for index, mountInfo in pairs(mount) do
             if utils.mask.getBit(mountList, index) then
                table.insert(shownList, mountInfo)
            end
        end

        cexi.util.simpleMenu(player, npc, shownList, confirmMount, "Select your mount:")
    end
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            name     = "Riding Thunder",
            objtype  = xi.objType.NPC,
            x        = -60.896,
            y        = 8.000,
            z        = 84.468,
            rotation = 236,
            look     = cexi.util.look({
                race = xi.race.GALKA,
                face = cexi.face.B3,
                head = 353, -- Chocobo Suit
                body = 353, -- Chocobo Masque
            }),

            onTrigger = onTrigger,
        }
    }
})

return m
