-----------------------------------
-- Crystal Warrior Repairers
-- Renovio     !pos 18.763 -7.287 3.505 248
-- Steel Teeth !pos -58.409 -16.000 29.167 249
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("npc_cw_repairers")

local clothSets =
{
    ["Seer's Attire"] =
    {
        prog = { "[CW]SEARCHING_CITADEL", 13 },
        vars = "[CW]REPAIR_SEERS",
        item =
        {
            { 15163, "Seer's Crown",  "two bone chips",             { { 880, 2 } } },
            { 14424, "Seer's Tunic",  "one square of cotton cloth", { { 825, 1 } } },
            { 14856, "Seer's Mitts",  "two balls of saruta cotton", { { 834, 2 } } },
            { 14325, "Seer's Slacks", "one square of grass cloth",  { { 824, 1 } } },
            { 15313, "Seer's Pumps",  "one spool of grass thread",  { { 817, 1 } } },
        },
    },
    ["Noct Attire"] =
    {
        prog = { "[CW]NAVIGATE_NEST", 13 },
        vars = "[CW]REPAIR_NOCT",
        item =
        {
            { 15161, "Noct Beret",    "two chocobo feathers and two flax flowers",          { { 840, 2 }, { 835, 2 } } },
            { 14422, "Noct Doublet",  "three balls of saruta cotton and one sheep leather", { { 834, 3 }, { 850, 1 } } },
            { 14854, "Noct Gloves",   "two balls of saruta cotton and two flax flowers",    { { 834, 2 }, { 835, 2 } } },
            { 14323, "Noct Brais",    "six flax flowers",                                   { { 835, 6 } } },
            { 15311, "Noct Gaiters",  "two squares of sheep leather",                       { { 850, 2 } } },
        },
    },
    ["Garish Attire"] =
    {
        prog = { "[CW]ON_THE_RANGE", 8 },
        vars = "[CW]REPAIR_GARISH",
        item =
        {
            -- Garish Crown  MP  +5,    Attack   +2
            -- Garish Tunic  HP +15,    Accuracy +2
            -- Garish Mitts  MP +10,    Accuracy +2
            -- Garish Slacks HP +10,    Accuracy +3
            -- Garish Pumps  MP  +5,    Attack   +2
            { { 15164, { 9,  4, 25, 1 } }, "Garish Crown",  "one coeurl whisker, one bloodthread and one beetle jaw",   { { 927, 1 }, { 1700, 1 }, { 894, 1 } } },
            { { 14425, { 1, 14, 23, 1 } }, "Garish Tunic",  "four sheep wool, one bloodthread and one sheep leather",   { { 832, 4 }, { 1700, 1 }, { 850, 1 } } },
            { { 14857, { 9,  9, 23, 1 } }, "Garish Mitts",  "two saruta cotton and one bloodthread",                    { { 834, 2 }, { 1700, 1 } } },
            { { 14326, { 1,  9, 23, 2 } }, "Garish Slacks", "two silk threads, one bloodthread and one sheep leather",  { { 816, 2 }, { 1700, 1 }, { 850,  1 } } },
            { { 15314, { 9,  4, 25, 1 } }, "Garish Pumps",  "two sheep leather and one bloodthread",                    { { 850, 2 }, { 1700, 1 } } },
        },
    },
}

local metalSets =
{
    ["Eisenbrust Attire"] =
    {
        prog = { "[CW]NECROPOLIS", 14 },
        vars = "[CW]REPAIR_EISENBRUST",
        item =
        {
            { 15167, "Eisenschaller",   "two chunks of iron ore",     { { 643, 2 } } },
            { 14431, "Eisenbrust",      "three flint stones",         { { 768, 3 } } },
            { 14860, "Eisenhentzes",    "two rusty buckets",          { {  90, 2 } } },
            { 14329, "Eisendiechlings", "a block of animal glue",     { { 937, 1 } } },
            { 15317, "Eisenschuhs",     "one square of cotton cloth", { { 825, 1 } } },
        },
    },
    ["Shade Attire"] =
    {
        prog = { "[CW]EMPTY_HANDED", 8 },
        vars = "[CW]REPAIR_SHADE",
        item =
        {
            -- Shade Tiara    STR +2, CHR +2
            -- Shade Harness  VIT +2, MND +2
            -- Shade Mittens  STR +2, INT +2
            -- Shade Tights   STR +2, INT +2
            -- Shade Leggings DEX +2, MND +2
            { { 15165, { 512, 1, 518, 1 } }, "Shade Tiara",    "two bitter memories and two somber memories",       { { 1607, 2 }, { 1611, 2 } } },
            { { 14426, { 514, 1, 517, 1 } }, "Shade Harness",  "two radiant memories and two burning memories",     { { 1612, 2 }, { 1606, 2 } } },
            { { 14858, { 512, 1, 516, 1 } }, "Shade Mittens",  "two profane memories and two malevolent memories",  { { 1609, 2 }, { 1613, 2 } } },
            { { 14327, { 512, 1, 516, 1 } }, "Shade Tights",   "two fleeting memories and two startling memories",  { { 1608, 2 }, { 1610, 2 } } },
            { { 15315, { 513, 1, 517, 1 } }, "Shade Leggings", "two malevolent memories and two fleeting memories", { { 1613, 2 }, { 1608, 2 } } },
        },
    },
}

local npcs =
{
    {
        name   = "Renovio",
        zone   = "Selbina",
        look   = "0x0100060300009200030003000300000000700000",
        pos    = { 18.763, -7.287, 3.505, 161 }, -- !pos 18.763 -7.287 3.505 248
        sets   = clothSets,
        dialog =
        {
            NEW_SET =
            {
                { entity = "Renovio", emote = xi.emote.AMAZED },
                "Ah, I see you've found pieces of a %s! Unfortunately, I'll need a few materials to make this wearable."
            },
            NOTHING      = { "We don't have anything to discuss." },
            SELECT_SET   = { "Which set would you like to discuss?" },
            SELECT_PIECE = { "Which piece of the set?" },
            REPAIR       = { "%s? For that repair I'm going to require %s." },
            MAKING       =
            {
                { entity = "Renovio", emote = xi.emote.THINK },
                "I see you've brought %s to repair the %s. Just a moment.",
            },
        },
    },
    {
        name   = "Steel Teeth",
        zone   = "Mhaura",
        look   = "0x01000F081D0091001D001D001D00000000000000",
        pos    = { -58.409, -16.000, 29.167, 37 }, -- !pos -58.409 -16.000 29.167 249
        sets   = metalSets,
        dialog =
        {
            NEW_SET =
            {
                { entity = "Steel_Teeth", emote = xi.emote.THINK },
                "Hmm... pieces of a %s but they're damaged beyond use.",
                " Fetch a few materials and I'll see what I can do.",
            },
            NOTHING      = { "Do I know you? I'm busy." },
            SELECT_SET   = { "Which set was it?" },
            SELECT_PIECE = { "All right, which piece?" },
            REPAIR       = { "%s? That repair is gonna need %s." },
            MAKING       =
            {
                { entity = "Steel_Teeth", emote = xi.emote.THINK },
                "Looks like %s to repair the %s? Let's see here...",
            },
        },
    },
}

local function delayMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function pieceMenu(player, entity, set)
    local pieceTable = {}
    local setVar     = player:getCharVar(entity.sets[set].vars)

    for k, v in pairs(entity.sets[set].item) do
        -- Check player hasn't already obtained this piece
        if not utils.mask.getBit(setVar, k) then
            table.insert(pieceTable, {
                v[2],
                function()
                    cexi.util.dialog(player, entity.dialog.REPAIR, entity.name, { v[2], v[3] })
                end,
            })
        end
    end

    table.insert(pieceTable, {
        "Nothing",
        function()
        end,
    })

    cexi.util.dialog(player, entity.dialog.SELECT_PIECE, entity.name)
    delayMenu(player, {
        title   = "Select a piece:",
        options = pieceTable,
    })
end

local function onTriggerRepair(player, npc, entity)
    if not player:isCrystalWarrior() then
        cexi.util.dialog(player, { "Unfortunately, I'm not able to help you." }, npc:getPacketName(), { npc = npc })
        return
    end

    local setTable = {}

    -- Check for new sets to repair
    for k, v in pairs(entity.sets) do
        if player:getCharVar(v.prog[1]) == v.prog[2] then
            cexi.util.dialog(player, entity.dialog.NEW_SET, entity.name, { k })
            player:incrementCharVar(v.prog[1], 1)
            return
        end

        if player:getCharVar(v.prog[1]) == v.prog[2] + 1 then
            table.insert(setTable, {
                k,
                function()
                    pieceMenu(player, entity, k)
                end,
            })
        end
    end

    table.insert(setTable, {
        "Nothing",
        function()
        end,
    })

    -- Select existing sets
    if #setTable == 0 then
        cexi.util.dialog(player, entity.dialog.NOTHING, entity.name)
    else
        cexi.util.dialog(player, entity.dialog.SELECT_SET, entity.name)
        delayMenu(player, {
            title   = "Select a set:",
            options = setTable,
        })
    end
end

local function onTradeRepair(player, npc, trade, entity)
    if not player:isCrystalWarrior() then
        cexi.util.dialog(player, { "Unfortunately, I'm not able to help you." }, npc:getPacketName(), { npc = npc })
        return
    end

    -- Try each set
    for k, v in pairs(entity.sets) do

        -- Check player is on repair stage
        if player:getCharVar(v.prog[1]) == v.prog[2] + 1 then

            -- If items traded match
            for row, item in pairs(v.item) do
                local setVar = player:getCharVar(v.vars)

                if
                    not utils.mask.getBit(setVar, row) and  -- Check player hasn't already obtained this piece
                    npcUtil.tradeHasExactly(trade, item[4]) -- Check the traded materials match the item
                then
                    cexi.util.dialog(player, entity.dialog.MAKING, entity.name, { item[3], item[2] })

                    npc:timer(3000, function()
                        -- Augmented reward
                        if type(item[1]) == "table" then
                            local ID = zones[player:getZoneID()]

                            if player:getFreeSlotsCount() > 0 then
                                player:tradeComplete()
                                player:addItem(item[1][1], 1, unpack(item[1][2]))
                                player:messageSpecial(ID.text.ITEM_OBTAINED, item[1][1])
                                player:setCharVar(v.vars, utils.mask.setBit(player:getCharVar(v.vars), row, true))
                            else
                                player:messageSpecial(ID.text.ITEM_CANNOT_BE_OBTAINED, reward.item)
                                return false
                            end

                        -- Regular reward
                        elseif npcUtil.giveItem(player, item[1]) then
                            player:tradeComplete()
                            player:setCharVar(v.vars, utils.mask.setBit(player:getCharVar(v.vars), row, true))
                        end
                    end)
                end
            end
        end
    end
end

local entities = {}

for _, npcInfo in pairs(npcs) do
    entities[npcInfo.zone] = {
        {
            name     = npcInfo.name,
            objtype  = xi.objType.NPC,
            look     = npcInfo.look,
            x        = npcInfo.pos[1],
            y        = npcInfo.pos[2],
            z        = npcInfo.pos[3],
            rotation = npcInfo.pos[4],

            onTrigger = function(player, npc)
                onTriggerRepair(player, npc, npcInfo)
            end,

            onTrade = function(player, npc, trade)
                onTradeRepair(player, npc, trade, npcInfo)
            end,
        },
    }
end

cexi.util.liveReload(m, entities)

return m
