-----------------------------------
-- Picklox
-- Sells reusable keyring item and garrison passes
-- !pos -46.799 0.000 121.160 244
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("npc_cw_picklox")

local function delaySendMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local bundles =
{
    GARRISON =
    {
        name     = "Garrison Pass",
        bundle   = cexi.bundle.garrison,
        itemID   = xi.item.GARRISON_PASS,
        varName  = "[GARRISON]PASS",
        required = "beastmen orders",
        complete = true,
    },

    CHEST_KEY =
    {
        name     = "Goblin Keyring",
        bundle   = cexi.bundle.chest,
        itemID   = xi.item.GOBLIN_KEYRING,
        varName  = "[KEYS]CHEST",
        required = "chest keys or coffer keys",
        complete = false,
    },

    COFFER_KEY =
    {
        name     = "Goblin Keyring",
        bundle   = cexi.bundle.coffer,
        itemID   = xi.item.GOBLIN_KEYRING,
        varName  = "[KEYS]COFFER",
        required = "chest keys or coffer keys",
        complete = false,
    },
}

local function addToBundle(player, npc, trade, bundleInfo)
    local npcName = npc:getPacketName()
    local current = player:getCharVar(bundleInfo.varName)
    local total   = 0
    local result  = {}

    for index, itemInfo in pairs(bundleInfo.bundle) do
        if npcUtil.tradeHas(trade, itemInfo.item, false) then
            if utils.mask.getBit(current, index) then
                total = total + itemInfo.gil
            else
                current = utils.mask.setBit(current, index, true)
                table.insert(result, itemInfo.name)
            end
        end
    end

    if
        #result == 0 and
        total == 0
    then
        if bundleInfo.complete then
            cexi.util.dialog(player, {
                fmt("Hey! You've gotta trade this with some {}.", bundleInfo.required),
            }, npcName, { npc = npc })
        end

        return nil
    end

    player:setCharVar(bundleInfo.varName, current)

    if bundleInfo.complete then
        player:tradeComplete()
        npcUtil.giveItem(player, bundleInfo.itemID)

        if #result > 0 then
            cexi.util.dialog(player, {
                fmt("Awright, I've added these ones to your {}:", bundleInfo.name),
                fmt(" {}", cexi.util.printList(result))
            }, npcName, { npc = npc })
        end

        if total > 0 then
            npcUtil.giveCurrency(player, 'gil', total)
            cexi.util.dialog(player, {
                fmt("This one's already on your {}! But here's a bit of gil for your time.", bundleInfo.name),
            }, npcName, { npc = npc })
        end
    end

    return result
end

local function onTrade(player, npc, trade)
    local npcName = npc:getPacketName()

    if npcUtil.tradeHas(trade, xi.item.GARRISON_PASS, false) then
        if not cexi.util.tradeContainsOnly(trade, cexi.bundle.tradeableGarrison) then
            cexi.util.dialog(player, { "Huh, what's this? I can't work with that!" }, npcName, { npc = npc })
            return
        else
            addToBundle(player, npc, trade, bundles.GARRISON)
        end

    elseif npcUtil.tradeHas(trade, xi.item.GOBLIN_KEYRING, false) then
        if not cexi.util.tradeContainsOnly(trade, cexi.bundle.tradeableKeys) then
            cexi.util.dialog(player, { "Huh, what's this? I can't work with that!" }, npcName, { npc = npc })
            return
        end

        local resultChest  = addToBundle(player, npc, trade, bundles.CHEST_KEY)
        local resultCoffer = addToBundle(player, npc, trade, bundles.COFFER_KEY)

        if resultChest or resultCoffer then
            player:tradeComplete()
            npcUtil.giveItem(player, xi.item.GOBLIN_KEYRING)

            local tbl = { "Awright, I've added these ones to your keyring:" }

            if resultChest ~= nil and #resultChest > 0 then
                table.insert(tbl, cexi.util.printList(resultChest))
            end

            if resultCoffer ~= nil and #resultCoffer > 0 then
                table.insert(tbl, cexi.util.printList(resultCoffer))
            end

            cexi.util.dialog(player, tbl, npcName, { npc = npc })
        end
    end
end

local function onTrigger(player, npc)
    if not player:isCrystalWarrior() then
        player:sys("This feature is not available to your game mode.")
        return
    end

    npc:facePlayer(player, true)

    delaySendMenu(player, {
        title   = "Who are you?",
        options =
        {
            {
                "What can you do?",
                function()
                    cexi.util.dialog(player, {
                        "Bet your bags are a little tight on space huh? Well, well, do I have an offer for you!",
                        { delay = 1000 },
                        "If you buy one of these here extra fancy Goblin keyrings, you can carry around all of your keys on it! And that's not all...",
                        " I also sell a Garrison Pass for all those pesky garrison items you adventurers lug around.",
                        { delay = 1500 },
                        "Naturally it's gonna cost ya some pretty pennies for this super duper special service.",
                        " Once you've bought one just bring it back with the items and I'll add them for ya.",
                    }, npc:getPacketName(), { npc = npc })
                end,
            },
            {
                "Show me your wares",
                function()
                    xi.shop.general(player, {
                        xi.item.GARRISON_PASS,  200000,
                        xi.item.GOBLIN_KEYRING, 300000,
                    })
                end,
            },
        },
    })
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            name      = "Picklox",
            objtype   = xi.objType.NPC,
            x         = -46.799,
            y         = 0.000,
            z         = 121.160,
            rotation  = 128,
            look      = 508,
            onTrade   = onTrade,
            onTrigger = onTrigger,
        }
    }
})

return m
