----------------------------------------------------
-- Nemosyne - Upper Jeuno
-- Recovers a player's lost quest rewards
-- !pos -26.025 -1.499 24.665 244
----------------------------------------------------
require("modules/module_utils")
require("scripts/globals/mobs")
require("scripts/globals/player")
require("scripts/globals/chocobo")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("npc_cw_nemosyne")

local settings =
{
    var  = "[CW]NEMOSYNE",
    name = "Nemosyne",
    area = "Upper_Jeuno",
    pos  = { -26.025, -1.499, 24.665, 67 }, -- !pos -26.025 -1.499 24.665 244
    look = cexi.util.look({
        race = xi.race.HUME_F,
        face = cexi.face.B3,
        head = 0,
        body = cexi.model.WHITE_CLOAK,
        hand = cexi.model.WHITE_CLOAK,
        legs = cexi.model.WHITE_CLOAK,
        feet = cexi.model.WHITE_CLOAK,
    }),

    dialog =
    {
        LOCKED =
        {
            { emote = xi.emote.NO },
            "Sorry, I don't remember you.",
        },

        DISABLED =
        {
            { emote   = xi.emote.NO },
            "Please come back later, adventurer.",
        },

        LIST   =
        {
            { emote = xi.emote.WELCOME },
            "Greetings adventurer. I can restore your quest rewards.",
            "Here is a list of your eligible completed quests.",
        },

        RESTORE_FOR = { "I can restore this reward for %i gil." },
        CANT_AFFORD = { "That restoration costs %i gil but you only have %i gil." },
    },
}

local quests =
{
    {
        name = "San d'Oria",
        log  = xi.questLog.SANDORIA,
        list =
        {
            { xi.quest.id.sandoria.WATERS_OF_THE_CHEVAL, xi.item.WING_PENDANT,              5000 },
            { xi.quest.id.sandoria.THE_PICKPOCKET,       xi.item.LIGHT_AXE,                 5000 },
            { xi.quest.id.sandoria.UNDYING_FLAMES,       xi.item.FRIARS_ROPE,               5000 },
            { xi.quest.id.sandoria.THE_GENERALS_SECRET,  xi.item.LYNX_BAGHNAKHS,            5000 },
            { xi.quest.id.sandoria.BLACK_TIGER_SKINS,    xi.item.TIGER_STOLE,               5000 },
            { xi.quest.id.sandoria.THE_RUMOR,            xi.item.SCROLL_OF_DRAIN,          10000 },
            { xi.quest.id.sandoria.SIGNED_IN_BLOOD,      xi.item.CUNNING_EARRING,          10000 },
            { xi.quest.id.sandoria.HEALING_THE_LAND,     xi.item.SCROLL_OF_TELEPORT_HOLLA, 15000 },
            { xi.quest.id.sandoria.SORCERY_OF_THE_NORTH, xi.item.SCROLL_OF_TELEPORT_VAHZL, 15000 },
            { xi.quest.id.sandoria.THE_RIVALRY,          xi.item.LU_SHANGS_FISHING_ROD,    30000 },
            { xi.quest.id.sandoria.THE_COMPETITION,      xi.item.LU_SHANGS_FISHING_ROD,    30000 },
        },
    },
    {
        name = "Bastok",
        log  = xi.questLog.BASTOK,
        list =
        {
            { xi.quest.id.bastok.THE_WISDOM_OF_ELDERS, xi.item.TRAVELERS_HAT,           5000 },
            { xi.quest.id.bastok.OUT_OF_ONES_SHELL,    xi.item.MONKS_HEADGEAR,          5000 },
            { xi.quest.id.bastok.MEAN_MACHINE,         xi.item.SCROLL_OF_WARP,         10000 },
            { xi.quest.id.bastok.SILENCE_OF_THE_RAMS,  xi.item.PURPLE_BELT,            10000 },
            { xi.quest.id.bastok.THE_ELEVENTHS_HOUR,   xi.item.SMALL_SWORD,             5000 },
            { xi.quest.id.bastok.FEAR_OF_FLYING,       xi.item.BLACK_SILK_NECKERCHIEF, 10000 },
            { xi.quest.id.bastok.BLADE_OF_DEATH,       xi.item.DEATHBRINGER,            5000 },
            { xi.quest.id.bastok.ALTANAS_SORROW,       xi.item.SCROLL_OF_TELEPORT_DEM, 15000 },
            { xi.quest.id.bastok.FADED_PROMISES,       xi.item.FUKURO,                 10000 },
            { xi.quest.id.bastok.THE_USUAL,            xi.item.SPEED_BOW,               5000 },
            { xi.quest.id.bastok.LOVE_AND_ICE,         xi.item.LAMIA_HARP,              5000 },
            { xi.quest.id.bastok.LOVERS_IN_THE_DUSK,   xi.item.SIREN_FLUTE,            10000 },
        },
    },
    {
        name = "Windurst",
        log  = xi.questLog.WINDURST,
        list =
        {
            { xi.quest.id.windurst.TRUTH_JUSTICE_AND_THE_ONION_WAY, xi.item.JUSTICE_BADGE,           5000 },
            { xi.quest.id.windurst.THE_FANGED_ONE,                  xi.item.RANGERS_NECKLACE,        5000 },
            { xi.quest.id.windurst.A_POSE_BY_ANY_OTHER_NAME,        xi.item.COPY_OF_ANCIENT_BLOOD,   5000 },
            { xi.quest.id.windurst.STAR_STRUCK,                     xi.item.COMPOUND_EYE_CIRCLET,    5000 },
            { xi.quest.id.windurst.TO_CATCH_A_FALLING_STAR,         xi.item.FISH_SCALE_SHIELD,       5000 },
            { xi.quest.id.windurst.OVERNIGHT_DELIVERY,              xi.item.POWER_GI,               10000 },
            { xi.quest.id.windurst.BLUE_RIBBON_BLUES,               xi.item.PURPLE_RIBBON,           8000 },
            { xi.quest.id.windurst.BLUE_RIBBON_BLUES,               xi.item.BLUE_RIBBON,            10000 },
            { xi.quest.id.windurst.ACTING_IN_GOOD_FAITH,            xi.item.SCROLL_OF_TELEPORT_MEA, 15000 },
        },
    },
    {
        name = "Jeuno",
        log  = xi.questLog.JEUNO,
        list =
        {
            { xi.quest.id.jeuno.SAVE_MY_SON,           xi.item.BEAST_WHISTLE,     5000 },
            { xi.quest.id.jeuno.A_CANDLELIGHT_VIGIL,   xi.item.FLOWER_NECKLACE,   5000 },
            { xi.quest.id.jeuno.A_CLOCK_MOST_DELICATE, xi.item.ENGINEERS_GLOVES,  5000 },
            { xi.quest.id.jeuno.THE_KIND_CARDIAN,      xi.item.GREEN_CAPE,       10000 },
            { xi.quest.id.jeuno.THE_CLOCKMASTER,       xi.item.TIME_HAMMER,      10000 }, },
    },
    {
        name = "Other",
        log  = xi.questLog.OTHER_AREAS,
        list =
        {
            { xi.quest.id.otherAreas.DONATE_TO_RECYCLING, 89,                    5000 }, -- Wastebasket
            { xi.quest.id.otherAreas.TEST_MY_METTLE,      xi.item.POWER_SANDALS, 5000 },
            { xi.quest.id.otherAreas.THE_REAL_GIFT,       16497,                 5000 }, -- Sleep Dagger
            { xi.quest.id.otherAreas.EXPERTISE,           xi.item.TABLEWARE_SET, 5000 },
            { xi.quest.id.otherAreas.THE_BASICS,          xi.item.TEA_SET,       5000 },
        },
    },
    {
        name = "Outlands",
        log  = xi.questLog.OUTLANDS,
        list =
        {
            { xi.quest.id.outlands.MISSIONARY_MAN,            xi.item.SCROLL_OF_TELEPORT_YHOAT, 15000 },
            { xi.quest.id.outlands.SECRET_OF_THE_DAMP_SCROLL, xi.item.SCROLL_OF_JUBAKU_ICHI,    10000 },
            { xi.quest.id.outlands.ITS_NOT_YOUR_VAULT,        xi.item.SCROLL_OF_TONKO_ICHI,     10000 },
            { xi.quest.id.outlands.LIKE_A_SHINING_SUBLIGAR,   xi.item.SCROLL_OF_KURAYAMI_ICHI,  10000 },
            { xi.quest.id.outlands.LIKE_A_SHINING_LEGGINGS,   xi.item.SCROLL_OF_DOKUMORI_ICHI,  10000 },
            { xi.quest.id.outlands.MAMA_MIA,                  xi.item.EVOKERS_RING,             30000 },
            { xi.quest.id.outlands.STOP_YOUR_WHINING,         xi.item.SCROLL_OF_HOJO_ICHI,      10000 },
            { xi.quest.id.outlands.THE_SAHAGINS_STASH,        xi.item.SCROLL_OF_UTSUSEMI_ICHI,  15000 },
            { xi.quest.id.outlands.AN_UNDYING_PLEDGE,         12375,                            10000 }, -- Light Buckler
            { xi.quest.id.outlands.DONT_FORGET_THE_ANTIDOTE,  xi.item.DOTANUKI,                 15000 },
            { xi.quest.id.outlands.THE_MISSING_PIECE,         xi.item.SCROLL_OF_TELEPORT_ALTEP, 15000 },
            { xi.quest.id.outlands.PERSONAL_HYGIENE,          xi.item.MITHRAN_STONE,            15000 },
            { xi.quest.id.outlands.THE_OPO_OPO_AND_I,         xi.item.OPO_OPO_CROWN,            20000 },
            { xi.quest.id.outlands.WRATH_OF_THE_OPO_OPOS,     xi.item.OPO_OPO_NECKLACE,         10000 },
            { xi.quest.id.outlands.WANDERING_SOULS,           xi.item.FLAGELLANTS_ROPE,         10000 },
            { xi.quest.id.outlands.SOUL_SEARCHING,            xi.item.BAT_EARRING,              10000 },
        },
    },
}

local function delaySendMenu(player, menuNext)
    local menu = menuNext

    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function confirmPurchase(player, npc, item)
    if player:getGil() < item[3] then
        player:sys("You do not have enough gil.")
        return
    end

    if player:getFreeSlotsCount() < 1 then
        player:sys("You do not have enough inventory space.")
        return
    end

    delaySendMenu(player, {
        title   = fmt("Restore {} for {} gil?", item[1], item[3]),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    if item[4] ~= nil then
                        player:addItem(item[2], 1, item[4][1], item[4][2], item[4][3], item[4][4], item[4][5], item[4][6], item[4][7], item[4][8])
                        player:timer(200, function()
                            player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, item[2])
                        end)
                    else
                        if npcUtil.giveItem(player, item[2]) then
                            npc:facePlayer(player, true)
                            player:delGil(item[3])
                        end
                    end
                end,
            },
        },
    })
end

local function handleEraQuests(player, npc)
    local options = {}

    for _, categoryInfo in pairs(quests) do
        table.insert(options, {
            categoryInfo.name,
            function()
                local stock = {}

                for _, questInfo in pairs(categoryInfo.list) do
                    if player:hasCompletedQuest(categoryInfo.log, questInfo[1]) then
                        table.insert(stock, questInfo[2])
                        table.insert(stock, questInfo[3])
                    end
                end

                if #stock == 0 then
                    cexi.util.dialog(player, { "You haven't completed any eligible quests yet." }, settings.name, { npc = npc })
                    return
                end

                xi.shop.general(player, stock)
            end,
        })
    end

    delaySendMenu(player, {
        title   = "Select Log:",
        options = options,
    })
end

local function handleCustomQuests(player, npc)
    local options = {}

    for _, categoryInfo in pairs(cexi.crystal_warrior.quest_rewards) do
        table.insert(options, {
            categoryInfo.category,
            function()
                local items = {}

                for _, questInfo in pairs(categoryInfo.list) do
                    if
                        (
                            questInfo.var ~= nil and
                            player:getCharVar(questInfo.var[1]) >= questInfo.var[2]
                        )
                        or
                        (
                            questInfo.bit ~= nil and
                            utils.mask.getBit(player:getCharVar(questInfo.bit[1]), questInfo.bit[2])
                        )
                    then
                        if questInfo.cost ~= nil then
                            table.insert(items, { questInfo.name, questInfo.id, questInfo.cost, questInfo.augs })
                        else
                            table.insert(items, { questInfo.name, questInfo.id, 5000, questInfo.augs })
                        end
                    end
                end

                if #items == 0 then
                    cexi.util.dialog(player, { "You haven't completed any eligible quests yet." }, settings.name, { npc = npc })
                    return
                end

                cexi.util.simpleShop(player, npc, items, confirmPurchase, "Select an item:")
            end,
        })
    end

    delaySendMenu(player, {
        title   = "Select Category:",
        options = options,
    })
end

local function onTrigger(player, npc)
    if
        not player:isCrystalWarrior() or
        player:getCharVar(settings.var) == 0
    then
        cexi.util.dialog(player, settings.dialog.LOCKED, settings.name, { npc = npc })
        return
    end

    delaySendMenu(player, {
        title   = "How can I help?",
        options =
        {
            {
                "Era Quests",
                function()
                    handleEraQuests(player, npc)
                end,
            },
            {
                "Crystal Warrior",
                function()
                    handleCustomQuests(player, npc)
                end,
            },
        },
    })
end

cexi.util.liveReload(m, {
    ["Upper_Jeuno"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = settings.name,
            look      = settings.look,
            x         = settings.pos[1],
            y         = settings.pos[2],
            z         = settings.pos[3],
            rotation  = settings.pos[4],
            onTrigger = onTrigger,
        }
    }
})

return m
