-----------------------------------
-- Crystal Crunch
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("crystal_crunch")

local varName   = "CrystalCruncher"
local npcName   = "Crystal Crunch"
local modelID   = 2421
local locations =
{
    ["Southern_San_dOria"] = { -183.646, -8.800,   31.977, 0 },
    ["Northern_San_dOria"] = { -151.874, 12.000,  188.132, 0 },
    ["Bastok_Mines"]       = { 75.097,    7.000,    3.150, 0 },
    ["Bastok_Markets"]     = { -219.068, -6.000,  -68.635, 0 },
    ["Windurst_Waters"]    = { -91.032,  -2.000,   47.544, 0 },
    ["Windurst_Woods"]     = { -54.120,  -0.981, -108.574, 0 },
}

local trades =
{
    [xi.item.FIRE_CRYSTAL]      = { "Fire",               1 },
    [xi.item.ICE_CRYSTAL]       = { "Ice",                1 },
    [xi.item.WIND_CRYSTAL]      = { "Wind",               1 },
    [xi.item.EARTH_CRYSTAL]     = { "Earth",              1 },
    [xi.item.LIGHTNING_CRYSTAL] = { "Lightning",          1 },
    [xi.item.WATER_CRYSTAL]     = { "Water",              1 },
    [xi.item.LIGHT_CRYSTAL]     = { "Light",              1 },
    [xi.item.DARK_CRYSTAL]      = { "Dark",               1 },
    [xi.item.FIRE_CLUSTER]      = { "Fire Cluster",      12 },
    [xi.item.ICE_CLUSTER]       = { "Ice Cluster",       12 },
    [xi.item.WIND_CLUSTER]      = { "Wind Cluster",      12 },
    [xi.item.EARTH_CLUSTER]     = { "Earth Cluster",     12 },
    [xi.item.LIGHTNING_CLUSTER] = { "Lightning Cluster", 12 },
    [xi.item.WATER_CLUSTER]     = { "Water Cluster",     12 },
    [xi.item.LIGHT_CLUSTER]     = { "Light Cluster",     12 },
    [xi.item.DARK_CLUSTER]      = { "Dark Cluster",      12 },
}

local function onCrunchTrade(player, npc, trade)
    local balance  = player:getCharVar(varName)
    local lastSlot = trade:getSlotCount() - 1

    for i = 0, lastSlot do
        if trades[trade:getItemId(i)] == nil then
            player:printToPlayer("This item cannot be processed.", xi.msg.channel.NS_SAY)
            return
        end
    end

    local totalTraded = 0

    for i = 0, lastSlot do
        local itemID  = trade:getItemId(i)
        local itemQty = trade:getSlotQty(i)
        totalTraded   = totalTraded + (trades[itemID][2] * itemQty)
    end

    player:tradeComplete()
    player:ceEmote(player, xi.emote.TOSS, xi.emoteMode.MOTION)
    npc:ceAnimate(player, player, 37, 4)

    player:setCharVar(varName, balance + totalTraded)
    player:printToPlayer(string.format("throws %u crystals into the void. (Total: %u)", totalTraded, balance + totalTraded), xi.msg.channel.EMOTION)
end

local function onCrunchTrigger(player, npc)
    local storedCrystals   = player:getCharVar(varName)
    local eligibleCrystals = math.floor(storedCrystals / 3 )

    player:printToPlayer("Ominous Voice : I will convert your crystals to any type. (3 for 1)", xi.msg.channel.NS_SAY)

    if storedCrystals < 3 then
        player:printToPlayer(" You don't have enough crystals stored. (3 minimum)", xi.msg.channel.NS_SAY)
        return
    end

    local options = {}

    for i = xi.item.FIRE_CRYSTAL, xi.item.DARK_CRYSTAL do
        table.insert(options, {
            trades[i][1],
            function(playerArg)
                if npcUtil.giveItem(playerArg, { { i, eligibleCrystals } }) then
                    playerArg:printToPlayer("Ominous Voice : Take your crystals and get outta here!", xi.msg.channel.NS_SAY)
                    playerArg:setCharVar("CrystalCruncher", storedCrystals % 3)
                end
            end,
        })
    end

    player:customMenu({
        title   = string.format("Receive %u crystals of which type?", eligibleCrystals),
        options = options,
    })
end

local entities = {}

for zoneName, pos in pairs(locations) do
    if entities[zoneName] == nil then
        entities[zoneName] = {}
    end

    table.insert(entities[zoneName], {
        name       = npcName,
        objtype    = xi.objType.NPC,
        look       = modelID,
        x          = pos[1],
        y          = pos[2],
        z          = pos[3],
        rotation   = pos[4],
        onTrade    = onCrunchTrade,
        onTrigger  = onCrunchTrigger,
    })
end

cexi.util.liveReload(m, entities)

return m
