-----------------------------------
-- Buruko
-----------------------------------
-- Grants additional Blue Magic Points
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new('buruko')

local settings =
{
    name  = "Buruko",
}

local blueSpells =
{
    xi.magic.spell.VENOM_SHELL,
    xi.magic.spell.MAELSTROM,
    xi.magic.spell.METALLIC_BODY,
    xi.magic.spell.SCREWDRIVER,
    xi.magic.spell.MP_DRAINKISS,
    xi.magic.spell.DEATH_RAY,
    xi.magic.spell.SANDSPIN,
    xi.magic.spell.SMITE_OF_RAGE,
    xi.magic.spell.BLUDGEON,
    xi.magic.spell.REFUELING,
    xi.magic.spell.ICE_BREAK,
    xi.magic.spell.BLITZSTRAHL,
    xi.magic.spell.SELF_DESTRUCT,
    xi.magic.spell.MYSTERIOUS_LIGHT,
    xi.magic.spell.COLD_WAVE,
    xi.magic.spell.POISON_BREATH,
    xi.magic.spell.STINKING_GAS,
    xi.magic.spell.MEMENTO_MORI,
    xi.magic.spell.TERROR_TOUCH,
    xi.magic.spell.SPINAL_CLEAVE,
    xi.magic.spell.BLOOD_SABER,
    xi.magic.spell.DIGEST,
    xi.magic.spell.MANDIBULAR_BITE,
    xi.magic.spell.CURSED_SPHERE,
    xi.magic.spell.SICKLE_SLASH,
    xi.magic.spell.COCOON,
    xi.magic.spell.FILAMENTED_HOLD,
    xi.magic.spell.POLLEN,
    xi.magic.spell.POWER_ATTACK,
    xi.magic.spell.DEATH_SCISSORS,
    xi.magic.spell.MAGNETITE_CLOUD,
    xi.magic.spell.EYES_ON_ME,
    xi.magic.spell.FRENETIC_RIP,
    xi.magic.spell.FRIGHTFUL_ROAR,
    xi.magic.spell.HECATOMB_WAVE,
    xi.magic.spell.BODY_SLAM,
    xi.magic.spell.RADIANT_BREATH,
    xi.magic.spell.HELLDIVE,
    xi.magic.spell.JET_STREAM,
    xi.magic.spell.BLOOD_DRAIN,
    xi.magic.spell.SOUND_BLAST,
    xi.magic.spell.FEATHER_TICKLE,
    xi.magic.spell.FEATHER_BARRIER,
    xi.magic.spell.JETTATURA,
    xi.magic.spell.YAWN,
    xi.magic.spell.FOOT_KICK,
    xi.magic.spell.WILD_CARROT,
    xi.magic.spell.VORACIOUS_TRUNK,
    xi.magic.spell.HEALING_BREEZE,
    xi.magic.spell.CHAOTIC_EYE,
    xi.magic.spell.SHEEP_SONG,
    xi.magic.spell.RAM_CHARGE,
    xi.magic.spell.CLAW_CYCLONE,
    xi.magic.spell.LOWING,
    xi.magic.spell.DIMENSIONAL_DEATH,
    xi.magic.spell.HEAT_BREATH,
    xi.magic.spell.BLANK_GAZE,
    xi.magic.spell.MAGIC_FRUIT,
    xi.magic.spell.UPPERCUT,
    xi.magic.spell.THOUSAND_NEEDLES,
    xi.magic.spell.PINECONE_BOMB,
    xi.magic.spell.SPROUT_SMACK,
    xi.magic.spell.SOPORIFIC,
    xi.magic.spell.QUEASYSHROOM,
    xi.magic.spell.WILD_OATS,
    xi.magic.spell.BAD_BREATH,
    xi.magic.spell.GEIST_WALL,
    xi.magic.spell.AWFUL_EYE,
    xi.magic.spell.FROST_BREATH,
    xi.magic.spell.INFRASONICS,
    xi.magic.spell.DISSEVERMENT,
    xi.magic.spell.ACTINIC_BURST,
    xi.magic.spell.REACTOR_COOL,
    xi.magic.spell.SALINE_COAT,
    xi.magic.spell.PLASMA_CHARGE,
    xi.magic.spell.TEMPORAL_SHIFT,
    xi.magic.spell.VERTICAL_CLEAVE,
    xi.magic.spell.BLASTBOMB,
    xi.magic.spell.BATTLE_DANCE,
    xi.magic.spell.SANDSPRAY,
    xi.magic.spell.GRAND_SLAM,
    xi.magic.spell.HEAD_BUTT,
    xi.magic.spell.BOMB_TOSS,
    xi.magic.spell.FRYPAN,
    xi.magic.spell.FLYING_HIP_PRESS,
    xi.magic.spell.HYDRO_SHOT,
    xi.magic.spell.DIAMONDHIDE,
    xi.magic.spell.ENERVATION,
    xi.magic.spell.LIGHT_OF_PENANCE,
    xi.magic.spell.WARM_UP,
    xi.magic.spell.FIRESPIT,
    xi.magic.spell.FEATHER_STORM,
    xi.magic.spell.TAIL_SLAP,
    xi.magic.spell.HYSTERIC_BARRAGE,
    xi.magic.spell.AMPLIFICATION,
    xi.magic.spell.CANNONBALL,
    xi.magic.spell.MIND_BLAST,
    xi.magic.spell.EXUVIATION,
    xi.magic.spell.MAGIC_HAMMER,
    xi.magic.spell.ZEPHYR_MANTLE,
    xi.magic.spell.REGURGITATION,
    xi.magic.spell.SEEDSPRAY,
    xi.magic.spell.CORROSIVE_OOZE,
    xi.magic.spell.SPIRAL_SPIN,
    xi.magic.spell.ASURAN_CLAWS,
    xi.magic.spell.SUB_ZERO_SMASH,
    xi.magic.spell.TRIUMPHANT_ROAR,
    xi.magic.spell.ACRID_STREAM,
    xi.magic.spell.BLAZING_BOUND,
    xi.magic.spell.PLENILUNE_EMBRACE,
    xi.magic.spell.DEMORALIZING_ROAR,
    xi.magic.spell.ANIMATING_WAIL,
    xi.magic.spell.BATTERY_CHARGE,
    xi.magic.spell.MAGIC_BARRIER,
    xi.magic.spell.OSMOSIS,
    xi.magic.spell.QUADRATIC_CONTINUUM,
    xi.magic.spell.EMPTY_THRASH,
    xi.magic.spell.OCCULTATION,
    xi.magic.spell.BARRIER_TUSK,
    xi.magic.spell.HEAVY_STRIKE,
    xi.magic.spell.ORCISH_COUNTERSTANCE,
    xi.magic.spell.BARBED_CRESCENT,
    xi.magic.spell.GLUTINOUS_DART,
    xi.magic.spell.THRASHING_ASSAULT,
    xi.magic.spell.SEARING_TEMPEST,
    xi.magic.spell.SPECTRAL_FLOE,
    xi.magic.spell.ANVIL_LIGHTNING,
    xi.magic.spell.ENTOMB,
    xi.magic.spell.BLINDING_FULGOR,
    xi.magic.spell.SCOURING_SPATE,
    xi.magic.spell.SILENT_STORM,
    xi.magic.spell.TENEBRAL_CRUSH,
    xi.magic.spell.HARDEN_SHELL,
    xi.magic.spell.PYRIC_BULWARK,
    xi.magic.spell.CARCHARIAN_VERVE
}

local function onTrigger(player, npc)
    npc:facePlayer(player, true)

    -- Only for BLU's that have reached 75 with merits unlocked (because this is attached to the merit packet)
    if player:getMainJob() == xi.job.BLU and player:getMainLvl() == 75 and player:hasKeyItem(xi.ki.LIMIT_BREAKER) then
        local learned = 0
        local extraPoints = 0
        local divisor = #blueSpells / 25.0

        -- Count how many spells they've learned total
        for i = 1, #blueSpells do
            if player:hasSpell(blueSpells[i]) then
                learned = learned + 1
            end
        end

        -- Give extra points depending on how many spells they've learned (out of 25 max possible points)
        extraPoints = math.floor(learned / divisor)
        
        -- Just in case (GM's with !addallspells, etc..)
        if extraPoints > 25 then
            extraPoints = 25
        end

        player:fmt("{} : Congratulations, {}! You\'ve learned {} Blue Magic spells so far, you have earned {} extra Blue Magic Points!", settings.name, player:getName(), learned, extraPoints)
        player:setCharVar('[BLU]Blue_Points', extraPoints)
    else
        player:fmt("{} : Be on your way, adventurer!", settings.name)
    end
end

cexi.util.liveReload(m, {
    ["Aht_Urhgan_Whitegate"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = string.char(0xAA) .. settings.name,
            look      = cexi.util.look({
                race  = xi.race.TARU_M,
                face  = cexi.face.B4,
                head  = cexi.model.BLUE_MAGE_RELIC,
                body  = cexi.model.BLUE_MAGE_RELIC,
                hand  = cexi.model.BLUE_MAGE_RELIC,
                legs  = cexi.model.BLUE_MAGE_RELIC,
                feet  = cexi.model.BLUE_MAGE_RELIC,
                main  = 419,
                offh  = 419,
                }),
            x         = 71.3237,
            y         = -6.0000,
            z         = -67.2878,
            rotation  = 88,
            widescan  = 1,
            onTrigger = onTrigger,
        }
    }
})

return m
