-----------------------------------
-- Delivery Assistant
-----------------------------------
-- Delivers items to adventurers
-- Also allows players to redeem Cosmetic Coupons
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/shop")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("npc-assistant")

local settings =
{
    name  = "Assistant",
    slots = 4,
}

local vars =
{
   item  = "[DELIVERY]SLOT_%u",
   qty   = "[DELIVERY]SLOT_%u_QTY",
   aug   = "[DELIVERY]SLOT_%u_AUG",
   trade = "[DELIVERY]SLOT_%u_TRADE",
}

local function onTrigger(player, npc)
    npc:facePlayer(player, true)

    -- Give players missing Sowilo Claymore from completing RUN job quest
    if
        player:getCharVar("[CW]RUNIC_INSURRECTION") >= 7 and
        not player:hasItem(20781) and
        player:getCharVar("[DELIVERY]20781") == 0
    then
        if npcUtil.giveItem(player, 20781) then
            player:fmt("{} : This one is addressed to you, {}.", settings.name, player:getName())
            player:incrementCharVar("[DELIVERY]20781", 1)

            return
        end
    end

    -- Give players missing Luopan KI from completing GEO job quest
    if
        player:getCharVar("[CW]UNNAMED_WAY") >= 7 and
        not player:hasKeyItem(xi.ki.LUOPAN)
    then
        if npcUtil.giveKeyItem(player, xi.ki.LUOPAN) then
            player:fmt("{} : This one is addressed to you, {}.", settings.name, player:getName())
    
            return
        end
    end

    -- Give players pending delivery items
    if player:getFreeSlotsCount() > 0 then
        for slot = 1, settings.slots do
            local varID = string.format(vars.item, slot)
            local item  = player:getCharVar(varID)

            if item > 0 then
                local varQty = string.format(vars.qty, slot)
                local varAug = string.format(vars.aug, slot)
                local qty    = player:getCharVar(varQty)
                local aug    = player:getCharVar(varAug)

                if qty == 0 then
                    qty = 1
                end

                player:fmt("{} : This one is addressed to you, {}.", settings.name, player:getName())

                -- TODO: Add augs (Need new binding for this)
                if npcUtil.giveItem(player, { { item, qty } }) then
                    player:setCharVar(varID,  0)
                    player:setCharVar(varQty, 0)
                    player:setCharVar(varAug, 0)
                end

                return
            end
        end
    end

    player:fmt("{} : I've nothing for you right now, {}.", settings.name, player:getName())
end

local function onTrade(player, npc, trade)
    if cexi.util.tradeHasExactly(player, xi.item.COSMETIC_COUPON) then
        cexi.util.simpleMenu(player, npc, {
            { "Apkallu Scepter",   22043 },
            { "Tengu War Fan",     22044 },
            { "Feline Hagoita",    22046 },
            { "Korrigan Mallet",   22047 },
            { "Addenium Mallet",   22048 },
            { "Citrillus Mallet",  22049 },
            { "Chac-chacs",        22050 },
            { "Lycopodium Mallet", 22051 },
            { "Summer Uchiwa",     22052 },
        }, function(playerArg, npcArg, item)
            if npcUtil.giveItem(playerArg, item[2]) then
                playerArg:tradeComplete()
            end
        end, "Select a reward:")
    end
end

cexi.util.liveReload(m, {
    ["RuLude_Gardens"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = string.char(0xAA) .. settings.name,
            look = cexi.util.look({
                race = xi.race.MITHRA,
                face = A1,
                head = 459, -- Byakko Masque
                body = 309, -- Chocobo Shirt
                hand = cexi.model.WHITE_CLOAK,
                legs = cexi.model.WHITE_CLOAK,
                feet = cexi.model.WHITE_CLOAK,
            }),
            x         = 34.535,
            y         = 0.003,
            z         = -1.366,
            rotation  = 93,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        }
    }
})

return m
