---------------------------------
-- Ruinous Randy: Custom HNM
--  The Eldieme Necropolis [S]
-- !pos 179.982 -0.250 139.973
---------------------------------
require("modules/module_utils")
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------------
local m = Module:new("ruinous_randy")

local bluLook = cexi.util.look({
    race = xi.race.HUME_M,
    face = 29,
    head = 165,
    body = 165,
    hand = 165,
    legs = 165,
    feet = 165,
    main = 375,
})

local bstLook = cexi.util.look({
    race = xi.race.HUME_M,
    face = 29,
    head = 256,
    body = 256,
    hand = 256,
    legs = 256,
    feet = 256,
    main = 347,
})

local mnkLook = cexi.util.look({
    race = xi.race.HUME_M,
    face = 29,
    head = 283,
    body = 283,
    hand = 283,
    legs = 283,
    feet = 283,
    main = 500,
    offh = 500,
})

local buffs =
{
    mods =
    {
        [xi.mod.BLINDRES]        =  100,
        [xi.mod.BINDRES]         =  100,
        [xi.mod.GRAVITYRES]      =  100,
        [xi.mod.SLEEPRES]        =  100,
        [xi.mod.LULLABYRES]      =  100,
        [xi.mod.MDEF]            =   20,
        [xi.mod.MAIN_DMG_RATING] =   50,
        [xi.mod.MATT]            =  150,
        [xi.mod.MACC]            =  450,
        [xi.mod.UFASTCAST]       =  150,
        [xi.mod.REFRESH]         =   50,
        [xi.mod.HPP]             = 1000,
        [xi.mod.MPP]             = 1000,
    },

    mobMods =
    {
        [xi.mobMod.CHECK_AS_NM]  = 1,
        [xi.mobMod.DETECTION]    = 0x006,
    },

    effects =
    {
        [xi.effect.HASTE]  = { 1000, 0, 600 },
        [xi.effect.REGAIN] = {   25, 3,   0 },
    },
}

local raptorBuffs =
{
    mods =
    {
        [xi.mod.BLINDRES]        =  100,
        [xi.mod.GRAVITYRES]      =  100,
        [xi.mod.SLEEPRES]        =  100,
        [xi.mod.LULLABYRES]      =  100,
    },
}

local function applyTemplate(mob, template)
    if template.mods ~= nil then
        for modID, modValue in pairs(template.mods) do
            mob:setMod(modID, modValue)
        end
    end

    if template.effects ~= nil then
        for effectID, effectTable in pairs(template.effects) do
            mob:addStatusEffect(effectID, unpack(effectTable))
        end
    end

    if template.mobMods ~= nil then
        for mobMod, value in pairs(template.mobMods) do
            mob:setMobMod(mobMod, value)
        end
    end

    mob:updateHealth()
    mob:addHP(mob:getMaxHP())
    mob:addMP(mob:getMaxMP())
end

local function phaseChange(mob, target, phase)
    local phaseOneMob   = GetServerVariable('Ruinous_Randy')
    local phaseTwoMob   = GetMobByID(GetServerVariable('Ruinous_Randy_2'))
    local phaseTwoPet   = GetMobByID(GetServerVariable('Ruinous_Randy_Pet'))
    local phaseThreeMob = GetMobByID(GetServerVariable('Ruinous_Randy_3'))

    -- DEBUG
    print('Randy is entering phase: ' .. phase)

    -- enter phase 2
    if phase == 2 then
        DespawnMob(phaseOneMob)
        phaseTwoMob:spawn()
        phaseTwoMob:updateClaim(target)
        phaseTwoMob:setLocalVar('Randy_Phase', 2)
        phaseTwoMob:useMobAbility(624) -- Dust cloud
        phaseTwoMob:setMobMod(xi.mobMod.SKILL_LIST, 5041)
        phaseTwoMob:setMagicCastingEnabled(false)
        phaseTwoPet:setSpawn(phaseTwoMob:getXPos() + 2, phaseTwoMob:getYPos() + 2, phaseTwoMob:getZPos() + 2, phaseTwoMob:getRotPos())

        phaseTwoPet:timer(1000, function(mobArg)
            phaseTwoMob:injectActionPacket(phaseTwoMob:getID(), 6, 83, 0, 0, 0, 0, 0)
            mobArg:spawn()
            mobArg:updateClaim(target)
        end)

        phaseTwoPet:updateClaim(target)

        xi.mix.jobSpecial.config(phaseTwoMob, {
            chance = 100,
            specials =
            {
                { id = xi.jsa.MIGHTY_STRIKES, hpp = 75 },
                { id = xi.jsa.MIGHTY_STRIKES, hpp = 50 },
                { id = xi.jsa.MIGHTY_STRIKES, hpp = 25 },
            },
        })

    -- enter phase 3
    elseif phase == 3 then
        DespawnMob(phaseTwoMob:getID())

        -- Let 'familiar' animation complete prior to despawning
        phaseThreeMob:timer(1000, function(mobArg)
            mobArg:spawn()
            mobArg:updateClaim(target)
            mobArg:setMobMod(xi.mobMod.DRAW_IN, 1)
            mobArg:setLocalVar('Randy_Phase', 3)
            mobArg:setMobMod(xi.mobMod.SKILL_LIST, 5042)
            mobArg:setMagicCastingEnabled(false)

            xi.mix.jobSpecial.config(phaseThreeMob, {
                chance = 100,
                specials =
                {
                    { id = xi.jsa.HUNDRED_FISTS, hpp = 99 },
                    { id = xi.jsa.HUNDRED_FISTS, hpp = 75 },
                    { id = xi.jsa.HUNDRED_FISTS, hpp = 50 },
                    { id = xi.jsa.HUNDRED_FISTS, hpp = 25 },
                },
            })
        end)
    end
end

local bluMagicSkillchain = function(mob, target)
    print('Randy: Ready to start skillchain...')

    mob:setLocalVar('sc_started', 1)
    mob:setMod(xi.mod.DELAY, 0)
    mob:setMobAbilityEnabled(false)
    mob:setMagicCastingEnabled(false)
    mob:setAutoAttackEnabled(false)

    mob:addStatusEffect(xi.effect.CHAIN_AFFINITY, 0, 0, 30)
    mob:injectActionPacket(mob:getID(), 6, 140, 0, 0, 0, 0 ,0)
    mob:timer(2500, function(mobArg)
        mob:useMobAbility(34) -- red lotus blade
    end)

    mob:timer(8000, function(mobArg)
        mobArg:useMobAbility(3994) -- sickle slash
        mob:delStatusEffect(xi.effect.AZURE_LORE)
        mob:delStatusEffect(xi.effect.CHAIN_AFFINITY)
    end)

    mob:timer(9500, function(mobArg)
        mob:setLocalVar('sc_started', 0)
        mob:setMobAbilityEnabled(true)
        mob:setMagicCastingEnabled(true)
        mob:setAutoAttackEnabled(true)
    end)
end

-- Failsafe in case of server crash
m:addOverride("xi.zones.The_Eldieme_Necropolis_[S].Zone.onInitialize", function(zone)
    super(zone)
    SetServerVariable('Ruinous_Randy_Spawned', 0)
end)

m:addOverride("xi.zones.The_Eldieme_Necropolis_[S].Zone.onZoneTick", function(zone)
    super(zone)

    if
        GetServerVariable('Ruinous_Randy_POP') <= os.time() and
        GetServerVariable('Ruinous_Randy_Spawned') == 0
    then
        -- Phase One
        local phaseOneMob = zone:insertDynamicEntity({
            objtype = xi.objType.MOB,
            name = 'Ruinous Randy',
            look = bluLook,
            x = 179.982,
            y = -0.250,
            z = 139.973,
            rotation = 193,
            groupId  = 27,
            groupZoneId = 51,

            onMobSpawn = function(mob)
                -- disappear the planar rift in the middle of the room
                GetNPCByID(17494791):setStatus(xi.status.DISAPPEAR)

                mob:setMobLevel(85)
                mob:setLocalVar('Randy_Phase', 1)
                mob:setLocalVar('sc_ready', 1)
                -- Use only BLU magic spells
                mob:setMobMod(xi.mobMod.SKILL_LIST, 0)
                mob:setUnkillable(true)
                applyTemplate(mob, buffs)
            end,

            onMobFight = function(mob, target)
                local act          = mob:getCurrentAction()
                local mobHPP       = mob:getHPP()
                local phase        = mob:getLocalVar('Randy_Phase')
                local isBusy       = false
                local currentTime  = os.time()

                if
                    act == xi.act.MOBABILITY_START or
                    act == xi.act.MOBABILITY_USING or
                    act == xi.act.MOBABILITY_FINISH
                then
                    isBusy = true
                end

                -- try to keep cocoon up
                if
                    currentTime >= mob:getLocalVar('Cocoon') and
                    not mob:hasStatusEffect(xi.effect.DEFENSE_BOOST) and
                    not isBusy
                then
                    print('Randy: Trying to cast cocoon...')
                    mob:setLocalVar('Cocoon', currentTime + 10)
                    mob:useMobAbility(346)
                end

                -- Take and deal double damage during Azure Lore
                if
                    mob:hasStatusEffect(xi.effect.AZURE_LORE) and
                    mob:getLocalVar('sc_started') ~= 1 and
                    not isBusy
                then
                    mob:setLocalVar('sc_started', 1)
                    bluMagicSkillchain(mob, target)
                end

                --  enter phase 2
                if
                    mobHPP <= 15 and
                    phase == 1
                then
                    mob:useMobAbility(661)
                    phaseChange(mob, target, phase + 1)
                end
            end,

            mixins =
            {
                require('scripts/mixins/job_special'),
            },

            specialSpawnAnimation = true,
        })

        -- Phase Two
        local phaseTwoMob = zone:insertDynamicEntity({
            objtype = xi.objType.MOB,
            name = 'Ruinous Randy_2',
            packetName = 'Ruinous Randy',
            look = bstLook,
            x = phaseOneMob:getXPos(),
            y = phaseOneMob:getYPos(),
            z = phaseOneMob:getZPos(),
            rotation = phaseOneMob:getRotPos(),
            groupId  = 11,
            groupZoneId = 141,

            onMobSpawn = function(mob)
                mob:setMobLevel(90)
                mob:setUnkillable(true)
                mob:setLocalVar('Randy_Phase', 2)
                SetServerVariable('Randy_Pet_Death', 0)
                applyTemplate(mob, buffs)
            end,

            onMobFight = function(mob, target)
                local mobHPP         = mob:getHPP()
                local phase          = mob:getLocalVar('Randy_Phase')
                local isPetAlive     = mob:getLocalVar('Randy_Pet_Spawned')
                local phaseTwoPet    = GetMobByID(GetServerVariable('Ruinous_Randy_Pet'))
                local phaseTwoPetToD = GetServerVariable('Randy_Pet_ToD')
                local currentTime    = os.time()
                local petLvl         = phaseTwoPet:getMainLvl()

                -- apply defense buffs if pet is down.
                if phaseTwoPet:isAlive() then
                    mob:setMod(xi.mod.DEFP, 100)
                    mob:setMod(xi.mod.MDEF, 100)
                else
                    mob:setMod(xi.mod.DEFP, 0)
                    mob:setMod(xi.mod.MDEF, 0)
                end

                -- DEBUG
                -- print('Pet Alive?: ' .. GetServerVariable('Randy_Pet_Spawned') .. ' current time: ' .. currentTime .. ' Pet ToD: ' .. phaseTwoPetToD .. ' Sum : ' .. currentTime - phaseTwoPetToD)

                if
                    GetServerVariable('Randy_Pet_Spawned') == 0 and
                    (currentTime - phaseTwoPetToD) >= 20
                then
                    mob:injectActionPacket(mob:getID(), 6, 83, 0, 0, 0, 0, 0)
                    phaseTwoPet:spawn()
                    SetServerVariable('Randy_Pet_Spawned', 1)
                    phaseTwoPet:setMobLevel(petLvl + 2)
                    phaseTwoPet:addMod(xi.mod.HPP, 500)
                    phaseTwoPet:updateHealth()
                    phaseTwoPet:addHP(phaseTwoPet:getMaxHP())
                    phaseTwoPet:updateClaim(target)

                    phaseTwoPet:timer(1000, function(mobArg)
                        phaseTwoPet:injectActionPacket(phaseTwoPet:getID(), 4, 5000, 0, 0, 0, 0, 0)
                    end)

                    target:printToArea(string.format('%s becomes enraged, gaining additional strength from %s!', phaseTwoPet:getPacketName(), mob:getPacketName()), xi.msg.channel.NS_SHOUT, xi.msg.area.SHOUT)
                    print('DEBUG: Andy\'s Pet has died, respawning at level ' .. (petLvl + 2))
                end

                -- enter phase 3
                if
                    mobHPP <= 15 and
                    phase == 2
                then
                    phase = phase + 1

                    -- prevent this block from running more than once for some reason
                    if
                        phase == 3 and
                        mob:getLocalVar('phase_changed') ~= 1
                    then
                        mob:setLocalVar('phase_changed', 1)
                        mob:injectActionPacket(mob:getID(), 6, 39, 0, 0, 0, 0, 0)
                        mob:timer(500, function(mobArg)
                            phaseTwoPet:setMobLevel(petLvl + 2)
                            phaseChange(mob, target, phase)
                        end)
                    end
                else
                    return
                end
            end,

            onMobRoam = function(mob)
                local phaseOneMob = GetMobByID(GetServerVariable('Ruinous_Randy'))
                local phaseTwoMob = GetMobByID(GetServerVariable('Ruinous_Randy_2'))

                phaseOneMob:spawn()
                DespawnMob(phaseTwoMob)
            end,

            mixins =
            {
                require('scripts/mixins/job_special'),
            },

            specialSpawnAnimation = true,
        })

        -- Phase Two (BST PET)
        local phaseTwoPet = zone:insertDynamicEntity({
            objtype = xi.objType.MOB,
            name = 'Randy\'s Raptor',
            look = '0x0000920700000000000000000000000000000000',
            x = phaseTwoMob:getXPos(),
            y = phaseTwoMob:getYPos(),
            z = phaseTwoMob:getZPos(),
            rotation = phaseTwoMob:getRotPos(),
            groupId  = 31,
            groupZoneId = 265,

            onMobSpawn = function(mob)
                mob:setMobLevel(80)
                applyTemplate(mob, raptorBuffs)
                SetServerVariable('Randy_Pet_Spawned', 1)
            end,

            onMobFight = function(mob, target)
                local currentTime = os.time()
                local isBusy      = false

                -- fail safe if mob spawns below desired level
                if mob:getMainLvl() < 80 then
                    mob:setMobLevel(80)
                end

                if
                    act == xi.act.MOBABILITY_START or
                    act == xi.act.MOBABILITY_USING or
                    act == xi.act.MOBABILITY_FINISH
                then
                    isBusy = true
                end

                -- spam foul breath
                if
                    currentTime >= mob:getLocalVar('Foul_Breath') and
                    not isBusy
                then
                    mob:setLocalVar('Foul_Breath', currentTime + 20)
                    mob:useMobAbility(376) -- Foul Breath
                end
            end,

            onMobDeath = function(mob, player, optParams)
                SetServerVariable('Randy_Pet_Spawned', 0)
                SetServerVariable('Randy_Pet_ToD', os.time())
                print('Setting ToD variable')
            end,

            onMobRoam = function(mob)
                local phaseTwoMob = GetMobByID(GetServerVariable('Ruinous_Randy_2'))
                if phaseTwoMob:getTarget() ~= nil then
                    print('Randy\'s Raptor has no target, updating...')
                    mob:updateEnmity(phaseTwoMob:getTarget())
                end
            end,
        })

        local phaseThreeMob = zone:insertDynamicEntity({
            objtype = xi.objType.MOB,
            name = 'Ruinous Randy 3',
            packetName = 'Ruinous Randy',
            look = mnkLook,
            x = phaseTwoMob:getXPos(),
            y = phaseTwoMob:getYPos(),
            z = phaseTwoMob:getZPos(),
            rotation = phaseTwoMob:getRotPos(),
            groupId  = 86,
            groupZoneId = 81,

            onMobSpawn = function(mob)
                mob:setMobLevel(95)
                mob:setUnkillable(false)
                mob:setMobMod(xi.mobMod.NO_MOVE, 1)
                mob:setDropID(4098)
                applyTemplate(mob, buffs)
            end,

            onMobFight = function(mob, target)
                local mobHPP   = mob:getHPP()
                local phase    = mob:getLocalVar('Randy_Phase')
                local distance = mob:checkDistance(target)
                local targets  = mob:getEnmityList()

                if
                    distance >= 8 and
                    os.time() > mob:getLocalVar('rangedSkill')
                then
                    print('Randy is drawing in the defenders.')
                    target:printToArea('Ruinous Randy : Coward! Think you can simply run away from me?! Muahahaha!', xi.msg.channel.NS_SHOUT, xi.msg.area.SHOUT)
                    mob:setLocalVar('rangedSkill', os.time() + math.random(15, 22))
                    mob:useMobAbility(3997) -- chi blast

                    for i, v in pairs(targets) do
                        if v.entity:isPC() then
                            v.entity:setPos(mob:getXPos() + math.random(-1, 1), mob:getYPos(), mob:getZPos() + math.random(-1, 1))
                        end
                    end
                end
            end,

            onMobDeath = function(mob, player, optParams)
                -- 21-21.5 hours with 5 minute windows.
                local randomPopTime = (os.time() + 75600) + (math.random(0, 6) * 300)
                SetServerVariable('Ruinous_Randy_POP', randomPopTime)
                SetServerVariable('Ruinous_Randy_Spawned', 0)
                player:addTitle(1115) -- Title: Ruinous Randy
            end,

            onMobRoam = function(mob)
                local phaseOneMob   = GetMobByID(GetServerVariable('Ruinous_Randy'))
                local phaseThreeMob = GetMobByID(GetServerVariable('Ruinous_Randy_3'))

                if phaseOneMob then
                    phaseOneMob:spawn()
                end

                if phaseThreeMob then
                    DespawnMob(phaseThreeMob:getID())
                end
            end,

            mixins =
            {
                require('scripts/mixins/job_special'),
            },

            specialSpawnAnimation = true,
        })

        phaseOneMob:setSpawn(179.982, -0.250, 139.973, 193)
        phaseOneMob:setMobMod(xi.mobMod.NO_DROPS, 1)
        phaseOneMob:setMobMod(xi.mobMod.SPELL_LIST, 896)
        phaseOneMob:setRoamFlags(xi.roamFlag.SCRIPTED)
        phaseOneMob:setSpellList(896)
        phaseOneMob:spawn()

        phaseTwoMob:setSpawn(phaseOneMob:getXPos(), phaseOneMob:getYPos(), phaseOneMob:getZPos(), phaseOneMob:getRotPos())
        phaseTwoMob:setRoamFlags(xi.roamFlag.SCRIPTED)

        phaseThreeMob:setSpawn(phaseTwoMob:getXPos(), phaseTwoMob:getYPos(), phaseTwoMob:getZPos(), phaseTwoMob:getRotPos())
        phaseThreeMob:setRoamFlags(xi.roamFlag.SCRIPTED)

        SetServerVariable('Ruinous_Randy_Spawned', 1)
        SetServerVariable('Ruinous_Randy', phaseOneMob:getID())
        SetServerVariable('Ruinous_Randy_2', phaseTwoMob:getID())
        SetServerVariable('Ruinous_Randy_3', phaseThreeMob:getID())
        SetServerVariable('Ruinous_Randy_Pet', phaseTwoPet:getID())

        xi.mix.jobSpecial.config(phaseOneMob, {
            chance = 100,
            specials =
            {
                { id = xi.jsa.AZURE_LORE, hpp = 75 },
                { id = xi.jsa.AZURE_LORE, hpp = 50 },
                { id = xi.jsa.AZURE_LORE, hpp = 25 },
            },
        })
    end
end)

--
-- Mob Skills
--
local mobSkills =
{
    ['counterstance_randy'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local typeEffect = xi.effect.COUNTERSTANCE
            skill:setMsg(xi.msg.basic.NONE)
            xi.mobskills.mobBuffMove(mob, typeEffect, mob:getMainLvl(), 0, 30)
            mob:setTP(0)
            mob:injectActionPacket(mob:getID(), 6, 8, 0, 0, 100, 40, 1)
            return typeEffect
        end,
    },

    ['chakra_randy'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local chakraStatusEffects =
            {
                POISON       = 0, -- Removed by default
                BLINDNESS    = 0, -- Removed by default
                PARALYSIS    = 1,
                DISEASE      = 2,
                PLAGUE       = 4,
            }

            local recoveryAmount    = math.min(mob:getMaxHP() / 10)

            for k, v in pairs(chakraStatusEffects) do
                mob:delStatusEffect(xi.effect[k])
            end

            mob:addStatusEffect(xi.effect.REGEN, 10, 0, mob:getMainLvl(), 0, 0, 30)
            mob:setTP(0)
            skill:setMsg(xi.msg.basic.NONE)
            mob:injectActionPacket(target:getID(), 6, 6, 0, 0, 102, 38, recoveryAmount)
            return xi.mobskills.mobHealMove(mob, recoveryAmount)
        end,
    },

    ['chi_blast_randy'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local dmg = target:getHP()
            target:setHP(0)
            mob:setTP(0)
            mob:injectActionPacket(target:getID(), 6, 92, 0, 0, 110, 82, dmg)
            skill:setMsg(xi.msg.basic.NONE)
            return dmg
        end,
    },

    ['sickle_slash_randy'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = math.random(2, 4) + math.random()
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.CRIT_VARIES, 1, 1.5, 2)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.NONE)
            mob:injectActionPacket(target:getID(), 4, 698, 0, 24, 2, 545, dmg)
            return dmg
        end,
    },
}

for skillName, skillFunc in pairs(mobSkills) do
    local skillPath = string.format('xi.actions.mobskills.%s', skillName)
    xi.module.ensureTable(skillPath)

    m:addOverride(skillPath .. '.onMobSkillCheck', function(target, mob, skill)
        return 0
    end)

    m:addOverride(skillPath .. '.onMobWeaponSkill', skillFunc.onMobWeaponSkill)
end

return m
