---------------------------------------
-- Adjust respawn timers on NM's in Sky
---------------------------------------
require("modules/module_utils")
require("scripts/globals/mobs")
---------------------------------------

local m = Module:new("nm_respawns")

-- Despot
m:addOverride("xi.zones.RuAun_Gardens.mobs.Groundskeeper.onMobDespawn", function(mob)
    -- TODO this gives double chance at despot pop when past the upstream delay <.<
    super(mob)

    local ID = zones[xi.zone.RUAUN_GARDENS]

    local despotPHTable =
    {
        [ID.mob.DESPOT - 16] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 15] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 14] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 13] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 12] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 11] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 10] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 9 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 8 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 7 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 6 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 5 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 4 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 3 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 2 ] = ID.mob.DESPOT,
        [ID.mob.DESPOT - 1 ] = ID.mob.DESPOT,
    }

    if xi.mob.phOnDespawn(mob, despotPHTable, 5, 3600, { immediate = true }) then -- 1 hour
        local phId = mob:getID()
        local nmId = despotPHTable[phId]

        GetMobByID(nmId):addListener("SPAWN", "PH_VAR", function(m)
            m:setLocalVar("ph", phId)
        end)
    end
end)

-- Faust
m:addOverride("xi.zones.The_Shrine_of_RuAvitau.mobs.Faust.onMobDespawn", function(mob)
    super(mob)

    mob:setRespawnTime(math.random(3600, 5400)) -- respawn 1-1.5 hrs
end)

-- Mother Globe
m:addOverride("xi.zones.The_Shrine_of_RuAvitau.mobs.Mother_Globe.onMobDespawn", function(mob)
    super(mob)

    mob:setRespawnTime(math.random(3600, 5400)) -- respawn 1-1.5 hrs
end)

-- Zipacna
m:addOverride("xi.zones.VeLugannon_Palace.mobs.Zipacna.onMobDespawn", function(mob)
    super(mob)

    mob:setRespawnTime(math.random(3600, 5400)) -- respawn 1-1.5 hrs
end)

-- Steam Cleaner
m:addOverride("xi.zones.VeLugannon_Palace.mobs.Steam_Cleaner.onMobDespawn", function(mob)
    -- Should not super(), maybe this should go in complete overrides?
    SetServerVariable('[POP]SteamCleaner', os.time() + math.random(3600, 5400)) -- respawn 1-1.5 hrs
end)

-----------------------------------
-- Area: Ordelles Caves (193)
--   NM: Morbolger
-----------------------------------

m:addOverride("xi.zones.Ordelles_Caves.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.ORDELLES_CAVES]
    GetMobByID(ID.mob.MORBOLGER):setRespawnTime(math.random(3600, 7200)) -- 1 to 2 hours
end)

m:addOverride("xi.zones.Ordelles_Caves.mobs.Morbolger.onMobDespawn", function(mob)
    super(mob)

    mob:setRespawnTime(math.random(3600, 7200)) -- 1 to 2 hours
end)

-----------------------------------
-- Area: Pashhow Marshlands (109)
--   NM: Bo'Who Warmonger
-----------------------------------

m:addOverride("xi.zones.Pashhow_Marshlands.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.PASHHOW_MARSHLANDS]
    GetMobByID(ID.mob.BOWHO_WARMONGER):setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

m:addOverride("xi.zones.Pashhow_Marshlands.mobs.BoWho_Warmonger.onMobDespawn", function(mob)
    super(mob)

    UpdateNMSpawnPoint(mob:getID()) 
    mob:setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

-----------------------------------
-- Area: Phomiuna Aqueducts (27)
-----------------------------------

--   NM: Tres Duendes

m:addOverride("xi.zones.Phomiuna_Aqueducts.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.PHOMIUNA_AQUEDUCTS]
    GetMobByID(ID.mob.TRES_DUENDES):setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

m:addOverride("xi.zones.Phomiuna_Aqueducts.mobs.Tres_Duendes.onMobDespawn", function(mob)
    super(mob)

    UpdateNMSpawnPoint(mob:getID())
    mob:setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

--   NM: Mahisha

m:addOverride("xi.zones.Phomiuna_Aqueducts.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.PHOMIUNA_AQUEDUCTS]
    GetMobByID(ID.mob.MAHISHA):setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

m:addOverride("xi.zones.Phomiuna_Aqueducts.mobs.Mahisha.onMobDespawn", function(mob)
    super(mob)

    UpdateNMSpawnPoint(mob:getID())
    mob:setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

--   NM: Eba

m:addOverride("xi.zones.Phomiuna_Aqueducts.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.PHOMIUNA_AQUEDUCTS]
    GetMobByID(ID.mob.EBA):setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

m:addOverride("xi.zones.Phomiuna_Aqueducts.mobs.Eba.onMobDespawn", function(mob)
    super(mob)

    UpdateNMSpawnPoint(mob:getID())
    mob:setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours
end)

--   NM: Centurio Xii-I

m:addOverride("xi.zones.Eastern_Altepa_Desert.onInitialize", function(zone)
    super(zone)

    local ID = zones[xi.zone.EASTERN_ALTEPA_DESERT]
    GetMobByID(ID.mob.CENTURIO_XII_I):setRespawnTime(math.random(7200, 10800)) -- 2 to 3 hours after server comes up
end)

m:addOverride("xi.zones.Eastern_Altepa_Desert.mobs.Centurio_XII-I.onMobDespawn", function(mob)
    super(mob)

    UpdateNMSpawnPoint(mob:getID())
    mob:setRespawnTime(math.random(32400, 43200)) -- 9 to 12 hours respawn after despawn
end)

-----------------------------------
-- Area: Dynamis - Jeuno (188)
-----------------------------------
local dynamisJeunoNMs =
{
    "Anvilix_Sootwrists",
    "Blazox_Boneybod",
    "Bootrix_Jaggedelbow",
    "Buffrix_Eargone",
    "Cloktix_Longnail",
    "Distilix_Stickytoes",
    "Elixmix_Hooknose",
    "Eremix_Snottynostril",
    "Hermitrix_Toothrot",
    "Humnox_Drumbelly",
    "Jabbrox_Grannyguise",
    "Jabkix_Pigeonpecs",
    "Karashix_Swollenskull",
    "Kikklix_Longlegs",
    "Lurklox_Dhalmelneck",
    "Mobpix_Mucousmouth",
    "Morgmox_Moldnoggin",
    "Mortilox_Wartpaws",
    "Prowlox_Barrelbelly",
    "Scruffix_Shaggychest",
    "Slystix_Megapeepers",
    "Smeltix_Thickhide",
    "Snypestix_Eaglebeak",
    "Sparkspox_Sweatbrow",
    "Ticktox_Beadyeyes",
    "Trailblix_Goatmug",
    "Tufflix_Loglimbs",
    "Wasabix_Callusdigit",
    "Wyrmwix_Snakespecs",
}

for _, mobName in pairs(dynamisJeunoNMs) do
    m:addOverride(fmt("xi.zones.Dynamis-Jeuno.mobs.{}.onMobDespawn", mobName), function(mob)
        super(mob)

        UpdateNMSpawnPoint(mob:getID())
        mob:setRespawnTime(math.random(7200, 14400)) -- 2 to 4 hours
    end)
end

------------------------------------
-- NM PH Cooldown
------------------------------------

-- Warning: Will overwrite any onMobDespawn fuctions
-- Check these function don't contain anything else first
local mobs =
{

    {
        placeholders   = { "Recluse_Spider" },
        zoneName       = "Kuftal_Tunnel",
        placeholderIDs =
        {
            [zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE + 2] = zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE, -- -20.000 20.000 38.000
            [zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE + 3] = zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE, -- -20.000 21.000 1.000
            [zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE + 4] = zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE, -- -10.000 20.000 14.000
            [zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE + 5] = zones[xi.zone.KUFTAL_TUNNEL].mob.ARACHNE, -- 19.000 20.000 37.000
        },
        percent        = 10,             -- Normally 5%
        cooldown       = utils.hours(3), -- Reduced from 2-8 hours
    },

    {
        placeholders   = { "Tabar_Beak" },
        zoneName       = "Sauromugue_Champaign",
        placeholderIDs =
        {
            [zones[xi.zone.SAUROMUGUE_CHAMPAIGN].mob.DEADLY_DODO - 1] = zones[xi.zone.SAUROMUGUE_CHAMPAIGN].mob.DEADLY_DODO,
            [zones[xi.zone.SAUROMUGUE_CHAMPAIGN].mob.DEADLY_DODO - 2] = zones[xi.zone.SAUROMUGUE_CHAMPAIGN].mob.DEADLY_DODO,
        },
        percent        = 5,                 -- Normally 33% from a copy paste of DSP code. Very incorrect. Made consistent with Nue and retail testimony. Likely was ~5% spawn chance in retail.
        cooldown       = utils.minutes(60), -- No change. This may be 90 minutes in retail, but that testimony may be old as these Brown Belt NMs were updated in respawn. Nue is 1 hour now, for example.
    },

    {
        placeholders   = { "Battrap" },
        zoneName       = "East_Ronfaure_[S]",
        placeholderIDs =
        {
            [zones[xi.zone.EAST_RONFAURE_S].mob.GOBLINTRAP -1] = zones[xi.zone.EAST_RONFAURE_S].mob.GOBLINTRAP,
        },
        percent        = 10,                -- Normally 5%
        cooldown       = utils.minutes(60), -- No Change
    },

    {
        placeholders   = { "Orcish_Fodder" },
        zoneName       = "Fort_Ghelsba",
        placeholderIDs =
        {
            [zones[xi.zone.FORT_GHELSBA].mob.HUNDREDSCAR_HAJWAJ - 5] = zones[xi.zone.FORT_GHELSBA].mob.HUNDREDSCAR_HAJWAJ,
        },
        percent        = 15,                -- Normally 10%
        cooldown       = utils.minutes(60), -- No change
    },

    {
        placeholders   = { "Tundra_Tiger" },
        zoneName       = "Beaucedine_Glacier",
        placeholderIDs =
        {
            [zones[xi.zone.BEAUCEDINE_GLACIER].mob.KIRATA - 2] = zones[xi.zone.BEAUCEDINE_GLACIER].mob.KIRATA, -- 75.797 -0.335 -323.659
            [zones[xi.zone.BEAUCEDINE_GLACIER].mob.KIRATA - 1] = zones[xi.zone.BEAUCEDINE_GLACIER].mob.KIRATA, -- 69.336 -0.234 -276.561
        },
        percent        = 15,             -- Normally 7%
        cooldown       = utils.hours(2), -- Previousy 1-8 hours
    },

    {
        placeholders   = { "Tundra_Tiger" },
        zoneName       = "Beaucedine_Glacier",
        placeholderIDs =
        {
            [zones[xi.zone.BEAUCEDINE_GLACIER].mob.NUE - 2] = zones[xi.zone.BEAUCEDINE_GLACIER].mob.NUE, -- -342.830 -100.584 168.662
            [zones[xi.zone.BEAUCEDINE_GLACIER].mob.NUE - 1] = zones[xi.zone.BEAUCEDINE_GLACIER].mob.NUE, -- -322.000 -100.000 116.000
        },
        percent        = 10,                -- Normally 7%
        cooldown       = utils.minutes(60), -- Previousy 1-2 hours
    },

    {
        placeholders   = { "Birdtrap" },
        zoneName       = "Carpenters_Landing",
        placeholderIDs =
        {
            [zones[xi.zone.CARPENTERS_LANDING].mob.ORCTRAP - 1] = zones[xi.zone.CARPENTERS_LANDING].mob.ORCTRAP,
        },
        percent        = 15,                -- Normally 10%
        cooldown       = utils.minutes(60), -- No Change
    },

    {
        placeholders   = { "Doom_Warlock" },
        zoneName       = "Gustav_Tunnel",
        placeholderIDs =
        {
            [zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM - 11] = zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM, -- -172.941 -1.220 55.577
            [zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM - 4]  = zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM, -- -137.334 -0.108 48.105
            [zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM - 3]  = zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM, -- -118.000 -0.515 79.000
            [zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM + 2]  = zones[xi.zone.GUSTAV_TUNNEL].mob.TAXIM, -- -125.000 0.635 59.000
        },
        percent        = 10,                 -- Normally 5%
        cooldown       = utils.minutes(120), -- No change
    },

    {
        placeholders   = { "Typhoon_Wyvern" },
        zoneName       = "Gustav_Tunnel",
        placeholderIDs =
        {
            [zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR - 1]  = zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR, -- -316.000 -9.000 3.000
            [zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR + 3]  = zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR, -- -277.000 -10.000 -34.000
            [zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR + 9]  = zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR, -- -242.000 -0.577 120.000
            [zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR + 29] = zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR, -- -123.856 0.239 223.303
            [zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR + 37] = zones[xi.zone.GUSTAV_TUNNEL].mob.UNGUR, -- -242.000 -0.577 120.000
        },
        percent        = 10,                 -- Normally 5%, Clopedia states 15% chance, but the respawn of the mobs was also reduced by 11 minutes since then on retail/LSB.
        cooldown       = utils.minutes(120), -- No change
    },

    {
        placeholders   = { "Demonic_Rose" },
        zoneName       = "The_Boyahda_Tree",
        placeholderIDs =
        {
            [zones[xi.zone.THE_BOYAHDA_TREE].mob.VOLUPTUOUS_VIVIAN - 1] = zones[xi.zone.THE_BOYAHDA_TREE].mob.VOLUPTUOUS_VIVIAN,
        },
        percent        = 10,             -- No change
        cooldown       = utils.hours(8), -- LSB has it at 16-24, it should only be 16. Set to 8 because it is a daily and the drop rates suck.
    },

    {
        placeholders   = { "Lesser_Colibri" },
        zoneName       = "Wajaom_Woodlands",
        placeholderIDs =
        {
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 6] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 181.000 -18.000 -63.000
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 5] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 181.000 -19.000 -77.000
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 4] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 195.000 -18.000 -95.000
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 3] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 220.000 -19.000 -80.000
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 2] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 219.000 -18.000 -59.000
            [zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA - 1] = zones[xi.zone.WAJAOM_WOODLANDS].mob.ZORAAL_JA_S_PKUUCHA, -- 203.000 -16.000 -74.000
        },
        percent        = 5,                 -- No change, there are 6 PHs, 5% is fine
        cooldown       = utils.minutes(90), -- Reduced from 30 minutes - 12 hours to 1.5 hours
    },

}

------------------------------------
-- Examples
------------------------------------

-- For NM with multiple PHs
--    {
--        placeholders   = { "Greater_Pugil", "Snipper" },
--        zoneName       = "Qufim_Island",
--        placeholderIDs = "ANOTHER_PH",
--        percent        = 15,
--        cooldown       = utils.minutes(30),  -- can also use utils.hours(1) etc, but no decimal points
--    },

-- For setting a variable cooldown (no evidence this exists in retail, but it is an option for us)
--    {
--        placeholders   = { "Greater_Pugil", "Snipper" },
--        zoneName       = "Qufim_Island",
--        placeholderIDs = "ANOTHER_PH",
--        percent        = 15,
--        cooldown       = { utils.minutes(30), utils.minutes(120) },
--    },

for _, mobInfo in pairs(mobs) do
    for _, phName in pairs(mobInfo.placeholders) do
        m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDespawn", mobInfo.zoneName, phName), function(mob)
            local ID       = zones[mob:getZoneID()]
            local cooldown = mobInfo.cooldown

            if type(cooldown) == "table" then
                cooldown = math.random(cooldown[1], cooldown[2])
            end

            print(mobInfo.placeholderIDs)
            xi.mob.phOnDespawn(mob, mobInfo.placeholderIDs, mobInfo.percent, cooldown)

            if callback ~= nil then
                callback(mob)
            end
        end)
    end
end

-- Generic incremental increase in PH chance to pop an NM
-- When a PH despawns, this function is called
-- If the NM is not up or already flagged to be up, a counter is attached to the NM and the chance variable is multiplied by a number between 1 and 2
-- the multiplier is based on number of PHs killed divided by the total number of PHs for the NM
m:addOverride('xi.mob.phOnDespawn', function(ph, phList, chance, cooldown, params)
    --print(phList)

    local phId = ph:getID()
    local nmId = phList[phId]

    -- so these stay in scope for second half after super
    local nm = nil
    local phKills = nil
    if nmId and chance then
        nm = GetMobByID(nmId)
        if nm then
            phKills = nm:getLocalVar('phKills')
            if phKills < 0 then
                phKills = 0
            end

            local phCount = 0
            for _, _ in pairs(phList) do
                phCount = phCount + 1
            end

            if phCount < 1 then
                phCount = 1
            end

            -- formula to translate ph kills to nm pop chance is -1/x shape with horizontal asymptote at y=2 that fits these two points
            -- full ph rounds: 0
            -- chance mult: 1
            -- full ph rounds: 20
            -- chance mult: 1.9
            local phRounds = phKills / phCount
            local chanceMult = 2 - (10 / (phRounds + 10))

            chance = chance * chanceMult
            -- print(string.format('ph kills: %d # of ph: %d ph rounds: %f chance mult: %f new chance: %f', phKills, phCount, phRounds, chanceMult))
        end
    end

    super(ph, phList, chance, cooldown, params)

    if nm then
        if nm:isAlive() or nm:getRespawnTime() > 0 then
            -- NM is up or going to spawn, reset kill count
            nm:setLocalVar('phKills', 0)
        else
            nm:setLocalVar('phKills', phKills + 1)
        end

        -- print(nm:getLocalVar('phKills'))
    end
end)

return m
