-- Adjusts mob astral flow to have slightly lower base damage as well as adjust based on dINT
-- LSB lua use base damage as weapondamage * 9 and dmgmod as 3
-- in mobMagicalMove, the results of the resist are then simply multiplied by damage and dmgmod, which means the upstream functions always return
-- weapondamage * 27 as the base damage for the skills, we need to scale that based on the results from https://gitlab.com/ffxiwings/wings/-/merge_requests/480/diffs
-- i.e. we need damage * dmgmod = damage * 1 = (48 + (level * 8) + (dINT * 1.5)) to be the same as (weapondamage * 27)
-- so we need to need to get the result of the mobskill, then remove weapondamage * 27 (via division) and multiple by the left side instead
-- can't just call super() because it has target:takeDamage built in :(
    -- TODO rebuilt the logic here but we need to push changes upstream and remove this override to avoid technical debt
-------------------------------------
require("modules/module_utils")
-------------------------------------

local m = Module:new("mob_astral_flow")

local flows = {
    { "aerial_blast",    xi.element.WIND,    xi.damageType.WIND },
    { "diamond_dust",    xi.element.ICE,     xi.damageType.ICE },
    { "earthen_fury",    xi.element.EARTH,   xi.damageType.EARTH },
    { "howling_moon",    xi.element.DARK,    xi.damageType.DARK },
    { "inferno",         xi.element.FIRE,    xi.damageType.FIRE },
    { "judgment_bolt",   xi.element.THUNDER, xi.damageType.THUNDER },
    { "searing_light",   xi.element.LIGHT,   xi.damageType.LIGHT },
    { "tidal_wave",      xi.element.WATER,   xi.damageType.WATER },
}

for _, flow in ipairs(flows) do
    local skillBase = "xi.actions.mobskills." .. flow[1]
    m:addOverride(skillBase .. ".onMobWeaponSkill", function(target, mob, skill)
        local ele = flow[2]
        local dmgType = flow[3]
        local dINT = math.floor(mob:getStat(xi.mod.INT) - target:getStat(xi.mod.INT))
        local level = mob:getMainLvl()
        local baseDamage = 48 + (level * 8)
        baseDamage = baseDamage + (dINT * 1.5)

        local dmgmod = 1
        local info   = xi.mobskills.mobMagicalMove(mob, target, skill, baseDamage, ele, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1)
        local dmg    = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, dmgType, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, dmgType)

        return dmg
    end)
end

return m
