---------------------------------------
-- Spawn conditions for Lamia No.19
---------------------------------------
require("modules/module_utils")
---------------------------------------

local m = Module:new("amphiptere_pathing")

local paths = {
    [xi.zone.XARCABARD_S] =
    {
        {
            { x = 205,    y = -30, z = -211, },
            { x = 154,    y = -30, z = -187, },
            { x = 105,    y = -30, z = -158, },
            { x = 50,     y = -30, z = -111, },
            { x = 12,     y = -30, z = -110, },
            { x = -22,    y = -30, z = -130, },
            { x = -40,    y = -30, z = -80, },
            { x = 60,     y = -30, z = -62, },
            { x = 134,    y = -30, z = -72, },
            { x = 181,    y = -30, z = -157, },
        },
        {
            { x = 327,    y = -30, z = 206, },
            { x = 303,    y = -30, z = -88, },
            { x = 360,    y = -30, z = -63, },
            { x = 461,    y = -30, z = 67, },
            { x = 389,    y = -30, z = -87, },
            { x = 424,    y = -30, z = -186, },
            { x = 342,    y = -30, z = -275, },
            { x = 246,    y = -30, z = -216, },
        },
        {
            { x = -299,   y = -35, z = -18, },
            { x = -292,   y = -35, z = 117, },
            { x = -181,   y = -35, z = 108, },
            { x = -196,   y = -35, z = -63, },
            { x = -257,   y = -35, z = -118, },
            { x = -278,   y = -35, z = -50, },
            { x = -291,   y = -35, z = 10, },
            { x = -315,   y = -35, z = -63, },
            { x = -330,   y = -35, z = -10, },
            { x = -382,   y = -35, z = 22, },
        },
    },
    [xi.zone.BEAUCEDINE_GLACIER_S] =
    {
        {
            { x = 366.0043, y = 1.0748, z = -58.0706, },
            { x = 366.1845, y = 0.4544, z = -13.2440, },
            { x = 393.5511, y = 0.0876, z = 32.2480, },
            { x = 322.7801, y = 0.0000, z = 38.6412, },
            { x = 282.5068, y = 0.6090, z = 65.8681, },
            { x = 264.4459, y = 0.1098, z = 13.3128, },
            { x = 231.3767, y = 0.2301, z = -34.6820, },
            { x = 254.0005, y = 0.1057, z = -69.1043, },
            { x = 312.0937, y = 0.1943, z = -83.1681, },
            { x = 319.2151, y = 0.0000, z = -118.8754, },
            { x = 313.1806, y = 0.1750, z = -195.2780, },
            { x = 278.5095, y = 0.3467, z = -210.9553, },
            { x = 326.7751, y = 0.1376, z = -240.0246, },
            { x = 394.7690, y = 0.9297, z = -260.1292, },
            { x = 404.8153, y = 0.2765, z = -209.5500, },
        },
        {
            { x = 165.8463, y = -19.9085, z = -78.0939, },
            { x = 236.0462, y = -20.0034, z = -119.1444, },
            { x = 287.9781, y = -19.6542, z = -133.5177, },
            { x = 271.5705, y = -19.7059, z = -167.7742, },
            { x = 231.1563, y = -20.1120, z = -157.6878, },
            { x = 172.8268, y = -19.7085, z = -126.8569, },
            { x = 87.3615, y = -19.8330, z = -162.0752, },
            { x = -5.8592, y = -19.8000, z = -271.9357, },
            { x = 77.2337, y = -19.5006, z = -226.9628, },
            { x = 119.6541, y = -19.6030, z = -267.9883, },
            { x = 154.3755, y = -20.0080, z = -234.2573, },
            { x = 124.2630, y = -20.0000, z = -197.2516, },
            { x = 56.8569, y = -19.1582, z = -196.7629, },
            { x = 67.2848, y = -19.5327, z = -159.2125, },
            { x = 181.8807, y = -19.2558, z = -125.4128, },
        },
        {
            { x = -82.5252, y = -100.0000, z = -41.8832, },
            { x = -54.4466, y = -99.3595, z = 39.8918, },
            { x = -80.9089, y = -100.2449, z = 49.9068, },
            { x = -92.7511, y = -100.1387, z = 16.8369, },
            { x = -160.7729, y = -100.0000, z = 3.1523, },
            { x = -212.6302, y = -99.5416, z = 38.4748, },
            { x = -248.0788, y = -99.6286, z = 24.1251, },
            { x = -230.8701, y = -99.9628, z = -5.5863, },
            { x = -201.7722, y = -99.5294, z = -27.2520, },
            { x = -166.4849, y = -99.2292, z = -20.8014, },
            { x = -142.7036, y = -99.3171, z = -85.1290, },
        },
    }
}

function setPatrol(mob)
    local mobID = mob:getID()
    local mobZone = mob:getZone()
    local mobTable = mobZone:queryEntitiesByName(mob:getName())
    local lesserMobIDCount = 0
    local zonePaths = paths[mobZone:getID()]
    local chosenPath = zonePaths[math.random(#paths)]

    if #mobTable >= 2 then
        for _, tempMob in pairs(mobTable) do
            if tempMob:getID() < mobID then
                lesserMobIDCount = lesserMobIDCount + 1
            end
        end
    end

    -- choose path in order of increasing mobID, but don't hardcode IDs for obvious reasons
    if lesserMobIDCount == 0 then
        chosenPath = zonePaths[1]
    elseif lesserMobIDCount == 1 then
        chosenPath = zonePaths[2]
    else
        chosenPath = zonePaths[3]
    end

    mob:setPos(chosenPath[1])
    mob:pathThrough(chosenPath, xi.path.flag.PATROL)
end

m:addOverride("xi.zones.Xarcabard_[S].mobs.Greater_Amphiptere.onMobSpawn", function(mob)
    super(mob)

    setPatrol(mob)
end)


m:addOverride("xi.zones.Beaucedine_Glacier_[S].mobs.Amphiptere.onMobSpawn", function(mob)
    super(mob)

    setPatrol(mob)
end)

return m
