-------------------------------------------------
-- Overrides/Fixes for WOTG Missions
-------------------------------------------------
require('modules/module_utils')
require('scripts/globals/utils')
require('scripts/globals/interaction/interaction_global')
-----------------------------------
local m = Module:new('wotg_missions')

m:addOverride('xi.server.onServerStart', function()
    super()

    xi.module.modifyInteractionEntry('scripts/missions/wotg/04_The_Queen_of_the_Dance', function(mission)
        -- This section handles the rest of the mission: status 2+
        mission.sections[3].check = function(player, currentMission, missionStatus, vars)
            return currentMission == mission.missionId and missionStatus >= 2
        end

        -- mission:progressEvent doesn't seem to work properly, but returning the csid works just fine
        mission.sections[3][xi.zone.SOUTHERN_SAN_DORIA_S].onZoneIn =
        {
            function(player, prevZone)
                local missionStatus = player:getMissionStatus(mission.areaId)

                if missionStatus == 3 then
                    return 152
                elseif missionStatus == 4 then
                    return 153
                end
            end,
        }
    end)
end)

--
-- Mobs
--

--
-- Mob Skills
--

return m
