-------------------------------------------------
-- Overrides for Rhapsodies of Vana'diel Missions
-------------------------------------------------
require('modules/module_utils')
require('scripts/globals/utils')
require('scripts/globals/interaction/interaction_global')
require('scripts/globals/garrison')
-----------------------------------
local m = Module:new('rov_missions')

m:addOverride('xi.server.onServerStart', function()
    super()

    -- Mission 1-4: Set Free
    -- Remove The voucher and free Support Job unlock, reward Anniversary Ring instead
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_04_Set_Free', function(mission)
        mission.sections[1][xi.zone.SELBINA].onEventFinish =
        {
            [178] = function(player, csid, option, npc)
                if
                    player:isCrystalWarrior() and
                    not player:hasKeyItem(xi.ki.AIRSHIP_PASS_FOR_KAZHAM)
                then
                    player:sys("Crystal Warriors must first obtain their Airship Pass for Kazham")
                    return
                end

                local pathId = player:getMissionStatus(mission.areaId)
                if not npcUtil.giveItem(player, 15793) then
                    return
                end

                player:confirmTrade()
                mission:complete(player)
                player:setMissionStatus(mission.areaId, pathId)
            end
        }

        mission.sections[1][xi.zone.MHAURA].onEventFinish =
        {
            [370] = function(player, csid, option, npc)
                if
                    player:isCrystalWarrior() and
                    not player:hasKeyItem(xi.ki.AIRSHIP_PASS_FOR_KAZHAM)
                then
                    player:sys("Crystal Warriors must first obtain their Airship Pass for Kazham")
                    return
                end

                local pathId = player:getMissionStatus(mission.areaId)
                if not npcUtil.giveItem(player, 15793) then
                    return
                end

                player:confirmTrade()
                mission:complete(player)
                player:setMissionStatus(mission.areaId, pathId)
            end
        }
    end)

    -- Mission 1-9: The Lion's Roar
    -- Set Level Cap 50
    -- Reward Super Reraiser Tank
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_09_The_Lions_Roar', function(mission)
        mission.reward =
        {
            item        = 26272,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.EDDIES_OF_DESPAIR_I },
        }

        mission.sections[1][xi.zone.QUFIM_ISLAND].Undulating_Confluence.onTrigger = function(player, npc)
            local qufimID = zones[xi.zone.QUFIM_ISLAND]

            if npcUtil.popFromQM(player, npc, qufimID.mob.OPHIOTAURUS, { look = true, hide = 0 }) then
                local mob = GetMobByID(qufimID.mob.OPHIOTAURUS)
                -- Adds level cap
                xi.garrison.addLevelCap(mob, 50)
                mob:addMod(xi.mod.MOVE_SPEED_STACKABLE, 30)
                mob:addMod(xi.mod.ACC,15)
                mob:addMod(xi.mod.ATT,5)
                mob:addMod(xi.mod.SLEEPRES,50)
                mob:addMod(xi.mod.LULLABYRES,50)
                mob:addMod(xi.mod.STUNRES,50)
                mob:addMod(xi.mod.GRAVITYRES,50)

                for _, member in pairs(player:getAlliance()) do
                    if member:getZoneID() == player:getZoneID() then
                        xi.garrison.addLevelCap(member, 50)
                        mob:addEnmity(member, 0, 1)
                    end
                end

                return mission:messageSpecial(qufimID.text.SENSE_OF_FOREBODING)
            else
                return mission:messageSpecial(qufimID.text.WAIT_A_BIT_LONGER)
            end
        end
    end)

    -- Mission 1-10: Eddies of Despair
    -- Reward 1,000 silt
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_10_Eddies_of_Despair_I', function(mission)
        mission.sections[1][xi.zone.ESCHA_ZITAH].onEventFinish =
        {
            [1] = function(player, csid, option, npc)
                player:sys('You receive 1,000 silt.')
                player:addCurrency('escha_silt', 1000)
                mission:complete(player)
            end
        }
    end)

    -- Mission 1-11: A Land After Time
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_11_A_Land_After_Time', function(mission)
        mission.reward =
        {
            item        = xi.item.CIPHER_OF_LIONS_ALTER_EGO_II,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.FATES_CALL },
        }
    end)

    -- Mission 1-12: Fate's Call
    -- Reward Page from Miratete's Memoirs
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_12_Fates_Call', function(mission)
        mission.reward =
        {
            item = 4247,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.WHAT_LIES_BEYOND },
        }
    end)

    -- Mission 1-16: The Lost Avatar
    -- Reward 30 Beastmens Seals
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_16_The_Lost_Avatar', function(mission)
        mission.reward =
        {
            item        = { { xi.item.BEASTMENS_SEAL, 30 } },
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.VOLTO_OSCURO },
        }
    end)

    -- Mission 1-17: Volto Oscuro
    xi.module.modifyInteractionEntry('scripts/missions/rov/1_17_Volto_Oscuro', function(mission)
        mission.reward =
        {
            item        = xi.item.CIPHER_OF_ZEIDS_ALTER_EGO_II,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.RING_MY_BELL },
        }
    end)

    -- Mission 2-02: Crashing Waves
    xi.module.modifyInteractionEntry('scripts/missions/rov/2_02_Crashing_Waves', function(mission)
        mission.reward =
        {
            item        = { { xi.item.KINDREDS_SEAL, 30 } },
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.CALL_TO_SERVE },
        }

        mission.sections[1][xi.zone.RULUDE_GARDENS].Mystic_Retriever.onTrigger = function(player, npc)
            if mission:getVar(player, 'Retrieve') == 1 and
                npcUtil.giveItem(player, xi.item.CIPHER_OF_TENZENS_ALTER_EGO_II)
            then
                mission:complete(player)
            end
        end
    end)

    -- Mission 2-07: Ever Forward
    -- Remove Abquhbah Cipher
    xi.module.modifyInteractionEntry('scripts/missions/rov/2_07_Ever_Forward', function(mission)
        mission.reward =
        {
            item = xi.item.CIPHER_OF_NASHMEIRAS_ALTER_EGO_II,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.REUNITED },
        }
    end)

    -- Mission 2-12: Prime Number
    -- Reward Rebirth Feather
    xi.module.modifyInteractionEntry('scripts/missions/rov/2_12_Prime_Number', function(mission)
        mission.reward =
        {
            item = 5259,
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.FROM_THE_RUINS },
        }
    end)

    -- Mission 2-13: From the Ruins
    -- Reward RHAPSODY_IN_CRIMSON, Far East Hearth
    xi.module.modifyInteractionEntry('scripts/missions/rov/2_13_From_the_Ruins', function(mission)
        mission.reward =
        {
            item = 3705,
            keyItem = xi.ki.RHAPSODY_IN_CRIMSON,
            -- Players should not progress past this point
            nextMission = { xi.mission.log_id.ROV, xi.mission.id.rov.CAUTERIZE },
        }
    end)

    -- Mission 2-14: Cauterize
    -- Players can not progress past this point
    xi.module.modifyInteractionEntry('scripts/missions/rov/2_14_Cauterize', function(mission)
        mission.sections[1].check = function(player, currentMission, missionStatus, vars)
            return false
        end
    end)
end)

--
-- Mobs
--

-- Ophiotaurus: 1-9 The Lion's Roar
xi.module.ensureTable("xi.zone.Qufim_Island.mobs.Ophiotaurus")

m:addOverride("xi.zones.Qufim_Island.mobs.Ophiotaurus.onMobSpawn", function(mob)
    -- We have no way to clamp damage on a mob, so we have to cheese it.
    -- Unfortunately it will not work for weaponskills.
    mob:addListener('TAKE_DAMAGE', '50_DMG_CAP', function(mobArg, amount, attacker, attackType, damageType)
        mobArg:addHP(amount - 50)
    end)

    mob:setMobSkillAttack(5044)
end)

-- Siren: 1-16 The Lost Avatar
xi.module.ensureTable("xi.zone.Yuhtunga_Jungle.mobs.Siren")

m:addOverride("xi.zones.Yuhtunga_Jungle.mobs.Siren.onMobSpawn", function(mob)
    mob:setMod(xi.mod.WIND_ABSORB, 100)
    mob:setMobSkillAttack(5046)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 180)
end)

--
-- Mob Skills
--
local mobSkills =
{
    ['ophio_one'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 25, 0, 60)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },

    ['ophio_two'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 20, 0, 60)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },

    ['ophio_three'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.STUN, 1, 0, 2)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },

    ['siren_one'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            -- xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 25, 0, 60)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },

    ['siren_two'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            -- xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEFENSE_DOWN, 20, 0, 60)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },

    ['siren_three'] =
    {
        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 1
            dmgmod = utils.conalDamageAdjustment(mob, target, skill, dmgmod, 0.9)
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)
            -- xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.STUN, 1, 0, 2)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            skill:setMsg(xi.msg.basic.HIT_DMG)
            return dmg
        end,
    },
}

for skillName, skillFunc in pairs(mobSkills) do
    local skillPath = string.format('xi.actions.mobskills.%s', skillName)
    xi.module.ensureTable(skillPath)

    m:addOverride(skillPath .. '.onMobSkillCheck', function(target, mob, skill)
        return 0
    end)

    m:addOverride(skillPath .. '.onMobWeaponSkill', skillFunc.onMobWeaponSkill)
end

return m
