require("modules/module_utils")
-----------------------------------
local m = Module:new("thf_adjustments")

-- give lower SA/TA cooldown based on ambush merits
local adjustRecast = function(player, ability)
    local merits = player:getMerit(xi.merit.AMBUSH)

    if merits > 0 then
        -- adjust to new recast
        ability:setRecast(math.max(0, ability:getRecast() - merits))
    end
end

m:addOverride('xi.actions.abilities.sneak_attack.onAbilityCheck', function(player, target, ability)
    adjustRecast(player, ability)

    return 0, 0
end)

m:addOverride('xi.actions.abilities.trick_attack.onAbilityCheck', function(player, target, ability)
    adjustRecast(player, ability)

    return 0, 0
end)

-- transfer additional enmity to TA entity (player or trust) based on thf lvl
m:addOverride('xi.effects.trick_attack.onEffectLose', function(player, effect)
    super(player, effect)

    -- if this localvar is set, we are in the onEffectLose function for the second temporary TA buff, so just exit
    if player:getLocalVar('firstTALoss') == 1 then
        player:setLocalVar('firstTALoss', 0)

        return
    end

    -- 50% if thf lvl is 75, linearly scaled down based on thf lvl
    local taEnmityPerc = .5 * (player:getMainJob() == xi.job.THF and player:getMainLvl() or player:getSubLvl()) / 75
    local pTarget = player:getTarget()

    if pTarget then
        -- add effect so getTrickAttackChar can return a valid taChar then immediately remove it for a final time
        player:setLocalVar('firstTALoss', 1)
        player:addStatusEffect(xi.effect.TRICK_ATTACK, 0, 0, 10)
        local taTarget = player:getTrickAttackChar(pTarget)
        player:delStatusEffectSilent(xi.effect.TRICK_ATTACK)

        if taTarget then
            local ce = pTarget:getCE(player)
            local ve = pTarget:getVE(player)

            -- transfer percentage of enmity from player to taTarget
            pTarget:setCE(taTarget, pTarget:getCE(taTarget) + ce * taEnmityPerc)
            pTarget:setVE(taTarget, pTarget:getVE(taTarget) + ve * taEnmityPerc)
            -- leave remaining enmity on thf
            pTarget:setCE(player,   ce * (1 - taEnmityPerc))
            pTarget:setVE(player,   ve * (1 - taEnmityPerc))

            -- print(fmt('transferred {} from {} to {}', taEnmityPerc, player:getName(), taTarget:getName()))
        end
    end
end)

return m
