require("modules/module_utils")
-----------------------------------
local m = Module:new("drg_adjustments")

-- give lower call wyvern cooldown based on empathy merits
local adjustRecast = function(player, ability)
    local merits = player:getMerit(xi.merit.EMPATHY) -- power is 1 per tier, so this will result in a value 0-5

    if merits > 0 then
        -- adjust to new recast by 3 minutes per merit of empathy
        ability:setRecast(math.max(0, ability:getRecast() - merits * 3 * 60))
    end
end

m:addOverride('xi.actions.abilities.call_wyvern.onAbilityCheck', function(player, target, ability)
    local return1, return2 = super(player, target, ability)

    if return1 == 0 then
        adjustRecast(player, ability)
    end

    return return1, return2
end)

return m
