-----------------------------------
-- Appraisers - Appraise ??? items from custom HELM
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("npc_appraisers")

local unknownItem =
{
    xi.item.UNAPPRAISED_SWORD,
    xi.item.UNAPPRAISED_DAGGER,
    xi.item.UNAPPRAISED_POLEARM,
    xi.item.UNAPPRAISED_AXE,
    xi.item.UNAPPRAISED_BOW,
    xi.item.UNAPPRAISED_GLOVES,
    xi.item.UNAPPRAISED_FOOTWEAR,
    xi.item.UNAPPRAISED_HEADPIECE,
    xi.item.UNAPPRAISED_EARRING,
    xi.item.UNAPPRAISED_RING,
    xi.item.UNAPPRAISED_CAPE,
    xi.item.UNAPPRAISED_SASH,
    xi.item.UNAPPRAISED_SHIELD,
    xi.item.UNAPPRAISED_NECKLACE,
    xi.item.UNAPPRAISED_INGOT,
    xi.item.UNAPPRAISED_POTION,
    xi.item.UNAPPRAISED_CLOTH,
    xi.item.UNAPPRAISED_BOX,
}

local function appraiseItem(player, npc, trade)
     for itemID, itemInfo in pairs(cexi.appraisal) do
        if npcUtil.tradeHasExactly(trade, itemID) then
            local appraisalID  = trade:getItem():getAppraisalID()

            if
                appraisalID ~= itemInfo.sourceID and
                appraisalID ~= 0
            then
                cexi.util.dialog(player, { "Hmmm... I can't identify this one but here's some gil for your time." }, npc:getPacketName(), { npc = npc })
                npcUtil.giveCurrency(player, "gil", 2000)
                player:confirmTrade()

                return
            end

            local item = cexi.util.pickItem(itemInfo.items)
            local appraisedItem = item[2]

            player:confirmTrade()


            local dialog = { "Hmmm... yes, interesting." }
            local delay  = cexi.util.dialogDelay(dialog)
            cexi.util.dialog(player, dialog, npc:getPacketName(), { npc = npc })

            npcUtil.giveItem(player, appraisedItem)

            return
        end
    end

    for _, itemID in pairs(unknownItem) do
        if npcUtil.tradeHasExactly(trade, itemID) then
            cexi.util.dialog(player, { "Hmmm... I can't identify this one but here's some gil for your time." }, npc:getPacketName(), { npc = npc })
            npcUtil.giveCurrency(player, "gil", 2000)
            player:confirmTrade()

            return
        end
    end
end

local function onTrigger(player, npc)
    cexi.util.dialog(player, { fmt("Has items unknown? Brings {}... for you I look.", npc:getPacketName()) }, npc:getPacketName(), { npc = npc })
end

cexi.util.liveReload(m, {
    ["Al_Zahbi"] =
    {
        {
            -- (J-9)
            name      = "Ciciroon", -- !pos 71.996 -6.000 -22.952 48
            objtype   = xi.objType.NPC,
            look      = 1736,
            x         = 71.996,
            y         = -6.000,
            z         = -22.952,
            rotation  = 128,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = appraiseItem,
        },
    },
    ["Nashmau"] =
    {
        {
            -- (H-8)
            name      = "Gegeroon", -- !pos 29.242 -6.000 -10.767 53
            objtype   = xi.objType.NPC,
            look      = 1736,
            x         = 29.242,
            y         = -6.000,
            z         = -10.767,
            rotation  = 100,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = appraiseItem,
        },
    },
})

return m
