-----------------------------------
-- (Excavation) Aydeewa Subterrane
-----------------------------------
local m = Module:new("excavation_aydeewa_subterrane")

local info =
{
    zone = "Aydeewa_Subterrane",
    type = cexi.helmID.EXCAVATION,
    var  = "[CW]TOAU_EXCAVATION",
}

local items =
{
    { cexi.rate.COMMON,      17296, "a pebble"              }, -- Pebble           (15%)
    { cexi.rate.COMMON,       2171, "a colibri beak"        }, -- Colibri Beak     (15%)
    { cexi.rate.UNCOMMON,      884, "a black tiger fang"    }, -- Black Tiger Fang (10%)
    { cexi.rate.UNCOMMON,     1307, "a silver leaf"         }, -- Silver Leaf      (10%)
    { cexi.rate.RARE,         2147, "a marid tusk"          }, -- Marid Tusk        (5%)
    { cexi.rate.RARE,         1888, "a sack of silica"      }, -- Silica            (5%)
    { cexi.rate.RARE,          947, "a jar of firesand"     }, -- Firesand          (5%)
    { cexi.rate.RARE,         1309, "a gold leaf"           }, -- Gold Leaf         (5%)
    { cexi.rate.VERY_RARE,    2282, "a ??? necklace"        }, -- ??? Necklace      (1%)
    { cexi.rate.VERY_RARE,    2277, "a ??? earring"         }, -- ??? Earring       (1%)
    { cexi.rate.VERY_RARE,    2278, "a ??? ring"            }, -- ??? Ring          (1%)
    { cexi.rate.SUPER_RARE,   1196, "a qiqirn cape"         }, -- Qiqirn Cape      (.5%)
    { cexi.rate.SUPER_RARE,   1310, "a platinum leaf"       }, -- Platinum Leaf    (.5%)
}

local points =
{
    { -19.3245, 36.4916,  83.6912 }, -- !pos -19.3245 36.4916 83.6912
    {  72.6598, 39.6447,  20.9813 },
    { 108.8826, 36.7952,  -2.2968 },
    { 138.6372, 36.1254,  -2.2887 },
    { 117.1291, 37.1006, -27.3648 },
    { 119.3841, 35.2655, -47.3127 },
    { 152.7501, 34.8991, -38.1774 },
    { 161.9512, 34.9691, -31.9281 },

    {  99.6662, 36.3700, -99.7403 },
    {  57.8393, 36.1197, -54.6768 },
    {  21.9778, 39.1793, -64.8227 },
    {  32.4704, 39.6496, -19.0169 },
    {  10.1380, 39.7145, -17.4397 },
    { -15.4737, 39.3700, -24.2890 },
    { -14.0024, 39.2926,  16.2154 },
    { -21.7576, 39.2085,  25.0406 },
    { -53.5968, 36.6785,  15.0596 },
    { -72.6216, 36.6457,  19.0198 },
}

local extra =
{
    appraisal =
    {
        [xi.item.UNAPPRAISED_NECKLACE] =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.CHAIN_GORGET     }, -- 24%
                { cexi.rate.COMMON,      xi.item.CARAPACE_GORGET  }, -- 15%
                { cexi.rate.RARE,        xi.item.WIVRE_GORGET     }, --  5%
                { cexi.rate.VERY_RARE,   xi.item.FYLGJA_TORQUE    }, --  1%
            },
        },

        [xi.item.UNAPPRAISED_EARRING]  =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.SILVER_EARRING   }, -- 24%
                { cexi.rate.COMMON,      xi.item.WING_EARRING     }, -- 15%
                { cexi.rate.UNCOMMON,    xi.item.MOON_EARRING     }, -- 10%
                { cexi.rate.RARE,        xi.item.PHANTOM_EARRING  }, --  5%
            },
        },

        [xi.item.UNAPPRAISED_RING]     =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.COPPER_RING      }, -- 24%
                { cexi.rate.COMMON,      xi.item.FERAL_RING       }, -- 15%
                { cexi.rate.UNCOMMON,    xi.item.FLUORITE_RING    }, -- 10%
                { cexi.rate.RARE,        xi.item.DRAGON_RING      }, --  5%
            },
        },
    }
}

cexi.helm.helmAdd(m, {
    info = info,
    items = items,
    points = points,
    extra = extra
})

return m
