-----------------------------------
-- (Excavation) Arrapago Reef
-----------------------------------
local m = Module:new("excavation_arrapago_reef")

local info =
{
    zone = "Arrapago_Reef",
    type = cexi.helmID.EXCAVATION,
    var  = "[CW]TOAU_EXCAVATION",
}

local items =
{
    { cexi.rate.VERY_COMMON, 18235, "a corsair bullet"           }, -- Corsair Bullet   (24%)
    { cexi.rate.COMMON,       4484, "a shall shell"              }, -- Shall Shell      (15%)
    { cexi.rate.COMMON,       2157, "an imp horn"                }, -- Imp Horn         (15%)
    { cexi.rate.UNCOMMON,      947, "a jar of firesand"          }, -- Firesand         (10%)
    { cexi.rate.UNCOMMON,     1888, "a sack of silica"           }, -- Silica           (10%)
    { cexi.rate.RARE,         5284, "an old bullet box"          }, -- Bullet Pouch     ( 5%)
    { cexi.rate.RARE,         2290, "a chunk of imperial cermet" }, -- Imperial Cermet  ( 5%)
    { cexi.rate.RARE,          703, "a petrified log"            }, -- Petrified Log    ( 5%)
    { cexi.rate.RARE,         1724, "a soulflayer robe"          }, -- Soulflayer Robe  ( 5%)
    { cexi.rate.RARE,         2336, "a soulflayer staff"         }, -- Soulflayer Staff ( 5%)
    { cexi.rate.VERY_RARE,    2190, "a ??? sword"                }, -- ??? Sword        ( 1%)
    { cexi.rate.VERY_RARE,    2276, "a ??? headpiece"            }, -- ??? Headpiece    ( 1%)
    { cexi.rate.VERY_RARE,    2283, "a ??? ingot"                }, -- ??? Ingot        ( 1%)
    { cexi.rate.VERY_RARE,    2154, "an orobon lure"             }, -- Orobon Lure      ( 1%)
    { cexi.rate.SUPER_RARE,   2459, "a pinch of minium"          }, -- Minium          (0.5%)
}

local points =
{
    -- First Ship
    { -135.7271, -10.0000, 433.3456 }, -- !pos -135.7271 -10.0000 433.3456
    { -130.1266, -10.0000, 425.1859 }, -- !pos -130.1266 -10.0000 425.1859
    { -138.8177,  -7.0000, 425.3431 }, -- !pos -138.8177 -7.0000 425.3431
    { -142.1548,  -7.2906, 428.2965 }, -- !pos -142.1548 -7.2906 428.2965
    { -138.3215,  -7.7500, 429.5363 }, -- !pos -138.3215 -7.7500 429.5363
    { -152.7608,  -7.0000, 422.7514 }, -- !pos -152.7608 -7.0000 422.7514
    { -157.3060,  -9.7500, 402.7000 }, -- !pos -157.3060 -9.7500 402.7000
    { -148.5407,  -9.7500, 407.1145 }, -- !pos -148.5407 -9.7500 407.1145
    { -144.9986,  -9.7500, 410.7417 }, -- !pos -144.9986 -9.7500 410.7417
    { -141.3631,  -7.1000, 413.1976 }, -- !pos -141.3631 -7.1000 413.1976

    -- Second Ship
    {   1.6353, -10.9999, 318.6420 }, -- !pos 1.6353 -10.9999 318.6420
    { -11.1574,  -9.7501, 320.6677 }, -- !pos -11.1574 -9.7501 320.6677
    { -13.9957,  -7.0001, 299.2527 }, -- !pos -13.9957 -7.0001 299.2527
    { -21.0252,  -7.0001, 308.4542 }, -- !pos -21.0252 -7.0001 308.4542
    { -23.2504,  -7.0001, 310.0819 }, -- !pos -23.2504 -7.0001 310.0819
    { -23.9282,  -7.0001, 312.3544 }, -- !pos -23.9282 -7.0001 312.3544
    { -25.6050,  -6.9999, 295.7093 }, -- !pos -25.6050 -6.9999 295.7093
    { -22.0754,  -7.0320, 294.3515 }, -- !pos -22.0754 -7.0320 294.3515
    { -27.0587,  -7.0320, 292.6917 }, -- !pos -27.0587 -7.0320 292.6917
    { -39.6531, -10.0000, 287.6201 }, -- !pos -39.6531 -10.0000 287.6201
    { -28.8508, -10.0000, 286.6471 }, -- !pos -28.8508 -10.0000 286.6471
    { -32.5083, -10.0000, 283.4834 }, -- !pos -32.5083 -10.0000 283.4834
    { -39.5438,  -3.6059, 265.6911 }, -- !pos -39.5438 -3.6059 265.6911

    -- Third Ship
    { 189.7384,  -7.3369, 299.9536 }, -- !pos 189.7384 -7.3369 299.9536
    { 190.6126,  -7.3369, 298.3201 }, -- !pos 190.6126 -7.3369 298.3201
    { 186.1505,  -7.3369, 294.2278 }, -- !pos 186.1505 -7.3369 294.2278
    { 183.7107,  -7.0000, 286.1378 }, -- !pos 183.7107 -7.0000 286.1378
    { 191.9476,  -9.7500, 295.9424 }, -- !pos 191.9476 -9.7500 295.9424
}

local extra =
{
    appraisal =
    {
        [xi.item.UNAPPRAISED_SWORD]     =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.SCIMITAR         }, -- 24%
                { cexi.rate.COMMON,      xi.item.TULWAR           }, -- 15%
                { cexi.rate.UNCOMMON,    xi.item.SHOTEL           }, -- 10%
                { cexi.rate.RARE,        xi.item.PLATINUM_CUTLASS }, --  5%
            },
        },
        [xi.item.UNAPPRAISED_HEADPIECE] =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.LEATHER_BANDANA }, -- 24%
                { cexi.rate.COMMON,      xi.item.JARIDAH_KHUD    }, -- 15%
                { cexi.rate.UNCOMMON,    xi.item.SIPAHI_TURBAN   }, -- 10%
                { cexi.rate.RARE,        xi.item.EYEPATCH        }, --  5%
            },
        },

        [xi.item.UNAPPRAISED_INGOT]     =
        {
            sourceID  = 250,
            items     =
            {
                { cexi.rate.VERY_COMMON, xi.item.SILVER_INGOT      }, -- 24%
                { cexi.rate.COMMON,      xi.item.GOLD_INGOT        }, -- 15%
                { cexi.rate.UNCOMMON,    xi.item.PLATINUM_INGOT    }, -- 10%
                { cexi.rate.RARE,        xi.item.SCINTILLANT_INGOT }, --  5%
            },
        },
    }
}

cexi.helm.helmAdd(m, {
    info = info,
    items = items,
    points = points,
    extra = extra
})

return m
