-------------------------------------------
-- Fixes for Nyzul Isle Objectives (Kill Specified Enemy/Enemies)
-------------------------------------------
require('scripts/globals/nyzul')
require('scripts/globals/nyzul/floor_generation')
-------------------------------------------
local m = Module:new('nyzul_isle_fixes')
local ID = zones[xi.zone.NYZUL_ISLE]
-----------------------------------
-- Data Tables
-----------------------------------
local lampSpawnPoints = -- Set lamp spawn points, by layout.
{
    [1] = -- 380, -0.5, -500
    {
        [1] = { 433.5, 0, -486.5 },
        [2] = { 406.5, 0, -553.5 },
        [3] = { 384.5, 0, -540.0 },
        [4] = { 378.0, 0, -582.0 },
        [5] = { 406.5, 0, -593.5 },
        [6] = { 420.0, 0, -575.5 },
        [7] = { 446.5, 0, -566.5 },
        [8] = { 473.5, 0, -593.5 },
        [9] = { 420.5, 0, -540.0 },
    },

    [2] = -- 500, -0.5,  -20
    {
        [1] = { 458.0, 0, -22.0 },
        [2] = { 446.5, 0,   6.5 },
        [3] = { 473.5, 0,  33.5 },
        [4] = { 393.5, 0,    20 },
        [5] = { 540.0, 0, -15.5 },
        [6] = { 553.5, 0,  -6.5 },
        [7] = { 593.0, 0, -20.0 },
    },

    [3] = -- 500, -0.5, 60
    {
        [1] = { 486.5, 0, 113.5 },
        [2] = { 458.0, 0, 102.0 },
        [3] = { 464.5, 0,  60.0 },
        [4] = { 446.5, 0,  46.5 },
        [5] = { 500.0, 0,   6.0 },
        [6] = { 553.5, 0,  46.5 },
        [7] = { 540.0, 0,  55.5 },
        [8] = { 580.0, 0,  46.5 },
    },

    [4] = -- 500, -0.5, -100
    {
        [1] = { 513.5, 0,  -46.5 },
        [2] = { 504.5, 0,  -60.0 },
        [3] = { 540.0, 0, -104.5 },
        [4] = { 593.0, 0, -100.0 },
        [5] = { 486.5, 0, -166.5 },
        [6] = { 540.0, 0, -175.5 },
        [7] = { 553.5, 0, -193.5 },
        [8] = { 580.0, 0, -166.5 },
        [9] = { 460.0, 0, -113.5 },
    },

    [5] = -- 540, -0.5, -140
    {
        [1] = { 566.5, -0.5,   -126 },
        [2] = {   619, -0.5,   -139 },
        [3] = { 606.5, -0.5, -113.5 },
        [4] = { 606.5,   -1,   -6.5 },
        [5] = { 579.5, -0.5,   24.5 },
    },

    [6] = -- 460, -0.5, -219
    {
        [1] = { 455.5, -0.5,   -140 },
        [2] = { 473.5, -0.5, -153.5 },
        [3] = {   375, -0.5,   -140 },
        [4] = { 446.5, -0.5, -193.5 },
        [5] = { 513.5, -0.5, -233.5 },
    },

    [7] = -- 420, -0.5, 500
    {
        [1] = { 501.5, -0.5,   502 },
        [2] = { 406.5, -0.5, 473.5 },
        [3] = { 420.5, -0.5, 420.5 },
        [4] = { 473.5, -0.5, 473.5 },
        [5] = {   500, -0.5,   487 },
    },

    [8] = -- 60, -0.5, -335
    {
        [1] = {   59, -0.5,   -301 },
        [2] = { 20.5, -0.5,   -340 },
        [3] = { 99.5, -0.5, -340.5 },
        [4] = { 86.5, -0.5, -366.5 },
        [5] = { 86.5, -0.5,   -420 },
    },

    [9] = -- 20, -0.5, -500
    {
        [1] = {   -20, -0.5,   -500 },
        [2] = {    20, -0.5,   -465 },
        [3] = {  -6.5, -0.5, -446.5 },
        [4] = { -73.5, -0.5, -446.5 },
        [5] = { -59.5, -0.5,   -500 },
    },

    [10] = -- -95, -0.5, 60
    {
        [1] = { -99.5, -0.5, 99.5 },
        [2] = {   -51, -0.5,  100 },
        [3] = { -99.5, -0.5,   20 },
        [4] = { -73.5, -0.5,  6.5 },
        [5] = { -46.5, -0.5, 33.5 },
    },

    [11] = -- 100, -0.5, 100
    {
        [1] = { 86.5, -0.5, 73.5 },
        [2] = { 99.5, -0.5, 20.5 },
        [3] = { 73.5, -0.5,  6.5 },
        [4] = { 46.5, -0.5, 46.5 },
        [5] = { 46.5, -0.5, 86.5 },
    },

    [12] = -- -460, -4.0, -180
    {
        [1] = {   -420,   -4,   -180 },
        [2] = { -539.5,   -4, -180.5 },
        [3] = {   -460,   -4,   -220 },
        [4] = { -380.5, -0.5,   -220 },
        [5] = { -340.5, -0.5, -260.5 },
    },

    [13] = -- -304, -0.5, -380
    {
        [1] = {   -260, -0.5,   -380 },
        [2] = { -273.5, -0.5, -393.5 },
        [3] = {   -260, -0.5,   -340 },
        [4] = { -286.5, -0.5, -433.5 },
        [5] = { -286.5, -0.5, -366.5 },
    },

    [14] = -- -380, -0.5, -500
    {
        [1] = { -406.5, -0.5,   -500 },
        [2] = { -446.5,   -4, -513.5 },
        [3] = {   -460, -0.5,   -446 },
        [4] = { -393.5, -0.5, -473.5 },
        [5] = { -353.5, -0.5, -473.5 },
    },

    [15] = -- -459, -4.0, -540
    {
        [1] = {   -460,   -4,   -580 },
        [2] = { -380.5, -0.5, -539.5 },
        [3] = { -406.5, -0.5,   -540 },
        [4] = { -433.5,   -4, -566.5 },
        [5] = { -513.5,   -4, -566.5 },
    },

    [16] = -- -465, -4.0, -340
    {
        [1] = { -473.5, -0.5, -353.5 },
        [2] = { -486.5, -0.5,   -340 },
        [3] = {   -540,   -4,   -340 },
        [4] = { -446.5, -0.5, -366.5 },
        [5] = { -464.5, -0.5,   -420 },
    },

    [17] = -- 504.5, 0.0, -60
    {
        [ 1] = {   514, 0,    -86 },
        [ 2] = {   485, 0,   -114 },
        [ 3] = {   500, 0,   -100 },
        [ 4] = {   458, 0,    -98 },
        [ 5] = {   526, 0, -113.5 },
        [ 6] = {   554, 0, -113.5 },
        [ 7] = { 553.5, 0,  -86.5 },
        [ 8] = {   540, 0, -104.5 },
        [ 9] = {   593, 0,   -100 },
        [10] = {   500, 0,   -135 },
        [11] = {   513, 0, -193.5 },
        [12] = { 486.5, 0, -166.5 },
        [13] = {   526, 0, -193.5 },
        [14] = {   540, 0, -175.5 },
        [15] = { 553.5, 0, -193.5 },
        [16] = {   582, 0,   -182 },
    },
}

local layoutSpawnPoints = -- Spawnpoints by layout.
{
    [1] =
    {
        [ 1] = { x = 405.5, y = 0, z = -512.5 },
        [ 2] = { x = 406.0, y = 0, z = -487.0 },
        [ 3] = { x = 414.5, y = 0, z = -491.2 },
        [ 4] = { x = 414.9, y = 0, z = -504.1 },
        [ 5] = { x = 424.5, y = 0, z = -503.9 },
        [ 6] = { x = 424.5, y = 0, z = -491.7 },
        [ 7] = { x = 433.2, y = 0, z = -486.6 },
        [ 8] = { x = 433.1, y = 0, z = -499.1 },
        [ 9] = { x = 433.8, y = 0, z = -513.0 },
        [10] = { x = 420.5, y = 0, z = -513.1 },
        [11] = { x = 420.0, y = 0, z = -526.6 },
        [12] = { x = 429.0, y = 0, z = -530.8 },
        [13] = { x = 428.5, y = 0, z = -548.7 },
        [14] = { x = 420.0, y = 0, z = -549.1 },
        [15] = { x = 410.9, y = 0, z = -549.0 },
        [16] = { x = 410.9, y = 0, z = -540.2 },
        [17] = { x = 420.0, y = 0, z = -539.6 },
        [18] = { x = 380.4, y = 0, z = -526.0 },
        [19] = { x = 367.0, y = 0, z = -526.9 },
        [20] = { x = 375.0, y = 0, z = -536.0 },
        [21] = { x = 385.3, y = 0, z = -540.0 },
        [22] = { x = 375.8, y = 0, z = -544.0 },
        [23] = { x = 366.8, y = 0, z = -553.5 },
        [24] = { x = 379.1, y = 0, z = -553.4 },
        [25] = { x = 393.0, y = 0, z = -554.0 },
        [26] = { x = 393.7, y = 0, z = -541.0 },
        [27] = { x = 393.5, y = 0, z = -526.5 },
        [28] = { x = 379.8, y = 0, z = -566.0 },
        [29] = { x = 380.0, y = 0, z = -579.8 },
        [30] = { x = 393.3, y = 0, z = -579.6 },
        [31] = { x = 473.4, y = 0, z = -593.2 },
        [32] = { x = 473.0, y = 0, z = -580.0 },
        [33] = { x = 473.4, y = 0, z = -567.0 },
        [34] = { x = 464.6, y = 0, z = -575.9 },
        [35] = { x = 459.8, y = 0, z = -585.0 },
        [36] = { x = 456.0, y = 0, z = -575.7 },
        [37] = { x = 446.4, y = 0, z = -566.2 },
        [38] = { x = 446.7, y = 0, z = -579.6 },
        [39] = { x = 446.4, y = 0, z = -593.4 },
        [40] = { x = 459.9, y = 0, z = -594.0 },
        [41] = { x = 433.8, y = 0, z = -580.1 },
        [42] = { x = 433.5, y = 0, z = -567.1 },
        [43] = { x = 420.5, y = 0, z = -566.2 },
        [44] = { x = 406.5, y = 0, z = -566.7 },
        [45] = { x = 406.5, y = 0, z = -579.7 },
        [46] = { x = 406.5, y = 0, z = -593.4 },
        [47] = { x = 415.5, y = 0, z = -584.3 },
        [48] = { x = 419.9, y = 0, z = -575.5 },
        [49] = { x = 424.7, y = 0, z = -584.4 },
        [50] = { x = 433.2, y = 0, z = -593.2 },
        [51] = { x = 405.5, y = 0, z = -499.8 },
    },

    [2] =
    {
        [ 1] = { x = 526.2, y = 0, z = -33.1 },
        [ 2] = { x = 526.4, y = 0, z =  -6.5 },
        [ 3] = { x = 539.5, y = 0, z =  -6.5 },
        [ 4] = { x = 553.3, y = 0, z =  -6.6 },
        [ 5] = { x = 553.5, y = 0, z = -19.9 },
        [ 6] = { x = 553.4, y = 0, z = -33.3 },
        [ 7] = { x = 553.4, y = 0, z = -33.3 },
        [ 8] = { x = 544.4, y = 0, z = -24.6 },
        [ 9] = { x = 540.1, y = 0, z = -15.9 },
        [10] = { x = 535.4, y = 0, z = -24.6 },
        [11] = { x = 566.0, y = 0, z = -20.0 },
        [12] = { x = 580.0, y = 0, z = -19.9 },
        [13] = { x = 593.0, y = 0, z = -20.0 },
        [14] = { x = 473.6, y = 0, z = -20.1 },
        [15] = { x = 459.1, y = 0, z = -20.9 },
        [16] = { x = 459.9, y = 0, z =  -6.5 },
        [17] = { x = 460.0, y = 0, z =   5.8 },
        [18] = { x = 473.4, y = 0, z =   6.6 },
        [19] = { x = 446.6, y = 0, z =   6.7 },
        [20] = { x = 446.7, y = 0, z =  19.9 },
        [21] = { x = 446.7, y = 0, z =  33.7 },
        [22] = { x = 459.7, y = 0, z =  33.3 },
        [23] = { x = 473.7, y = 0, z =  33.6 },
        [24] = { x = 464.5, y = 0, z =  24.7 },
        [25] = { x = 455.9, y = 0, z =  20.0 },
        [26] = { x = 464.5, y = 0, z =  15.5 },
        [27] = { x = 428.7, y = 0, z =  20.5 },
        [28] = { x = 412.8, y = 0, z =  20.0 },
        [29] = { x = 407.9, y = 0, z =   8.0 },
        [30] = { x = 393.5, y = 0, z =  -6.5 },
        [31] = { x = 393.6, y = 0, z =  19.4 },
        [32] = { x = 378.0, y = 0, z =  20.0 },
        [33] = { x = 406.4, y = 0, z =  -6.5 },
        [34] = { x = 393.3, y = 0, z =  46.2 },
        [35] = { x = 406.5, y = 0, z =  46.2 },
        [36] = { x = 406.2, y = 0, z =  34.2 },
        [37] = { x = 526.2, y = 0, z = -20.1 },
    },

    [3] =
    {
        [ 1] = { x = 500.0, y = 0, z =  90.5 },
        [ 2] = { x = 509.0, y = 0, z =  90.5 },
        [ 3] = { x = 509.0, y = 0, z =  99.5 },
        [ 4] = { x = 509.0, y = 0, z = 109.2 },
        [ 5] = { x = 500.0, y = 0, z = 109.0 },
        [ 6] = { x = 491.0, y = 0, z = 109.0 },
        [ 7] = { x = 491.0, y = 0, z =  99.7 },
        [ 8] = { x = 491.0, y = 0, z =  91.0 },
        [ 9] = { x = 473.5, y = 0, z = 100.0 },
        [10] = { x = 460.3, y = 0, z =  98.6 },
        [11] = { x = 460.0, y = 0, z =  86.5 },
        [12] = { x = 460.0, y = 0, z =  73.5 },
        [13] = { x = 446.6, y = 0, z =  73.5 },
        [14] = { x = 473.3, y = 0, z =  73.3 },
        [15] = { x = 473.3, y = 0, z =  60.3 },
        [16] = { x = 473.4, y = 0, z =  46.5 },
        [17] = { x = 459.7, y = 0, z =  46.5 },
        [18] = { x = 446.5, y = 0, z =  46.6 },
        [19] = { x = 455.6, y = 0, z =  55.5 },
        [20] = { x = 464.3, y = 0, z =  59.9 },
        [21] = { x = 455.7, y = 0, z =  64.4 },
        [22] = { x = 525.8, y = 0, z =  60.2 },
        [23] = { x = 526.4, y = 0, z =  46.7 },
        [24] = { x = 526.4, y = 0, z =  73.4 },
        [25] = { x = 535.5, y = 0, z =  64.6 },
        [26] = { x = 539.9, y = 0, z =  56.0 },
        [27] = { x = 544.5, y = 0, z =  64.4 },
        [28] = { x = 553.6, y = 0, z =  73.5 },
        [29] = { x = 553.6, y = 0, z =  59.8 },
        [30] = { x = 553.6, y = 0, z =  46.6 },
        [31] = { x = 540.2, y = 0, z =  46.4 },
        [32] = { x = 566.6, y = 0, z =  60.0 },
        [33] = { x = 580.0, y = 0, z =  59.7 },
        [34] = { x = 580.0, y = 0, z =  46.3 },
        [35] = { x = 500.1, y = 0, z =  32.9 },
        [36] = { x = 500.1, y = 0, z =  25.0 },
        [37] = { x = 500.0, y = 0, z =   6.2 },
    },

    [4] =
    {
        [ 1] = { x = 500.0, y = 0, z =  -74.5 },
        [ 2] = { x = 513.6, y = 0, z =  -73.5 },
        [ 3] = { x = 513.5, y = 0, z =  -60.3 },
        [ 4] = { x = 513.6, y = 0, z =  -46.9 },
        [ 5] = { x = 486.5, y = 0, z =  -73.4 },
        [ 6] = { x = 495.3, y = 0, z =  -64.7 },
        [ 7] = { x = 504.0, y = 0, z =  -60.1 },
        [ 8] = { x = 495.6, y = 0, z =  -55.6 },
        [ 9] = { x = 486.3, y = 0, z =  -46.6 },
        [10] = { x = 499.8, y = 0, z =  -46.9 },
        [11] = { x = 525.8, y = 0, z =  -99.9 },
        [12] = { x = 526.5, y = 0, z = -113.2 },
        [13] = { x = 526.6, y = 0, z =  -86.4 },
        [14] = { x = 535.5, y = 0, z =  -95.4 },
        [15] = { x = 539.8, y = 0, z = -103.9 },
        [16] = { x = 544.4, y = 0, z =  -95.7 },
        [17] = { x = 553.5, y = 0, z =  -86.6 },
        [18] = { x = 553.4, y = 0, z =  -99.6 },
        [19] = { x = 553.7, y = 0, z = -113.3 },
        [20] = { x = 540.3, y = 0, z = -113.5 },
        [21] = { x = 565.7, y = 0, z =  -99.9 },
        [22] = { x = 575.0, y = 0, z = -100.1 },
        [23] = { x = 593.0, y = 0, z =  -99.8 },
        [24] = { x = 473.7, y = 0, z = -100.0 },
        [25] = { x = 461.0, y = 0, z = -100.8 },
        [26] = { x = 459.8, y = 0, z = -113.5 },
        [27] = { x = 499.9, y = 0, z = -127.0 },
        [28] = { x = 499.9, y = 0, z = -134.9 },
        [29] = { x = 500.0, y = 0, z = -144.1 },
        [30] = { x = 499.8, y = 0, z = -154.1 },
        [31] = { x = 500.0, y = 0, z = -170.8 },
        [32] = { x = 490.9, y = 0, z = -170.8 },
        [33] = { x = 491.0, y = 0, z = -179.8 },
        [34] = { x = 490.8, y = 0, z = -188.5 },
        [35] = { x = 499.9, y = 0, z = -188.8 },
        [36] = { x = 499.8, y = 0, z = -180.4 },
        [37] = { x = 509.2, y = 0, z = -171.1 },
        [38] = { x = 508.7, y = 0, z = -179.9 },
        [39] = { x = 509.0, y = 0, z = -189.0 },
        [40] = { x = 525.5, y = 0, z = -179.9 },
        [41] = { x = 526.5, y = 0, z = -193.4 },
        [42] = { x = 526.4, y = 0, z = -166.7 },
        [43] = { x = 539.5, y = 0, z = -166.7 },
        [44] = { x = 553.3, y = 0, z = -166.5 },
        [45] = { x = 553.4, y = 0, z = -179.6 },
        [46] = { x = 553.5, y = 0, z = -193.2 },
        [47] = { x = 544.7, y = 0, z = -184.7 },
        [48] = { x = 540.3, y = 0, z = -175.9 },
        [49] = { x = 535.4, y = 0, z = -184.7 },
        [50] = { x = 566.4, y = 0, z = -180.0 },
        [51] = { x = 579.1, y = 0, z = -179.1 },
        [52] = { x = 580.2, y = 0, z = -166.6 },
    },

    [5] =
    {
        [ 1] = { x = 566.2, y = 0, z = -140.1 },
        [ 2] = { x = 566.5, y = 0, z = -153.6 },
        [ 3] = { x = 566.5, y = 0, z = -126.3 },
        [ 4] = { x = 575.4, y = 0, z = -135.3 },
        [ 5] = { x = 579.9, y = 0, z = -144.0 },
        [ 6] = { x = 584.5, y = 0, z = -135.7 },
        [ 7] = { x = 593.4, y = 0, z = -126.5 },
        [ 8] = { x = 593.5, y = 0, z = -140.2 },
        [ 9] = { x = 593.5, y = 0, z = -153.6 },
        [10] = { x = 580.0, y = 0, z = -153.3 },
        [11] = { x = 606.3, y = 0, z = -140.1 },
        [12] = { x = 617.6, y = 0, z = -138.0 },
        [13] = { x = 620.0, y = 0, z = -126.8 },
        [14] = { x = 620.0, y = 0, z = -113.6 },
        [15] = { x = 606.3, y = 0, z = -100.0 },
        [16] = { x = 606.4, y = 0, z =  -86.5 },
        [17] = { x = 619.9, y = 0, z =  -86.5 },
        [18] = { x = 633.5, y = 0, z =  -86.5 },
        [19] = { x = 633.5, y = 0, z =  -99.7 },
        [20] = { x = 624.6, y = 0, z = -104.3 },
        [21] = { x = 615.6, y = 0, z = -104.5 },
        [22] = { x = 615.7, y = 0, z =  -95.6 },
        [23] = { x = 624.2, y = 0, z =  -95.6 },
        [24] = { x = 606.0, y = 0, z = -113.7 },
        [25] = { x = 620.1, y = 0, z =  -73.8 },
        [26] = { x = 620.1, y = 0, z =  -64.9 },
        [27] = { x = 620.1, y = 0, z =  -46.9 },
        [28] = { x = 620.0, y = 0, z =  -33.8 },
        [29] = { x = 606.3, y = 0, z =  -33.5 },
        [30] = { x = 606.4, y = 0, z =  -20.0 },
        [31] = { x = 606.5, y = 0, z =   -6.6 },
        [32] = { x = 619.9, y = 0, z =   -6.5 },
        [33] = { x = 633.4, y = 0, z =   -6.3 },
        [34] = { x = 633.5, y = 0, z =  -19.8 },
        [35] = { x = 624.5, y = 0, z =  -24.3 },
        [36] = { x = 615.4, y = 0, z =  -24.3 },
        [37] = { x = 615.4, y = 0, z =  -15.6 },
        [38] = { x = 624.4, y = 0, z =  -15.6 },
        [39] = { x = 620.1, y = 0, z =    6.6 },
        [40] = { x = 617.8, y = 0, z =   17.9 },
        [41] = { x = 606.6, y = 0, z =   19.9 },
        [42] = { x = 593.4, y = 0, z =   20.0 },
        [43] = { x = 593.3, y = 0, z =    6.5 },
        [44] = { x = 593.4, y = 0, z =   33.5 },
        [45] = { x = 579.9, y = 0, z =   33.4 },
        [46] = { x = 566.1, y = 0, z =   33.5 },
        [47] = { x = 566.7, y = 0, z =   19.9 },
        [48] = { x = 566.3, y = 0, z =    6.5 },
        [49] = { x = 575.6, y = 0, z =   15.2 },
        [50] = { x = 580.0, y = 0, z =   24.3 },
        [51] = { x = 584.5, y = 0, z =   15.6 },
        [52] = { x = 553.4, y = 0, z =   20.0 },
        [53] = { x = 553.4, y = 0, z =    6.4 },
        [54] = { x = 540.0, y = 0, z =    6.5 },
        [55] = { x = 526.6, y = 0, z =    6.4 },
        [56] = { x = 526.5, y = 0, z =   20.0 },
        [57] = { x = 526.5, y = 0, z =   33.4 },
        [58] = { x = 540.0, y = 0, z =   33.4 },
        [59] = { x = 553.3, y = 0, z =   33.6 },
        [60] = { x = 544.3, y = 0, z =   24.3 },
        [61] = { x = 535.3, y = 0, z =   24.6 },
        [62] = { x = 535.4, y = 0, z =   15.6 },
        [63] = { x = 544.4, y = 0, z =   15.4 },
    },

    [6] =
    {
        [ 1] = { x = 460.0, y = 0, z = -193.5 },
        [ 2] = { x = 446.3, y = 0, z = -193.6 },
        [ 3] = { x = 473.5, y = 0, z = -193.6 },
        [ 4] = { x = 473.4, y = 0, z = -180.0 },
        [ 5] = { x = 473.6, y = 0, z = -166.7 },
        [ 6] = { x = 460.0, y = 0, z = -166.4 },
        [ 7] = { x = 446.5, y = 0, z = -166.5 },
        [ 8] = { x = 455.5, y = 0, z = -175.4 },
        [ 9] = { x = 464.2, y = 0, z = -179.8 },
        [10] = { x = 455.7, y = 0, z = -184.5 },
        [11] = { x = 460.1, y = 0, z = -153.5 },
        [12] = { x = 446.6, y = 0, z = -153.4 },
        [13] = { x = 473.3, y = 0, z = -153.4 },
        [14] = { x = 446.5, y = 0, z = -126.3 },
        [15] = { x = 460.0, y = 0, z = -126.4 },
        [16] = { x = 473.5, y = 0, z = -126.6 },
        [17] = { x = 464.6, y = 0, z = -135.6 },
        [18] = { x = 455.8, y = 0, z = -140.1 },
        [19] = { x = 464.5, y = 0, z = -144.7 },
        [20] = { x = 429.0, y = 0, z = -139.4 },
        [21] = { x = 406.9, y = 0, z = -139.9 },
        [22] = { x = 406.1, y = 0, z = -152.1 },
        [23] = { x = 406.5, y = 0, z = -166.3 },
        [24] = { x = 393.4, y = 0, z = -165.6 },
        [25] = { x = 393.0, y = 0, z = -152.3 },
        [26] = { x = 393.6, y = 0, z = -140.0 },
        [27] = { x = 393.5, y = 0, z = -127.9 },
        [28] = { x = 393.5, y = 0, z = -113.9 },
        [29] = { x = 406.4, y = 0, z = -113.5 },
        [30] = { x = 404.5, y = 0, z = -126.0 },
        [31] = { x = 378.6, y = 0, z = -138.9 },
        [32] = { x = 486.2, y = 0, z = -220.0 },
        [33] = { x = 486.3, y = 0, z = -206.6 },
        [34] = { x = 500.1, y = 0, z = -206.5 },
        [35] = { x = 513.5, y = 0, z = -206.4 },
        [36] = { x = 513.6, y = 0, z = -219.8 },
        [37] = { x = 513.4, y = 0, z = -233.8 },
        [38] = { x = 499.9, y = 0, z = -233.4 },
        [39] = { x = 495.5, y = 0, z = -224.5 },
        [40] = { x = 495.6, y = 0, z = -215.6 },
        [41] = { x = 504.3, y = 0, z = -215.6 },
        [42] = { x = 504.5, y = 0, z = -224.5 },
        [43] = { x = 446.5, y = 0, z = -140.2 },
    },

    [7] =
    {
        [ 1] = { x = 446.2, y = 0, z = 500.0 },
        [ 2] = { x = 455.5, y = 0, z = 495.5 },
        [ 3] = { x = 455.6, y = 0, z = 504.4 },
        [ 4] = { x = 460.0, y = 0, z = 508.8 },
        [ 5] = { x = 459.9, y = 0, z = 500.0 },
        [ 6] = { x = 460.1, y = 0, z = 491.2 },
        [ 7] = { x = 464.0, y = 0, z = 495.6 },
        [ 8] = { x = 464.3, y = 0, z = 504.3 },
        [ 9] = { x = 473.5, y = 0, z = 500.0 },
        [10] = { x = 486.2, y = 0, z = 500.1 },
        [11] = { x = 498.0, y = 0, z = 498.0 },
        [12] = { x = 500.1, y = 0, z = 486.4 },
        [13] = { x = 486.2, y = 0, z = 500.1 },
        [14] = { x = 497.9, y = 0, z = 498.0 },
        [15] = { x = 500.1, y = 0, z = 486.4 },
        [16] = { x = 419.9, y = 0, z = 473.9 },
        [17] = { x = 406.5, y = 0, z = 473.6 },
        [18] = { x = 433.4, y = 0, z = 473.7 },
        [19] = { x = 415.4, y = 0, z = 464.6 },
        [20] = { x = 424.1, y = 0, z = 460.1 },
        [21] = { x = 415.5, y = 0, z = 455.6 },
        [22] = { x = 406.5, y = 0, z = 446.4 },
        [23] = { x = 420.1, y = 0, z = 446.4 },
        [24] = { x = 433.7, y = 0, z = 446.5 },
        [25] = { x = 433.4, y = 0, z = 460.0 },
        [26] = { x = 446.2, y = 0, z = 460.0 },
        [27] = { x = 450.9, y = 0, z = 469.0 },
        [28] = { x = 450.9, y = 0, z = 460.1 },
        [29] = { x = 451.1, y = 0, z = 451.2 },
        [30] = { x = 460.0, y = 0, z = 450.9 },
        [31] = { x = 469.1, y = 0, z = 451.0 },
        [32] = { x = 469.0, y = 0, z = 459.9 },
        [33] = { x = 468.8, y = 0, z = 468.9 },
        [34] = { x = 460.1, y = 0, z = 468.9 },
        [35] = { x = 455.6, y = 0, z = 464.4 },
        [36] = { x = 455.5, y = 0, z = 455.4 },
        [37] = { x = 464.4, y = 0, z = 455.2 },
        [38] = { x = 464.7, y = 0, z = 464.4 },
        [39] = { x = 486.6, y = 0, z = 460.0 },
        [40] = { x = 486.5, y = 0, z = 473.5 },
        [41] = { x = 486.4, y = 0, z = 446.6 },
        [42] = { x = 500.0, y = 0, z = 446.6 },
        [43] = { x = 513.5, y = 0, z = 446.6 },
        [44] = { x = 504.5, y = 0, z = 455.4 },
        [45] = { x = 496.2, y = 0, z = 459.9 },
        [46] = { x = 504.4, y = 0, z = 464.3 },
        [47] = { x = 513.5, y = 0, z = 473.6 },
        [48] = { x = 500.0, y = 0, z = 473.4 },
        [49] = { x = 420.2, y = 0, z = 433.7 },
        [50] = { x = 422.0, y = 0, z = 421.9 },
        [51] = { x = 433.2, y = 0, z = 420.2 },
    },

    [8] = -- TODO: We need to add more spawn points to this layout to not run out of entries.
    {
        [ 1] = { x =  86.4, y = 0, z = -340.1 },
        [ 2] = { x =  98.4, y = 0, z = -342.0 },
        [ 3] = { x = 100.0, y = 0, z = -353.4 },
        [ 4] = { x = 104.0, y = 0, z = -366.6 },
        [ 5] = { x =  95.8, y = 0, z = -366.5 },
        [ 6] = { x = 104.5, y = 0, z = -375.6 },
        [ 7] = { x = 108.8, y = 0, z = -379.8 },
        [ 8] = { x = 100.2, y = 0, z = -380.0 },
        [ 9] = { x =  90.8, y = 0, z = -380.1 },
        [10] = { x =  95.3, y = 0, z = -384.5 },
        [11] = { x = 104.4, y = 0, z = -384.4 },
        [12] = { x = 102.3, y = 0, z = -393.5 },
        [13] = { x =  95.7, y = 0, z = -393.2 },
        [14] = { x =  95.6, y = 0, z = -375.6 },
        [15] = { x = 100.1, y = 0, z = -406.6 },
        [16] = { x =  97.8, y = 0, z = -418.0 },
        [17] = { x =  86.3, y = 0, z = -420.0 },
        [18] = { x =  60.0, y = 0, z = -313.2 },
        [19] = { x =  58.0, y = 0, z = -302.1 },
        [20] = { x =  46.4, y = 0, z = -300.2 },
        [21] = { x =  33.7, y = 0, z = -340.1 },
        [22] = { x =  21.8, y = 0, z = -342.0 },
        [23] = { x =  20.3, y = 0, z = -353.6 },
    },

    [9] =
    {
        [ 1] = { x =  20.1, y = 0, z = -473.9 },
        [ 2] = { x =  33.3, y = 0, z = -473.3 },
        [ 3] = { x =  33.4, y = 0, z = -460.2 },
        [ 4] = { x =  33.5, y = 0, z = -446.5 },
        [ 5] = { x =  24.4, y = 0, z = -455.3 },
        [ 6] = { x =  20.0, y = 0, z = -464.7 },
        [ 7] = { x =  15.5, y = 0, z = -455.4 },
        [ 8] = { x =   6.8, y = 0, z = -446.6 },
        [ 9] = { x =   6.3, y = 0, z = -460.6 },
        [10] = { x = -11.0, y = 0, z = -460.1 },
        [11] = { x = -11.0, y = 0, z = -451.1 },
        [12] = { x = -11.0, y = 0, z = -468.9 },
        [13] = { x = -15.4, y = 0, z = -464.4 },
        [14] = { x = -15.5, y = 0, z = -455.5 },
        [15] = { x = -20.0, y = 0, z = -450.9 },
        [16] = { x = -20.2, y = 0, z = -460.0 },
        [17] = { x = -20.3, y = 0, z = -468.6 },
        [18] = { x = -24.3, y = 0, z = -464.5 },
        [19] = { x = -24.8, y = 0, z = -454.8 },
        [20] = { x = -28.9, y = 0, z = -451.3 },
        [21] = { x = -29.0, y = 0, z = -460.0 },
        [22] = { x = -29.2, y = 0, z = -469.1 },
        [23] = { x = -60.2, y = 0, z = -473.7 },
        [24] = { x = -46.5, y = 0, z = -460.0 },
        [25] = { x = -46.5, y = 0, z = -446.4 },
        [26] = { x = -46.6, y = 0, z = -473.7 },
        [27] = { x = -60.2, y = 0, z = -446.4 },
        [28] = { x = -73.6, y = 0, z = -446.6 },
        [29] = { x = -64.5, y = 0, z = -455.6 },
        [30] = { x = -55.9, y = 0, z = -459.9 },
        [31] = { x = -64.8, y = 0, z = -464.6 },
        [32] = { x = -73.5, y = 0, z = -473.4 },
        [33] = { x = -59.9, y = 0, z = -486.0 },
        [34] = { x = -57.9, y = 0, z = -498.0 },
        [35] = { x = -46.4, y = 0, z = -500.0 },
        [36] = { x =  -7.0, y = 0, z = -503.9 },
        [37] = { x =  -6.9, y = 0, z = -495.8 },
        [38] = { x = -15.6, y = 0, z = -495.7 },
        [39] = { x = -15.3, y = 0, z = -504.6 },
        [40] = { x = -20.2, y = 0, z = -509.3 },
        [41] = { x = -20.2, y = 0, z = -500.0 },
        [42] = { x = -20.1, y = 0, z = -491.0 },
        [43] = { x = -24.7, y = 0, z = -495.2 },
        [44] = { x = -24.4, y = 0, z = -504.7 },
        [45] = { x = -28.9, y = 0, z = -500.0 },
    },

    [10] =
    {
        [ 1] = { x = -100.0, y = 0, z =  86.5 },
        [ 2] = { x =  -98.0, y = 0, z =  98.0 },
        [ 3] = { x =  -86.6, y = 0, z =  99.9 },
        [ 4] = { x =  -73.4, y = 0, z =  95.8 },
        [ 5] = { x =  -73.5, y = 0, z = 104.7 },
        [ 6] = { x =  -64.7, y = 0, z = 113.5 },
        [ 7] = { x =  -55.7, y = 0, z = 113.5 },
        [ 8] = { x =  -46.6, y = 0, z = 104.5 },
        [ 9] = { x =  -46.5, y = 0, z =  95.9 },
        [10] = { x =  -55.5, y = 0, z =  86.5 },
        [11] = { x =  -64.4, y = 0, z =  86.5 },
        [12] = { x =  -64.3, y = 0, z =  95.3 },
        [13] = { x =  -64.3, y = 0, z = 104.2 },
        [14] = { x =  -55.6, y = 0, z = 104.2 },
        [15] = { x =  -55.6, y = 0, z =  95.3 },
        [16] = { x =  -99.9, y = 0, z =  33.8 },
        [17] = { x =  -97.8, y = 0, z =  21.9 },
        [18] = { x =  -86.8, y = 0, z =  20.2 },
        [19] = { x =  -73.1, y = 0, z =  15.0 },
        [20] = { x =  -73.5, y = 0, z =  24.1 },
        [21] = { x =  -64.4, y = 0, z =  33.2 },
        [22] = { x =  -55.7, y = 0, z =  33.5 },
        [23] = { x =  -46.5, y = 0, z =  24.5 },
        [24] = { x =  -47.1, y = 0, z =  15.8 },
        [25] = { x =  -55.2, y = 0, z =   6.7 },
        [26] = { x =  -64.0, y = 0, z =   6.6 },
        [27] = { x =  -64.4, y = 0, z =  15.3 },
        [28] = { x =  -64.7, y = 0, z =  24.2 },
        [29] = { x =  -55.9, y = 0, z =  24.5 },
        [30] = { x =  -55.7, y = 0, z =  15.9 },
    },

    [11] =
    {
        [ 1] = { x = 100.1, y = 0, z =  73.5 },
        [ 2] = { x =  86.8, y = 0, z =  73.7 },
        [ 3] = { x = 113.2, y = 0, z =  73.5 },
        [ 4] = { x = 104.3, y = 0, z =  64.3 },
        [ 5] = { x =  96.1, y = 0, z =  59.9 },
        [ 6] = { x = 104.4, y = 0, z =  55.5 },
        [ 7] = { x = 113.5, y = 0, z =  46.9 },
        [ 8] = { x = 100.2, y = 0, z =  46.7 },
        [ 9] = { x =  86.4, y = 0, z =  47.3 },
        [10] = { x =  86.6, y = 0, z =  59.7 },
        [11] = { x =  74.1, y = 0, z = 104.2 },
        [12] = { x =  65.0, y = 0, z = 113.3 },
        [13] = { x =  56.1, y = 0, z = 113.2 },
        [14] = { x =  47.4, y = 0, z = 105.0 },
        [15] = { x =  46.8, y = 0, z =  96.2 },
        [16] = { x =  55.5, y = 0, z =  86.7 },
        [17] = { x =  64.4, y = 0, z =  86.5 },
        [18] = { x =  60.0, y = 0, z =  90.8 },
        [19] = { x =  68.8, y = 0, z = 100.0 },
        [20] = { x =  60.1, y = 0, z =  73.6 },
        [21] = { x =  46.5, y = 0, z =  73.5 },
        [22] = { x =  73.2, y = 0, z =  73.5 },
        [23] = { x =  73.3, y = 0, z =  59.9 },
        [24] = { x =  73.6, y = 0, z =  46.6 },
        [25] = { x =  60.0, y = 0, z =  46.6 },
        [26] = { x =  46.1, y = 0, z =  46.7 },
        [27] = { x =  55.5, y = 0, z =  55.4 },
        [28] = { x =  64.0, y = 0, z =  59.9 },
        [29] = { x =  55.6, y = 0, z =  64.7 },
        [30] = { x =  55.9, y = 0, z =  34.0 },
        [31] = { x =  63.7, y = 0, z =  34.1 },
        [32] = { x =  47.1, y = 0, z =  25.0 },
        [33] = { x =  46.8, y = 0, z =  15.8 },
        [34] = { x =  56.6, y = 0, z =   7.8 },
        [35] = { x =  63.8, y = 0, z =   6.6 },
        [36] = { x =  73.0, y = 0, z =  15.3 },
        [37] = { x =  73.2, y = 0, z =  24.2 },
        [38] = { x =  64.6, y = 0, z =  24.4 },
        [39] = { x =  68.9, y = 0, z =  20.2 },
        [40] = { x =  69.0, y = 0, z =  29.0 },
        [41] = { x =  86.6, y = 0, z =  20.0 },
        [42] = { x =  97.9, y = 0, z =  21.8 },
        [43] = { x =  99.9, y = 0, z =  33.3 },
    },

    [12] =
    {
        [ 1] = { x = -433.4, y = -4, z = -175.4 },
        [ 2] = { x = -415.5, y = -4, z = -193.2 },
        [ 3] = { x = -415.3, y = -4, z = -167.2 },
        [ 4] = { x = -433.7, y = -4, z = -220.2 },
        [ 5] = { x = -419.9, y = -2, z = -220.3 },
        [ 6] = { x = -406.8, y =  0, z = -220.1 },
        [ 7] = { x = -393.3, y =  0, z = -220.1 },
        [ 8] = { x = -382.1, y =  0, z = -221.9 },
        [ 9] = { x = -380.1, y =  0, z = -233.6 },
        [10] = { x = -384.2, y =  0, z = -246.1 },
        [11] = { x = -375.8, y =  0, z = -246.3 },
        [12] = { x = -393.4, y =  0, z = -255.4 },
        [13] = { x = -393.3, y =  0, z = -264.1 },
        [14] = { x = -384.7, y =  0, z = -273.5 },
        [15] = { x = -376.0, y =  0, z = -273.5 },
        [16] = { x = -367.0, y =  0, z = -265.2 },
        [17] = { x = -366.7, y =  0, z = -255.6 },
        [18] = { x = -375.4, y =  0, z = -255.8 },
        [19] = { x = -384.7, y =  0, z = -255.5 },
        [20] = { x = -384.9, y =  0, z = -264.5 },
        [21] = { x = -375.4, y =  0, z = -264.6 },
        [22] = { x = -353.7, y =  0, z = -259.8 },
        [23] = { x = -342.2, y =  0, z = -262.2 },
        [24] = { x = -340.0, y =  0, z = -273.4 },
        [25] = { x = -344.1, y =  0, z = -286.1 },
        [26] = { x = -335.9, y =  0, z = -286.1 },
        [27] = { x = -326.9, y =  0, z = -294.9 },
        [28] = { x = -326.8, y =  0, z = -303.7 },
        [29] = { x = -340.2, y =  0, z = -300.0 },
        [30] = { x = -353.1, y =  0, z = -304.3 },
        [31] = { x = -353.2, y =  0, z = -296.0 },
        [32] = { x = -344.5, y =  0, z = -295.5 },
        [33] = { x = -366.3, y =  0, z = -299.8 },
        [34] = { x = -366.6, y =  0, z = -286.7 },
        [35] = { x = -366.4, y =  0, z = -313.2 },
        [36] = { x = -380.0, y =  0, z = -313.5 },
        [37] = { x = -393.5, y =  0, z = -313.6 },
        [38] = { x = -384.5, y =  0, z = -304.7 },
        [39] = { x = -376.2, y =  0, z = -300.1 },
        [40] = { x = -384.5, y =  0, z = -295.3 },
        [41] = { x = -393.4, y =  0, z = -286.7 },
        [42] = { x = -406.7, y =  0, z = -260.0 },
        [43] = { x = -419.1, y = -2, z = -260.0 },
        [44] = { x = -433.6, y = -4, z = -260.2 },
        [45] = { x = -446.4, y = -4, z = -260.0 },
        [46] = { x = -446.7, y = -4, z = -246.7 },
        [47] = { x = -455.3, y = -4, z = -255.5 },
        [48] = { x = -460.2, y = -4, z = -264.0 },
        [49] = { x = -464.5, y = -4, z = -255.6 },
        [50] = { x = -473.6, y = -4, z = -246.9 },
        [51] = { x = -473.8, y = -4, z = -259.9 },
        [52] = { x = -473.7, y = -4, z = -273.0 },
        [53] = { x = -460.1, y = -4, z = -273.3 },
        [54] = { x = -460.1, y = -4, z = -286.5 },
        [55] = { x = -460.0, y =  0, z = -313.6 }, -- TODO: Check this coordinate.
        [56] = { x = -446.4, y = -4, z = -273.2 },
        [57] = { x = -460.3, y = -2, z = -300.3 },
        [58] = { x = -495.4, y = -4, z = -184.3 },
        [59] = { x = -495.3, y = -4, z = -175.5 },
        [60] = { x = -504.4, y = -4, z = -175.9 },
        [61] = { x = -504.6, y = -4, z = -184.5 },
        [62] = { x = -526.1, y = -4, z = -180.1 },
        [63] = { x = -538.1, y = -4, z = -181.9 },
        [64] = { x = -540.0, y = -4, z = -193.1 },
        [65] = { x = -420.1, y = -4, z = -170.8 },
        [66] = { x = -420.0, y = -4, z = -179.8 },
        [67] = { x = -420.0, y = -4, z = -188.7 },
        [68] = { x = -433.4, y = -4, z = -183.9 },
    },

    [13] = -- room 0 north, south
    {
        [ 1] = { x = -304.2, y = 0, z = -353.6 },
        [ 2] = { x = -309.1, y = 0, z = -348.9 },
        [ 3] = { x = -300.0, y = 0, z = -348.9 },
        [ 4] = { x = -290.9, y = 0, z = -348.9 },
        [ 5] = { x = -286.5, y = 0, z = -344.5 },
        [ 6] = { x = -286.7, y = 0, z = -335.9 },
        [ 7] = { x = -291.0, y = 0, z = -330.8 },
        [ 8] = { x = -309.1, y = 0, z = -330.9 },
        [ 9] = { x = -273.7, y = 0, z = -340.0 }, -- room 2 corner south, west
        [10] = { x = -262.2, y = 0, z = -342.1 },
        [11] = { x = -259.9, y = 0, z = -353.3 },
        [12] = { x = -264.5, y = 0, z = -366.5 }, -- room 3 north, south
        [13] = { x = -255.8, y = 0, z = -366.4 },
        [14] = { x = -255.7, y = 0, z = -375.5 },
        [15] = { x = -264.3, y = 0, z = -375.6 },
        [16] = { x = -269.1, y = 0, z = -380.2 },
        [17] = { x = -259.7, y = 0, z = -379.8 },
        [18] = { x = -250.8, y = 0, z = -380.1 },
        [19] = { x = -255.7, y = 0, z = -384.6 },
        [20] = { x = -264.4, y = 0, z = -384.4 },
        [21] = { x = -264.5, y = 0, z = -393.0 },
        [22] = { x = -255.7, y = 0, z = -393.4 },
        [23] = { x = -260.1, y = 0, z = -406.7 }, -- room 4 corner north, west
        [24] = { x = -262.1, y = 0, z = -417.8 },
        [25] = { x = -273.8, y = 0, z = -419.9 },
        [26] = { x = -286.1, y = 0, z = -415.9 }, -- room 5 east, north
        [27] = { x = -286.3, y = 0, z = -424.3 },
        [28] = { x = -291.1, y = 0, z = -428.9 },
        [29] = { x = -291.0, y = 0, z = -420.0 },
        [30] = { x = -290.9, y = 0, z = -411.0 },
        [31] = { x = -294.3, y = 0, z = -406.6 },
        [32] = { x = -304.4, y = 0, z = -406.5 },
        [33] = { x = -309.1, y = 0, z = -411.5 },
        [34] = { x = -309.1, y = 0, z = -429.0 },
        [35] = { x = -300.1, y = 0, z = -429.1 },
        [36] = { x = -300.1, y = 0, z = -411.1 },
        [37] = { x = -295.8, y = 0, z = -353.6 }, -- room 1 south, east
    },

    [14] = -- (-380 -0.5 -500) room 0 north, east, west
    {
        [ 1] = { x = -341.9, y =  0, z = -497.9 },
        [ 2] = { x = -340.1, y =  0, z = -486.3 },
        [ 3] = { x = -336.0, y =  0, z = -473.8 }, -- room 2 south, west
        [ 4] = { x = -344.1, y =  0, z = -473.7 },
        [ 5] = { x = -330.8, y =  0, z = -468.9 },
        [ 6] = { x = -331.1, y =  0, z = -459.9 },
        [ 7] = { x = -331.0, y =  0, z = -451.1 },
        [ 8] = { x = -339.9, y =  0, z = -450.9 },
        [ 9] = { x = -340.1, y =  0, z = -459.9 },
        [10] = { x = -349.2, y =  0, z = -469.1 },
        [11] = { x = -353.4, y =  0, z = -464.4 },
        [12] = { x = -353.5, y =  0, z = -455.7 },
        [13] = { x = -349.0, y =  0, z = -450.9 },
        [14] = { x = -349.0, y =  0, z = -460.1 },
        [15] = { x = -366.6, y =  0, z = -473.6 }, -- room 3 east, south
        [16] = { x = -366.6, y =  0, z = -460.1 },
        [17] = { x = -366.5, y =  0, z = -446.4 },
        [18] = { x = -380.0, y =  0, z = -446.5 },
        [19] = { x = -393.4, y =  0, z = -446.3 },
        [20] = { x = -384.6, y =  0, z = -455.6 },
        [21] = { x = -375.7, y =  0, z = -460.1 },
        [22] = { x = -384.5, y =  0, z = -464.4 },
        [23] = { x = -393.5, y =  0, z = -473.2 },
        [24] = { x = -380.1, y =  0, z = -473.5 },
        [25] = { x = -406.6, y =  0, z = -500.0 }, -- room 4 hall east, west
        [26] = { x = -419.5, y = -2, z = -500.1 },
        [27] = { x = -433.4, y = -4, z = -499.9 },
        [28] = { x = -446.4, y = -4, z = -500.0 }, -- room 5 east, north
        [29] = { x = -446.4, y = -4, z = -486.4 },
        [30] = { x = -446.4, y = -4, z = -513.3 },
        [31] = { x = -455.5, y = -4, z = -504.5 },
        [32] = { x = -460.0, y = -4, z = -495.7 },
        [33] = { x = -464.5, y = -4, z = -504.7 },
        [34] = { x = -473.3, y = -4, z = -513.5 },
        [35] = { x = -473.4, y = -4, z = -500.0 },
        [36] = { x = -473.6, y = -4, z = -486.2 },
        [37] = { x = -460.1, y = -4, z = -486.4 },
        [38] = { x = -460.1, y = -4, z = -473.3 }, -- room 6 hall south
        [39] = { x = -460.2, y = -2, z = -461.3 },
        [40] = { x = -460.0, y =  0, z = -446.3 },
        [41] = { x = -353.4, y =  0, z = -500.0 }, -- room 1 corner west, north
    },

    [15] = -- (-459 -4.0 -540) room 0 corner east, south
    {
        [ 1] = { x = -456.1, y = -4, z = -566.5 },
        [ 2] = { x = -460.0, y = -4, z = -571.1 },
        [ 3] = { x = -473.2, y = -4, z = -575.8 },
        [ 4] = { x = -473.4, y = -4, z = -584.4 },
        [ 5] = { x = -469.2, y = -4, z = -579.9 },
        [ 6] = { x = -460.0, y = -4, z = -579.9 },
        [ 7] = { x = -451.0, y = -4, z = -579.9 },
        [ 8] = { x = -446.8, y = -4, z = -575.6 },
        [ 9] = { x = -446.5, y = -4, z = -584.4 },
        [10] = { x = -486.4, y = -4, z = -575.6 }, -- room 2 east, west
        [11] = { x = -486.5, y = -4, z = -584.2 },
        [12] = { x = -491.2, y = -4, z = -589.1 },
        [13] = { x = -491.0, y = -4, z = -580.0 },
        [14] = { x = -490.9, y = -4, z = -571.0 },
        [15] = { x = -500.0, y = -4, z = -571.0 },
        [16] = { x = -500.2, y = -4, z = -580.2 },
        [17] = { x = -500.0, y = -4, z = -588.8 },
        [18] = { x = -509.0, y = -4, z = -588.8 },
        [19] = { x = -509.2, y = -4, z = -579.9 },
        [20] = { x = -508.9, y = -4, z = -571.2 },
        [21] = { x = -512.9, y = -4, z = -574.5 },
        [22] = { x = -513.6, y = -4, z = -584.3 },
        [23] = { x = -526.7, y = -4, z = -580.1 }, -- room 3 corner east, north
        [24] = { x = -538.1, y = -4, z = -577.9 },
        [25] = { x = -540.1, y = -4, z = -566.6 },
        [26] = { x = -433.6, y = -4, z = -584.1 }, -- room 4  west
        [27] = { x = -433.7, y = -4, z = -575.8 },
        [28] = { x = -428.9, y = -4, z = -570.8 },
        [29] = { x = -429.0, y = -4, z = -580.1 },
        [30] = { x = -429.2, y = -4, z = -588.9 },
        [31] = { x = -420.1, y = -4, z = -589.2 },
        [32] = { x = -419.9, y = -4, z = -580.1 },
        [33] = { x = -419.9, y = -4, z = -571.2 },
        [34] = { x = -411.0, y = -4, z = -571.1 },
        [35] = { x = -410.9, y = -4, z = -580.0 },
        [36] = { x = -411.1, y = -4, z = -589.0 },
        [37] = { x = -433.8, y = -4, z = -540.1 }, -- room 6 hall west, east
        [38] = { x = -421.3, y = -2, z = -539.9 },
        [39] = { x = -406.3, y =  0, z = -540.1 },
        [40] = { x = -393.9, y =  0, z = -540.0 }, -- room 7 corner west
        [41] = { x = -382.0, y =  0, z = -538.1 },
        [42] = { x = -379.9, y =  0, z = -526.8 },
        [43] = { x = -464.4, y = -4, z = -566.1 }, -- room 1 north, east, west
    },

    [16] = -- (-465 -4.0 -340) room 0 west, south
    {
        [ 1] = { x = -464.3, y =  0, z = -366.5 },
        [ 2] = { x = -469.0, y =  0, z = -370.9 },
        [ 3] = { x = -460.1, y =  0, z = -371.1 },
        [ 4] = { x = -451.2, y =  0, z = -371.1 },
        [ 5] = { x = -451.0, y =  0, z = -380.1 },
        [ 6] = { x = -460.0, y =  0, z = -380.0 },
        [ 7] = { x = -469.0, y =  0, z = -380.1 },
        [ 8] = { x = -469.0, y =  0, z = -388.9 },
        [ 9] = { x = -460.1, y =  0, z = -389.1 },
        [10] = { x = -450.8, y =  0, z = -388.9 },
        [11] = { x = -455.4, y =  0, z = -393.5 },
        [12] = { x = -464.3, y =  0, z = -393.6 },
        [13] = { x = -473.7, y =  0, z = -406.4 }, -- room 2 north
        [14] = { x = -460.1, y =  0, z = -406.6 },
        [15] = { x = -446.5, y =  0, z = -406.5 },
        [16] = { x = -455.6, y =  0, z = -415.5 },
        [17] = { x = -464.5, y =  0, z = -419.8 },
        [18] = { x = -455.3, y =  0, z = -424.6 },
        [19] = { x = -446.3, y =  0, z = -433.6 },
        [20] = { x = -460.1, y =  0, z = -433.6 },
        [21] = { x = -473.4, y =  0, z = -433.4 },
        [22] = { x = -473.4, y =  0, z = -420.0 },
        [23] = { x = -486.5, y =  0, z = -340.0 }, -- room 3 hall east, west
        [24] = { x = -500.4, y = -2, z = -340.2 },
        [25] = { x = -513.7, y = -4, z = -340.1 },
        [26] = { x = -526.6, y = -4, z = -335.7 }, -- room 4 east
        [27] = { x = -531.0, y = -4, z = -331.0 },
        [28] = { x = -531.1, y = -4, z = -340.2 },
        [29] = { x = -526.5, y = -4, z = -344.3 },
        [30] = { x = -531.2, y = -4, z = -349.0 },
        [31] = { x = -540.2, y = -4, z = -349.0 },
        [32] = { x = -540.1, y = -4, z = -340.0 },
        [33] = { x = -540.0, y = -4, z = -331.1 },
        [34] = { x = -548.8, y = -4, z = -331.7 },
        [35] = { x = -548.9, y = -4, z = -340.1 },
        [36] = { x = -549.1, y = -4, z = -349.0 },
        [37] = { x = -455.6, y =  0, z = -366.2 }, -- room 1 north, south
    },

    [17] = -- 504.5, 0.0, -60
    {
        [ 1] = { x =   514, y = 0, z =    -86 },
        [ 2] = { x =   514, y = 0, z =    -95 },
        [ 3] = { x =   514, y = 0, z =   -104 },
        [ 4] = { x =   514, y = 0, z =   -114 },
        [ 5] = { x =   504, y = 0, z =   -114 },
        [ 6] = { x =   495, y = 0, z =   -114 },
        [ 7] = { x =   485, y = 0, z =   -114 },
        [ 8] = { x =   485, y = 0, z =   -104 },
        [ 9] = { x =   486, y = 0, z =  -95.5 },
        [10] = { x =   486, y = 0, z =    -86 },
        [11] = { x =   495, y = 0, z =    -86 },
        [12] = { x =   504, y = 0, z =    -86 },
        [13] = { x =   504, y = 0, z =  -95.5 },
        [14] = { x =   504, y = 0, z = -104.5 },
        [15] = { x =   495, y = 0, z = -104.5 },
        [16] = { x =   495, y = 0, z =  -95.5 },
        [17] = { x =   500, y = 0, z =   -100 },
        [18] = { x =   500, y = 0, z =   -109 },
        [19] = { x =   491, y = 0, z =   -100 },
        [20] = { x =   500, y = 0, z =    -91 },
        [21] = { x =   509, y = 0, z =   -100 },
        [22] = { x = 473.5, y = 0, z =   -100 },
        [23] = { x = 463.5, y = 0, z =    -98 },
        [24] = { x =   458, y = 0, z =    -98 },
        [25] = { x =   457, y = 0, z =   -104 },
        [26] = { x =   462, y = 0, z =   -102 },

        [27] = { x =   526, y = 0, z =   -104 },
        [28] = { x =   526, y = 0, z = -113.5 },
        [29] = { x =   535, y = 0, z = -113.5 },
        [30] = { x =   544, y = 0, z = -113.5 },
        [31] = { x = 553.5, y = 0, z = -104.5 },
        [32] = { x = 553.5, y = 0, z =  -95.5 },
        [33] = { x = 553.5, y = 0, z =  -86.5 },
        [34] = { x = 544.5, y = 0, z =    -86 },
        [35] = { x = 544.5, y = 0, z =  -95.5 },
        [36] = { x = 544.5, y = 0, z = -104.5 },
        [37] = { x =   540, y = 0, z = -104.5 },
        [38] = { x =   535, y = 0, z = -104.5 },
        [39] = { x =   535, y = 0, z =  -95.5 },
        [40] = { x =   535, y = 0, z =    -87 },
        [41] = { x =   526, y = 0, z =  -86.5 },
        [42] = { x =   526, y = 0, z =  -95.5 },

        [43] = { x =   566, y = 0, z =   -100 },
        [44] = { x =   575, y = 0, z =   -100 },
        [45] = { x =   584, y = 0, z =   -100 },
        [46] = { x =   593, y = 0, z =   -100 },

        [47] = { x =   500, y = 0, z =   -126 },
        [48] = { x =   500, y = 0, z =   -135 },
        [49] = { x =   500, y = 0, z =   -144 },
        [50] = { x =   500, y = 0, z =   -154 },

        [51] = { x =   500, y = 0, z =   -180 },
        [52] = { x =   500, y = 0, z =   -189 },
        [53] = { x =   500, y = 0, z =   -172 },
        [54] = { x =   508, y = 0, z =   -180 },
        [55] = { x =   492, y = 0, z =   -180 },
        [56] = { x = 495.5, y = 0, z =   -193 },
        [57] = { x =   504, y = 0, z = -193.5 },
        [58] = { x = 513.5, y = 0, z = -193.5 },
        [59] = { x = 486.5, y = 0, z = -193.5 },
        [60] = { x =   495, y = 0, z = -193.5 },
        [61] = { x =   504, y = 0, z = -193.5 },
        [62] = { x =   513, y = 0, z = -193.5 },
        [63] = { x = 513.5, y = 0, z =   -185 },
        [64] = { x = 513.5, y = 0, z =   -176 },
        [65] = { x =   513, y = 0, z = -166.5 },
        [66] = { x =   505, y = 0, z = -166.5 },
        [67] = { x =   495, y = 0, z = -166.5 },
        [68] = { x = 486.5, y = 0, z = -166.5 },
        [69] = { x =   495, y = 0, z = -175.5 },
        [70] = { x =   504, y = 0, z = -175.5 },

        [71] = { x =   526, y = 0, z =   -184 },
        [72] = { x =   526, y = 0, z = -193.5 },
        [73] = { x =   534, y = 0, z = -193.5 },
        [74] = { x = 535.5, y = 0, z = -184.5 },
        [75] = { x = 535.5, y = 0, z = -175.5 },
        [76] = { x =   540, y = 0, z =  175.5 },
        [77] = { x = 544.5, y = 0, z = -175.5 },
        [78] = { x = 544.5, y = 0, z = -184.5 },
        [79] = { x = 544.5, y = 0, z =   -193 },
        [80] = { x = 553.5, y = 0, z = -193.5 },
        [81] = { x = 553.5, y = 0, z = -184.5 },
        [82] = { x = 553.5, y = 0, z =   -176 },
        [83] = { x = 553.5, y = 0, z = -166.5 },
        [84] = { x = 544.5, y = 0, z = -166.5 },
        [85] = { x = 553.5, y = 0, z = -166.5 },
        [86] = { x = 526.5, y = 0, z = -166.5 },
        [87] = { x = 526.5, y = 0, z =   -175 },

        [88] = { x = 566.5, y = 0, z =   -180 },
        [89] = { x =   574, y = 0, z =   -180 },
        [90] = { x =   580, y = 0, z =   -174 },
        [91] = { x =   580, y = 0, z = -166.5 },
        [92] = { x =   582, y = 0, z =   -182 },
    }
}

local pTableEnemyLeaders =
{
    -- [Floor_Section] = { first_mob_id, last_mob_id },
    [  1] = { ID.mob[51].MOKKE,           ID.mob[51].LONG_HORNED_CHARIOT }, -- Regular enemy leaders. Can appear on all floors, except floor-20 multiples.
    [ 40] = { ID.mob[51].ADAMANTOISE,     ID.mob[51].ADAMANTOISE + 2     }, -- Floors 1 to 40 bosses. Original Land Kings.
    [100] = { ID.mob[51].ADAMANTOISE + 3, ID.mob[51].ADAMANTOISE + 5     }, -- Floors 60 to 100 bosses. ToAU Land Kings.
}

local pTableSpecifiedMobs =
{
    -- [Mob family] = { first_mob_id, last_mob_id },
    [1] = { ID.mob[51].OFFSET_SPECIFIED,      ID.mob[51].OFFSET_SPECIFIED +  4 }, -- Heraldic Imp x5
    [2] = { ID.mob[51].OFFSET_SPECIFIED +  5, ID.mob[51].OFFSET_SPECIFIED +  9 }, -- Psycheflayer x5
    [3] = { ID.mob[51].OFFSET_SPECIFIED + 10, ID.mob[51].OFFSET_SPECIFIED + 14 }, -- Poroggo Gent x5
    [4] = { ID.mob[51].OFFSET_SPECIFIED + 15, ID.mob[51].OFFSET_SPECIFIED + 19 }, -- Ebony Pudding x5
    [5] = { ID.mob[51].OFFSET_SPECIFIED + 20, ID.mob[51].OFFSET_SPECIFIED + 21 }, -- Qiqirn_Treasure_Hunter x2
    [6] = { ID.mob[51].OFFSET_SPECIFIED + 22, ID.mob[51].OFFSET_SPECIFIED + 24 }, -- Qiqirn_Archaeologist x3
    [7] = { ID.mob[51].OFFSET_SPECIFIED + 25, ID.mob[51].OFFSET_SPECIFIED + 29 }, -- Racing_Chariot x5
}

local pTableEvenFloorRandomNMs =
{
    -- [Floor_Section] = { first_mob_id, last_mob_id },
    [1] = { ID.mob[51].OFFSET_NM,      ID.mob[51].OFFSET_NM +  8 }, -- Floors 1 to 20.
    [2] = { ID.mob[51].OFFSET_NM + 18, ID.mob[51].OFFSET_NM + 26 }, -- Floors 21 to 40.
    [3] = { ID.mob[51].OFFSET_NM + 36, ID.mob[51].OFFSET_NM + 44 }, -- Floors 41 to 60.
    [4] = { ID.mob[51].OFFSET_NM + 54, ID.mob[51].OFFSET_NM + 62 }, -- Floors 61 to 80.
    [5] = { ID.mob[51].OFFSET_NM + 72, ID.mob[51].OFFSET_NM + 80 }, -- Floors 81 to 100.
}

local pTableOddFloorRandomNMs =
{
    -- [Floor_Section] = { first_mob_id, last_mob_id },
    [1] = { ID.mob[51].OFFSET_NM +  9, ID.mob[51].OFFSET_NM + 17 }, -- Floors 1 to 20.
    [2] = { ID.mob[51].OFFSET_NM + 27, ID.mob[51].OFFSET_NM + 35 }, -- Floors 21 to 40.
    [3] = { ID.mob[51].OFFSET_NM + 45, ID.mob[51].OFFSET_NM + 53 }, -- Floors 41 to 60.
    [4] = { ID.mob[51].OFFSET_NM + 63, ID.mob[51].OFFSET_NM + 71 }, -- Floors 61 to 80.
    [5] = { ID.mob[51].OFFSET_NM + 81, ID.mob[51].OFFSET_NM + 89 }, -- Floors 81 to 100.
}

local pTableFloorRandomEntities =
{
    -- [Mob family] = { first_mob_id, last_mob_id },
    [ 1] = { ID.mob[51].OFFSET_REGULAR,       ID.mob[51].OFFSET_REGULAR +  11 }, -- Aquans
    [ 2] = { ID.mob[51].OFFSET_REGULAR +  12, ID.mob[51].OFFSET_REGULAR +  23 }, -- Amorphs
    [ 3] = { ID.mob[51].OFFSET_REGULAR +  24, ID.mob[51].OFFSET_REGULAR +  35 }, -- Arcana
    [ 4] = { ID.mob[51].OFFSET_REGULAR +  36, ID.mob[51].OFFSET_REGULAR +  47 }, -- Undead
    [ 5] = { ID.mob[51].OFFSET_REGULAR +  48, ID.mob[51].OFFSET_REGULAR +  59 }, -- Vermin
    [ 6] = { ID.mob[51].OFFSET_REGULAR +  60, ID.mob[51].OFFSET_REGULAR +  71 }, -- Demons
    [ 7] = { ID.mob[51].OFFSET_REGULAR +  72, ID.mob[51].OFFSET_REGULAR +  83 }, -- Dragons
    [ 8] = { ID.mob[51].OFFSET_REGULAR +  84, ID.mob[51].OFFSET_REGULAR +  95 }, -- Birds
    [ 9] = { ID.mob[51].OFFSET_REGULAR +  96, ID.mob[51].OFFSET_REGULAR + 107 }, -- Beasts
    [10] = { ID.mob[51].OFFSET_REGULAR + 108, ID.mob[51].OFFSET_REGULAR + 119 }, -- Plantoids
    [11] = { ID.mob[51].OFFSET_REGULAR + 120, ID.mob[51].OFFSET_REGULAR + 131 }, -- Lizards
    [12] = { ID.mob[51].OFFSET_REGULAR + 132, ID.mob[51].OFFSET_REGULAR + 143 }, -- Amorphs 2
    [13] = { ID.mob[51].OFFSET_REGULAR + 144, ID.mob[51].OFFSET_REGULAR + 155 }, -- Mixed
    [14] = { ID.mob[51].OFFSET_REGULAR + 156, ID.mob[51].OFFSET_REGULAR + 167 }, -- Mixed 2
    [15] = { ID.mob[51].OFFSET_REGULAR + 168, ID.mob[51].OFFSET_REGULAR + 179 }, -- Amorphs 3
    [16] = { ID.mob[51].OFFSET_REGULAR + 180, ID.mob[51].OFFSET_REGULAR + 191 }, -- Arcana 2
    [17] = { ID.mob[51].OFFSET_GEARS,         ID.mob[51].OFFSET_GEARS   +   5 }, -- Gears
}

-----------------------------------
-- Local functions
-----------------------------------
local function lampsActivate(instance)
    local floorLayout      = instance:getLocalVar('Nyzul_Isle_FloorLayout')
    local lampsObjective   = instance:getLocalVar('[Lamps]Objective')
    local partySize        = utils.clamp(instance:getLocalVar('partySize'), 3, 5)
    local dTableLampPoints = {}

    for i = 1, #lampSpawnPoints[floorLayout] do
        table.insert(dTableLampPoints, i, lampSpawnPoints[floorLayout][i])
    end

    -- Lamp Objective: Register
    if lampsObjective == xi.nyzul.lampsObjective.REGISTER then
        local spawnPoint = math.random(1, #dTableLampPoints)
        local runicLamp1 = GetNPCByID(ID.npc.RUNIC_LAMP_OFFSET, instance)

        -- Spawn lamps.
        runicLamp1:setPos(dTableLampPoints[spawnPoint])
        runicLamp1:setStatus(xi.status.NORMAL)

        -- Save data.
        instance:setLocalVar('[Lamp]PartySize', instance:getLocalVar('partySize'))

    -- Lamp Objective: Activate All
    elseif lampsObjective == xi.nyzul.lampsObjective.ACTIVATE_ALL then
        local runicLamps = math.random(2, partySize - 1)

        -- Spawn lamps.
        for i = ID.npc.RUNIC_LAMP_OFFSET, ID.npc.RUNIC_LAMP_OFFSET + runicLamps do
            local spawnPoint = math.random(1, #dTableLampPoints)

            GetNPCByID(i, instance):setPos(dTableLampPoints[spawnPoint])
            GetNPCByID(i, instance):setStatus(xi.status.NORMAL)
            table.remove(dTableLampPoints, spawnPoint)
        end

        -- Save data.
        instance:setLocalVar('[Lamp]count', runicLamps)

    -- Lamp Objective: Activate in Order
    elseif lampsObjective == xi.nyzul.lampsObjective.ORDER then
        local runicLamps      = math.random(2, 4)
        local dTableLampOrder = {}

        -- Select lamps.
        for j = 1, runicLamps + 1 do
            table.insert(dTableLampOrder, j)
        end

        -- Spawn lamps.
        for i = ID.npc.RUNIC_LAMP_OFFSET, ID.npc.RUNIC_LAMP_OFFSET + runicLamps do
            local spawnPoint = math.random(1, #dTableLampPoints)
            local lampRandom = math.random(1, #dTableLampOrder)

            GetNPCByID(i, instance):setPos(dTableLampPoints[spawnPoint])
            GetNPCByID(i, instance):setStatus(xi.status.NORMAL)
            GetNPCByID(i, instance):setLocalVar('[Lamp]order', dTableLampOrder[lampRandom])

            print(string.format('[NYZUL]Activate All Lamps in Order: %s', GetNPCByID(i, instance):getLocalVar('[Lamp]order')))

            table.remove(dTableLampOrder, lampRandom)
            table.remove(dTableLampPoints, spawnPoint)
        end

        -- Save data.
        instance:setLocalVar('[Lamp]count', runicLamps)
        instance:setLocalVar('[Lamp]lampRegister', 0)
    end
end

-- Fix bug in LSB where the 'if' check fails on the local var
m:addOverride('xi.nyzul.specifiedEnemySet', function(mob)
    super(mob)

    local instance = mob:getInstance()
    if instance:getStage() == xi.nyzul.objective.ELIMINATE_SPECIFIED_ENEMY then
        if instance:getLocalVar('Nyzul_Specified_Enemy') == 0 then
            print(string.format('[NYZUL]Specified Enemy Set: %s', mob))
            mob:setMobMod(xi.mobMod.CHECK_AS_NM, 1)
        end
    end
end)

-- Our only changes are from lines 94-96
-- Where we set the group of mobs to CHECK_AS_NM
m:addOverride('xi.nyzul.prepareMobs', function(instance)
    local currentFloor = instance:getLocalVar('Nyzul_Current_Floor')

    -- Failsafe: Initialize variable
    instance:setLocalVar('Nyzul_Specified_Enemy', 0)

    -- 20th floor bosses.
    if currentFloor % 20 == 0 then
        local floorBoss = 0

        if currentFloor <= 40 then
            floorBoss = math.random(pTableEnemyLeaders[40][1], pTableEnemyLeaders[40][2])
        elseif currentFloor <= 100 then
            floorBoss = math.random(pTableEnemyLeaders[100][1], pTableEnemyLeaders[100][2])
        end

        GetMobByID(ID.mob[51].ARCHAIC_RAMPART1, instance):setSpawn(-36, 0, -362, 0)
        GetMobByID(floorBoss, instance):setSpawn(-55.000, 1, -380.000, 250)
        SpawnMob(ID.mob[51].ARCHAIC_RAMPART1, instance)
        SpawnMob(floorBoss, instance)

    -- All other floors except free.
    elseif instance:getStage() ~= xi.nyzul.objective.FREE_FLOOR then
        print('[NYZUL]Free or Skipped Floor!')
        -- Build dynamic table with all the possible spawn points.
        local floorLayout      = instance:getLocalVar('Nyzul_Isle_FloorLayout')
        local spawnPointIndex  = 0
        local spawnPoint       = 0
        local dTableSpawnPoint = {}

        for i = 1, #layoutSpawnPoints[floorLayout] do
            table.insert(dTableSpawnPoint, i, layoutSpawnPoints[floorLayout][i])
        end

        -- Spawn objective-specific mobs.
        switch (instance:getStage()) : caseof
        {
            -- Enemy Leader Objective
            [xi.nyzul.objective.ELIMINATE_ENEMY_LEADER] = function()
                local floorBoss = math.random(pTableEnemyLeaders[1][1], pTableEnemyLeaders[1][2])
                spawnPointIndex = math.random(1, #dTableSpawnPoint)
                spawnPoint      = dTableSpawnPoint[spawnPointIndex]

                if floorBoss == ID.mob[51].MOKKE + 18 then
                    floorBoss = ID.mob[51].MOKKE + 17 + (math.random(0, 1) * 2)
                end

                -- Spawn Mob.
                GetMobByID(floorBoss, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
                SpawnMob(floorBoss, instance)

                -- Make sure enemy leader checks as NM
                local enemyMob = GetMobByID(floorBoss, instance)
                print(string.format('[NYZUL]Eliminate Enemy Leader: %s', enemyMob))
                enemyMob:setMobMod(xi.mobMod.CHECK_AS_NM, 1)

                -- Remove table entry.
                table.remove(dTableSpawnPoint, spawnPointIndex)
            end,

            -- Specified Enemy Group Objective
            [xi.nyzul.objective.ELIMINATE_SPECIFIED_ENEMIES] = function()
                local specificGroup         = math.random(1, 7)
                local groupAmount           = math.random(2, pTableSpecifiedMobs[specificGroup][2] - pTableSpecifiedMobs[specificGroup][1] + 1)
                local dTableSpecificEnemies = {}

                for i = pTableSpecifiedMobs[specificGroup][1], pTableSpecifiedMobs[specificGroup][2] do
                    table.insert(dTableSpecificEnemies, i)
                end

                while groupAmount > 0 do
                    local randomEnemy = math.random(1, #dTableSpecificEnemies)
                    local enemy       = dTableSpecificEnemies[randomEnemy]
                    spawnPointIndex = math.random(1, #dTableSpawnPoint)
                    spawnPoint      = dTableSpawnPoint[spawnPointIndex]

                    -- Spawn Mob.
                    GetMobByID(enemy, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
                    SpawnMob(enemy, instance)

                    -- Set mobs of the specified group to CHECK_AS_NM
                    local groupMob = GetMobByID(enemy, instance)
                    print(string.format('[NYZUL]Specified Group of Mobs: %s', groupMob))
                    groupMob:setMobMod(xi.mobMod.CHECK_AS_NM, 1)

                    -- Remove table entry.
                    table.remove(dTableSpawnPoint, spawnPointIndex)
                    table.remove(dTableSpecificEnemies, randomEnemy)

                    -- Update floor objective.
                    instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)

                    groupAmount = groupAmount - 1
                end
            end,

            -- Eliminate All Objective
            [xi.nyzul.objective.ELIMINATE_ALL_ENEMIES] = function()
                if math.random(1, 100) <= 20 then -- 20% chance that Dahank will spawn.
                    spawnPointIndex = math.random(1, #dTableSpawnPoint)
                    spawnPoint      = dTableSpawnPoint[spawnPointIndex]

                    print('[NYZUL]Objective: Eliminate All Enemies.')

                    -- Spawn Mob.
                    GetMobByID(ID.mob[51].DAHAK, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
                    SpawnMob(ID.mob[51].DAHAK, instance)

                    -- Remove table entry.
                    table.remove(dTableSpawnPoint, spawnPointIndex)

                    -- Update floor objective.
                    instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)
                end
            end,

            -- Activate Lamps Objective
            [xi.nyzul.objective.ACTIVATE_ALL_LAMPS] = function()
                instance:setLocalVar('[Lamps]Objective', math.random(xi.nyzul.lampsObjective.REGISTER, xi.nyzul.lampsObjective.ORDER))
                print('[NYZUL]Objective: Activate All Lamps')
                lampsActivate(instance)
            end,
        }

        -- Spawn Rampart-Type mobs.
        if math.random(1, 100) <= 90 then
            spawnPointIndex = math.random(1, #dTableSpawnPoint)
            spawnPoint      = dTableSpawnPoint[spawnPointIndex]

            -- Spawn Mob.
            GetMobByID(ID.mob[51].ARCHAIC_RAMPART1, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
            SpawnMob(ID.mob[51].ARCHAIC_RAMPART1, instance)

            -- Remove table entry.
            table.remove(dTableSpawnPoint, spawnPointIndex)

            -- Update floor objective.
            if instance:getStage() == xi.nyzul.objective.ELIMINATE_ALL_ENEMIES then
                instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)
            end
        end

        if math.random(1, 100) <= 20 then
            spawnPointIndex = math.random(1, #dTableSpawnPoint)
            spawnPoint      = dTableSpawnPoint[spawnPointIndex]

            -- Spawn Mob.
            GetMobByID(ID.mob[51].ARCHAIC_RAMPART2, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
            SpawnMob(ID.mob[51].ARCHAIC_RAMPART2, instance)

            -- Remove table entry.
            table.remove(dTableSpawnPoint, spawnPointIndex)

            -- Update floor objective.
            if instance:getStage() == xi.nyzul.objective.ELIMINATE_ALL_ENEMIES then
                instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)
            end
        end

        -- Spawn Gear-Type mobs.
        if instance:getLocalVar('gearObjective') > 0 then
            for i = pTableFloorRandomEntities[17][1], pTableFloorRandomEntities[17][2] do
                spawnPointIndex = math.random(1, #dTableSpawnPoint)
                spawnPoint      = dTableSpawnPoint[spawnPointIndex]

                -- Spawn Mob.
                GetMobByID(i, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
                SpawnMob(i, instance)

                -- Remove table entry.
                table.remove(dTableSpawnPoint, spawnPointIndex)
            end

            -- Update floor gear penalty.
            instance:setLocalVar('gearPenalty', math.random(xi.nyzul.penalty.TIME, xi.nyzul.penalty.PATHOS))
        end

        -- Spawn fodder NM's.
        local spawnedNMs = 0

        -- Spawn none, 1 or 2 (max) NMs
        for i = 1, 2 do
            if math.random(1, 100) <= 20 then
                spawnedNMs = spawnedNMs + 1
            end
        end

        if spawnedNMs > 0 then
            local floorSection   = math.floor(currentFloor / 20) + 1
            local mobGroup       = pTableOddFloorRandomNMs[floorSection]
            local dTableFloorNMs = {}

            -- Update mob group for even floors.
            if currentFloor % 2 == 0 then
                mobGroup = pTableEvenFloorRandomNMs[floorSection]
            end

            -- Generate table for NMs.
            for i = mobGroup[1], mobGroup[2] do
                table.insert(dTableFloorNMs, i)
            end

            while spawnedNMs > 0 do
                local index     = math.random(1, #dTableFloorNMs)
                spawnPointIndex = math.random(1, #dTableSpawnPoint)
                spawnPoint      = dTableSpawnPoint[spawnPointIndex]

                -- Spawn Mob.
                GetMobByID(dTableFloorNMs[index], instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
                SpawnMob(dTableFloorNMs[index], instance)

                -- Remove table entry.
                table.remove(dTableFloorNMs, index)
                table.remove(dTableSpawnPoint, spawnPointIndex)

                -- Update floor objective.
                if instance:getStage() == xi.nyzul.objective.ELIMINATE_ALL_ENEMIES then
                    instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)
                end

                spawnedNMs = spawnedNMs - 1
            end
        end

        -- Spawn fodder regular mobs.
        local mobFamily     = math.random(1, 16)
        local enemyAmount   = math.random(6, 12)
        local dTableEnemies = {}

        for i = pTableFloorRandomEntities[mobFamily][1], pTableFloorRandomEntities[mobFamily][2] do
            table.insert(dTableEnemies, i)
        end

        while enemyAmount > 0 do
            local randomEnemy = math.random(1, #dTableEnemies)
            local mobID       = dTableEnemies[randomEnemy]
            spawnPointIndex   = math.random(1, #dTableSpawnPoint)
            spawnPoint        = dTableSpawnPoint[spawnPointIndex]

            -- Spawn Mob.
            GetMobByID(mobID, instance):setSpawn(spawnPoint.x, spawnPoint.y, spawnPoint.z, math.random(0, 255))
            SpawnMob(mobID, instance)

            -- Remove table entry.
            table.remove(dTableEnemies, randomEnemy)
            table.remove(dTableSpawnPoint, spawnPointIndex)

            -- Update floor objective.
            if instance:getStage() == xi.nyzul.objective.ELIMINATE_ALL_ENEMIES then
                instance:setLocalVar('Eliminate', instance:getLocalVar('Eliminate') + 1)
            elseif
                instance:getStage() == xi.nyzul.objective.ELIMINATE_SPECIFIED_ENEMY and
                instance:getLocalVar('Nyzul_Specified_Enemy') == 0
            then
                instance:setLocalVar('Nyzul_Specified_Enemy', mobID)
            end

            enemyAmount = enemyAmount - 1
        end
    end
end)

return m
