-----------------------------------
-- global mobskills overrides
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("mobskills")

-- Removes gaze effects if the player turned between the time the server sent the effect and the player received the effect (assumed to be max 500ms)
m:addOverride('xi.mobskills.mobGazeMove', function(mob, target, typeEffect, power, tick, duration)
    local mobTargID = mob:getID()
    local result = super(mob, target, typeEffect, power, tick, duration)

    local failResults =
    {
        xi.msg.basic.SKILL_MISS,
        xi.msg.basic.SKILL_NO_EFFECT,
    }

    for _, failResult in pairs(failResults) do
        if failResult == result then
            return result
        end
    end

    -- gaze move succeeded, add a timer to check if the positioning was correct incorporating latency
    -- only check target's direction since the mob might have turned to another target (very unlikely in this short time it moved, though)
    target:timer(500, function(entityArg)
        local entityTarg = GetEntityByID(mobTargID)
        local entityEffect = entityArg:getStatusEffect(typeEffect)
        if
            entityEffect and
            entityTarg and
            not entityArg:isFacing(entityTarg)
        then
            entityArg:delStatusEffectSilent(typeEffect)
        end
    end)

    return result
end)

return m
