require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/utils")
require("scripts/globals/gobbie_mystery_box")
-----------------------------------

local m = Module:new("merits_gobbie_special_dial")

local costs =
{
    [1] = 10,
    [2] = 10,
    [3] = 10,
    [4] = 10,
    [5] = 10,
    [6] = 50
}
local keyToDial =
{
    [8973] = 6,  -- special dial
    [9217] = 9,  -- abjuration
    [9218] = 10, -- fortune
--  [????] = 11, -- furnishing
    [9274] = 13, -- anniversary
}
local abjurationItems =
{
    1314, 1315, 1316, 1317, 1318, -- dryadic
    1319, 1320, 1321, 1322, 1323, -- earthen
    1324, 1325, 1326, 1327, 1328, -- aquarian
    1329, 1330, 1331, 1332, 1333, -- martial
    1334, 1335, 1336, 1337, 1338, -- wyrmal
    1339, 1340, 1341, 1342, 1343, -- neptunal
    1441, 1442,                   -- food
    2429, 2430, 2431, 2432, 2433, -- phantasmal
    2434, 2435, 2436, 2437, 2438, -- hadean
    3559, 3560, 3561, 3562, 3563, -- corvine
    3564, 3565, 3566, 3567, 3568, -- supernal
    3569, 3570, 3571, 3572, 3573, -- transitory
    3574, 3575, 3576, 3577, 3578, -- foreboding
    3579, 3580, 3581, 3582, 3583, -- lenitive
    8762, 8763, 8764, 8765, 8766, -- bushin
    8767, 8768, 8769, 8770, 8771, -- vale
    8772, 8773, 8774, 8775, 8776, -- grove
    8777, 8778, 8779, 8780, 8781, -- triton
    8782, 8783, 8784, 8785, 8786, -- shinryu
    8787, 8788, 8789, 8790, 8791, -- abyssal
    9105, 9106, 9107, 9108, 9109, -- cronian
    9110, 9111, 9112, 9113, 9114, -- arean
    9115, 9116, 9117, 9118, 9119, -- jovian
    9120, 9121, 9122, 9123, 9124, -- venerian
    9125, 9126, 9127, 9128, 9129, -- cyllenian
}
local fortuneItems =
{
    5737, 5736,       -- alexandrite
    6180, 6183, 6532, -- pluton
    6181, 6184, 6535, -- beitetsu
    6182, 6185, 6534, -- rift boulder
    5854, 5855, 5856, 5857, 5858, -- frayed pouches
    5109, 5110, 5111, 5112, 5946, 5947, 6264, 6345, 6346, 6370, 6486, 6487, 6488, -- frayed sacks
}
local anniversaryItems =
{
    -- TODO: The anniversary item table needs to be populated
    9274 -- just give them back their key until this table can be populated
}
local gobbieJunk =
{
    507,
    508,
    510,
    511,
    566,
    568,
    1239,
    1868,
    2542,
    2543,
    4539,
    4543,
    9777,
    15203,
    18180,
    19220,
}

local events =
{
    INTRO           = 20055,
    DEFAULT         = 20056,
    HOLDING_ITEM    = 20057,
    TRADE           = 20058,
    BAD_TRADE       = 20059,
    DAILY_COOLDOWN  = 20060,
    HIT_MAX         = 20061,
    RESULT          = 20064,
    KEY_TRADE       = 20065,
    NO_THANKS       = 20066,
    FULL_INV        = 20067,
    OTHER_BAD_TRADE = 20068
}

m:addOverride("xi.gobbieMysteryBox.onTrade", function(player, npc, trade, events)
    if player:isCrystalWarrior() then
        player:printToPlayer("This feature is unavailable to Crystal Warriors.", xi.msg.channel.SYSTEM_3)
        return
    end

    local playerMerits = player:getMeritCount()

    -- Handle merit exchange.
    if npcUtil.tradeHasExactly(trade, {{ 'gil', 1000 }}) then
        if playerMerits >= 25 then
            local menu  =
            {
                title = string.format("Trade 25 merits for special key? (%i available)", playerMerits),
                options =
                {
                    {
                        "Yes, please!",
                        function(playerArg)
                            if npcUtil.giveItem(player, 8973) then
                                player:setMerits(playerMerits - 25)
                            end
                        end,
                    },
                    {
                        "No, I change my mind.",
                        function(playerArg)
                            return false
                        end,
                    },
                },
            }
            player:customMenu(menu)
        end

    -- Handle box opening.
    elseif trade:getItemCount() == 1 then
        local tradeID = trade:getItemId(0)
        if keyToDial[tradeID] ~= nil then
            -- TODO: Without campaigns, there's currently no method for obtaining keys
            if player:getFreeSlotsCount() == 0 then
                player:startEvent(events.FULL_INV, tradeID, keyToDial[tradeID])
                return false
            end

            player:setLocalVar("gobbieBoxKey", tradeID)
            player:startEvent(events.KEY_TRADE, tradeID, keyToDial[tradeID])
        else -- trade for points
            -- TODO: Point system needs to be defined
            return false
        end
    else
        return false
    end
end)

return m
